<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php
/**
 * contactgmap Plugin
 */
	require_once("server/modules/class.contactitemmodule.php");
	require_once("server/modules/class.itemmodule.php");
	require_once("server/modules/class.module.php");

	class contactgmapitemmodule extends ContactItemModule 
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function contactgmapitemmodule($id, $data)
		{
			parent::ContactItemModule($id, $data);
		}

		/**
		 * Function which opens an item.
		 * Function finds cached data for business, home and other address 
		 * of the contact in associated contact property.
		 * If it finds the item then it adds cached data in response(item).
		 * message class property for associated item is 'Plugin.gmapcontactplugin.cache'
		 * @param object $store MAPI Message Store Object
		 * @param string $entryid entryid of the message
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure
		 */
		function open($store, $entryid, $action)
		{
			$message = mapi_msgstore_openentry($store, $entryid);
			$data = array();
			$data["attributes"] = array("type" => "item");

			$data["item"] = $GLOBALS["operations"]->getMessageProps($store, $message, $this->properties, false);

			// Open default user store.
			$userstore = $GLOBALS["mapisession"]->getDefaultMessageStore();

			// Get EntryId of Contact folder.
			$parententryid = $this->getDefaultFolderEntryID($userstore, "IPM.Contact");

			// Open contact folder
			$contactfolder = mapi_msgstore_openentry($userstore, $parententryid);

			// Get associated content table from user contacts.
			$table = mapi_folder_getcontentstable($contactfolder, MAPI_ASSOCIATED);

			/**
			 * Restriction for associated property of contact to open message with
			 * message class 'Plugin.gmapcontactplugin.cache'
			 */
			$restriction = array(	// Check for PR_MESSAGE_CLASS == Plugin.gmapcontactplugin.cache
				RES_CONTENT,
				array(
					FUZZYLEVEL => FL_FULLSTRING | FL_IGNORECASE,
					ULPROPTAG => PR_MESSAGE_CLASS,
					VALUE => 'Plugin.gmapcontactplugin.cache'
				)
			);
			// Fetch items from the associacted content table.
			$associateditems = mapi_table_queryallrows($table, array(PR_CONTACT_ADDRESS_CACHE, PR_SUBJECT, PR_ENTRYID, PR_MESSAGE_CLASS), $restriction);

			// Fetch entry id of GMapLocationCache item.
			$items = array();
			$messageentryid = null;

			if($associateditems[0][PR_ENTRYID]) {
				$messageentryid = $associateditems[0][PR_ENTRYID];
			}

			/**
			 * Open GMapLocationCache message.
			 * If it finds messege then store locations with in $data array.
			 */
			if($messageentryid) {
				$message = mapi_msgstore_openentry($userstore, $messageentryid);
				// Get Contents stored as cache from messages
				$messageprops = mapi_getprops($message, array(PR_CONTACT_ADDRESS_CACHE));
				
				// Get the significant address for business address, home address and other address.
				$locationsignificantaddress["business_address"] = $this->getSignicantAddress($data["item"]["business_address"]);
				$locationsignificantaddress["home_address"] = $this->getSignicantAddress($data["item"]["home_address"]);
				$locationsignificantaddress["other_address"] = $this->getSignicantAddress($data["item"]["other_address"]);

				/**
				 * Fetch the unserialize data of the contact folder's 
				 * Associate property PR_CONTACT_ADDRESS_CACHE
				 */
				$unserializedata = unserialize($messageprops[PR_CONTACT_ADDRESS_CACHE]);

				/**
				 * Check in array that whether business address location is already cached or not.
				 * If cached then add data in unserializedata array for business address.
				 */
				if(array_key_exists($locationsignificantaddress["business_address"], $unserializedata)) {
					$data["item"]["business_address_lat"] = $unserializedata[$locationsignificantaddress["business_address"]]["latitude"];
					$data["item"]["business_address_lng"] = $unserializedata[$locationsignificantaddress["business_address"]]["longitude"];	
				}

				/**
				 * Check in array that whether business address location is already cached or not.
				 * If cached then add data in unserializedata array for home address.
				 */
				if(array_key_exists($locationsignificantaddress["home_address"], $unserializedata)) {
					$data["item"]["home_address_lat"] = $unserializedata[$locationsignificantaddress["home_address"]]["latitude"];
					$data["item"]["home_address_lng"] = $unserializedata[$locationsignificantaddress["business_address"]]["longitude"];	
				}

				/**
				 * Check in array that whether business address location is already cached or not.
				 * If cached then add data in unserializedata array for other address.
				 */
				if(array_key_exists($locationsignificantaddress["other_address"], $unserializedata)) {
					$data["item"]["other_address_lat"] = $unserializedata[$locationsignificantaddress["other_address"]]["latitude"];
					$data["item"]["other_address_lng"] = $unserializedata[$locationsignificantaddress["other_address"]]["longitude"];
				}
			}

			// Send the data to the client
			array_push($this->responseData["action"], $data);
			$GLOBALS["bus"]->addData($this->responseData);
		}
		
		/**
		 * Function which saves cache data for contact addresses.
		 * It saves co-ordinates latitude and longitude of location 
		 * as cache in the associated property of contact.
		 * message class property for associated item is 'Plugin.gmapcontactplugin.cache'
		 * @param object $store MAPI Message Store Object
		 * @param string $parententryid parent entryid of the message
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure		 		 
		 */
		function save($store, $parententryid, $action)
		{
			// Open default user store.
			$userstore = $GLOBALS["mapisession"]->getDefaultMessageStore();

			// Get EntryId of Contact folder.
			$parententryid = $this->getDefaultFolderEntryID($userstore, "IPM.Contact");

			// Open contact folder
			$contactfolder = mapi_msgstore_openentry($userstore, $parententryid);

			// Get associated content table from user contacts.
			$table = mapi_folder_getcontentstable($contactfolder, MAPI_ASSOCIATED);

			/**
			 * Restriction for associated property of contact to open message with
			 * message class 'Plugin.gmapcontactplugin.cache'
			 */
			 $restriction = array(	// Check for PR_MESSAGE_CLASS == Plugin.gmapcontactplugin.cache
				RES_CONTENT,
				array(
					FUZZYLEVEL => FL_FULLSTRING | FL_IGNORECASE,
					ULPROPTAG => PR_MESSAGE_CLASS,
					VALUE => 'Plugin.gmapcontactplugin.cache'
				)
			);
			// Fetch items from the associacted content table.
			$associateditems = mapi_table_queryallrows($table, array(PR_CONTACT_ADDRESS_CACHE, PR_SUBJECT, PR_ENTRYID, PR_MESSAGE_CLASS), $restriction);

			// Fetch entry id of GMapLocationCache item.
			$items = array();
			$messageentryid = null;

			if($associateditems[0][PR_ENTRYID]) {
				$messageentryid = $associateditems[0][PR_ENTRYID];
			}
			
			// Open GMapLocationCache message.
			if($messageentryid) {
				$message = mapi_msgstore_openentry($userstore, $messageentryid);
			} else {
				// If we cant find messege then create message.
				$message = mapi_folder_createmessage($contactfolder, MAPI_ASSOCIATED);

				mapi_setprops($message, array(
						PR_SUBJECT => 'GMapLocationCache',
						PR_CONTACT_ADDRESS_CACHE => serialize(array()),
						PR_MESSAGE_CLASS => 'Plugin.gmapcontactplugin.cache'
					));

				mapi_savechanges($message);
			}

			$result = mapi_last_hresult();

			// Check for error in previous operation.
			if ($result == NOERROR) {
				// Get Contents stored as cache from messages
				$messageprops = mapi_getprops($message, array(PR_CONTACT_ADDRESS_CACHE));

				// Get the significant address.
				$sourceaddress = $this->getSignicantAddress($action["props"]["source_address"]);

				/**
				 * In caching data is need to be stored in string format.
				 * So array should be converted into serialized format.
				 * Append address and its latitude, longitude in the contact folder's associate property.
				 * First fetch the unserialize data of the contact folder's 
				 * Associate property PR_CONTACT_ADDRESS_CACHE
				 */
				$unserializedata = unserialize($messageprops[PR_CONTACT_ADDRESS_CACHE]);

				// Check in array that whether location is already stored or not.
				if($sourceaddress)
				{
					if(!array_key_exists($sourceaddress, $unserializedata)) {
						// Add data in unserializedata array.
						$unserializedata[$sourceaddress]["latitude"] = $action["props"]["source_lat"];
						$unserializedata[$sourceaddress]["longitude"] = $action["props"]["source_lng"];

						// Append serialize content with property.
						$serializedata = serialize($unserializedata);
						$messageprops[PR_CONTACT_ADDRESS_CACHE] = $serializedata;

						// Store property in MAPI
						mapi_setprops($message, $messageprops);

						// Update the MAPI property.
						mapi_savechanges($message);
					}
				}
				$destinationaddress = $this->getSignicantAddress($action["props"]["destination_address"]);
				if($destinationaddress)
				{
					if(!array_key_exists($destinationaddress, $unserializedata)) {
						// Add data in unserializedata array.
						$unserializedata[$destinationaddress]["latitude"] = $action["props"]["destination_lat"];
						$unserializedata[$destinationaddress]["longitude"] = $action["props"]["destination_lng"];

						// Append serialize content with property.
						$serializedata = serialize($unserializedata);
						$messageprops[PR_CONTACT_ADDRESS_CACHE] = $serializedata;

						// Store property in MAPI
						mapi_setprops($message, $messageprops);

						// Update the MAPI property.
						mapi_savechanges($message);
					}
				}
			}
		}

		/**
		 * Function which takes converts address string to significant
		 * string for saving/opening cached data.
		 * Function removes extra spaces, new lines, characters like ',' and '.'.
		 * @param string $data the string data which is contact address
		 * @return string signicantaddress which is not having extra spaces and some characters.
		 */
		function getSignicantAddress($data)
		{
			/**
			 * Remove the extra character which are responsible for ambiguous result.
			 * Add characters in $change array to remove that character from array
			 */
			$change = array("\r\n", "\n", "\r", "\t", ",", ".");
			$replace = ' ';
			$data = str_replace($change, $replace, $data);

			// Split the array with space to remove extra spaces from the middle.
			$dataarray = split(' ', $data);
			$arraylength = count($dataarray);
			$str = "";
			// Merge the content of the array.
			for($j = 0; $j<$arraylength; $j++)
			{
				if($dataarray[$j] != "")
					$str .= $dataarray[$j]." ";
			}
			// Trim whitespace from the end/start.
			$str = trim($str);

			// By default whole address should be displayed in lowercase.
			$signicantaddress = strtolower($str);

			// Return signicant address.
			return $signicantaddress;
		}
	}
?>
