/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/**
 * Gmap Plugin - Displays contact on gmap
 */

contactgmapitemmodule.prototype = new contactitemmodule;
contactgmapitemmodule.prototype.constructor = contactgmapitemmodule;
contactgmapitemmodule.superclass = contactitemmodule.prototype;

/**
 * Constructor 
 */ 
function contactgmapitemmodule(id, element, title, data)
{
	if(arguments.length > 0) {
		this.init(id, element, title, data);
	}
}

/**
 * Initialization
 */ 
contactgmapitemmodule.prototype.init = function(id, element, title, data) {
	/**
	 * It is object of GMap2 class which is the central class in the API
	 * All google map display handling is done with this object
	 */
	this.mapobj = new Object();

	contactgmapitemmodule.superclass.init.call(this, id, element, title, data);
	/**
	 * Default Icon object for marker icons.
	 * Property of this object is used everytime when marker icon is created.
	 */
	this.baseIcon = new GIcon();
	this.baseIcon.shadow = PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY + "/iconshadow.png";
	this.baseIcon.iconSize = new GSize(30, 30);
	this.baseIcon.shadowSize = new GSize(37, 34);
	this.baseIcon.iconAnchor = new GPoint(9, 34);
	this.baseIcon.infoWindowAnchor = new GPoint(9, 2);
	this.baseIcon.infoShadowAnchor = new GPoint(18, 25);

	// Array of markers to store list of marker if one address is resolved to multiple address.
	this.marker = new Array();
	// Array of address to store multiple resolved address.
	this.address = new Array();

	this.addressTypeFlag = "source";

	/**
	 * Properties array which stores address, latitude and longitude of resolved location
	 * And then it is used for sending caching request to the server.
	 */
	this.props = new Array();
}
/**
 * Function which initializes all googlemap objects 
 *
 */ 
contactgmapitemmodule.prototype.initContactGmapObjects = function() {
	var mapelement = dhtml.getElementById("map");
	this.mapobj = module.initGmapObject(mapelement);
	this.gmapZoomLevel = 13;
	
	// GClientGeocoder object.
	this.geo = new GClientGeocoder();

	// Element object of the right side directionpane.
	this.directionElement = dhtml.getElementById("directioninfo");
	
	// Element object of the error comment element.
	this.errorCommentElement = dhtml.getElementById("errorinfo");

	// Element object of the Get Direction button.
	this.getDirectionElement = dhtml.getElementById("Get_Direction");

	// Get the element for dispaying source marker e.g. Home, Business, other
	this.sourceMarkerElement = dhtml.getElementById("source");

	// Get the element for dispaying destiantion marker e.g. Home, Business, other
	this.destinationMarkerElement = dhtml.getElementById("destination");

	enableDisableInputFields(false);

	this.errorCommentString = dhtml.addElement(this.errorCommentElement, "div", false, "errorinfo_string");

	this.gdir = new GDirections(module.mapobj, this.directionElement);
	
	// Array of error messages sent by google map server when It cannot resolve.
	this.georequeststatuscode = new Array();
		this.georequeststatuscode[G_GEO_SUCCESS]				= dgettext("plugin_contactgmap", "Success") + ".";
		this.georequeststatuscode[G_GEO_MISSING_ADDRESS]		= dgettext("plugin_contactgmap", "Missing Address: The address was either missing or had no value") + ".";
		this.georequeststatuscode[G_GEO_UNKNOWN_ADDRESS]		= dgettext("plugin_contactgmap", "Unknown Address: No corresponding geographic location could be found for the specified address") + ".";
		this.georequeststatuscode[G_GEO_UNAVAILABLE_ADDRESS]	= dgettext("plugin_contactgmap", "Unavailable Address: The geocode for the given address cannot be returned due to legal or contractual reasons" + ".");
		this.georequeststatuscode[G_GEO_BAD_KEY]				= dgettext("plugin_contactgmap", "Bad Key: The API key is either invalid or does not match the domain for which it was given") + ".";
		this.georequeststatuscode[G_GEO_TOO_MANY_QUERIES]		= dgettext("plugin_contactgmap", "Too Many Queries: The daily geocoding quota for this site has been exceeded") + ".";
		this.georequeststatuscode[G_GEO_SERVER_ERROR]			= dgettext("plugin_contactgmap", "Server error: The geocoding request could not be successfully processed") + ".";
		this.georequeststatuscode[G_GEO_BAD_REQUEST]			= dgettext("plugin_contactgmap", "A directions request could not be successfully parsed") + ".";
		this.georequeststatuscode[G_GEO_MISSING_QUERY]			= dgettext("plugin_contactgmap", "No query was specified in the input") + ".";
		this.georequeststatuscode[G_GEO_UNKNOWN_DIRECTIONS]		= dgettext("plugin_contactgmap", "Google Map could not able to compute directions between the points") + ".";

	/**
	 * When gdirection request is send to the google map it returns path between two location
	 * But when errors are occured this "error" event occurs.
	 * so this function contains error handling and displaying error message in dialogbox.
	 */
	GEvent.addListener(this.gdir, "error", function() {
		var code = module.gdir.getStatus().code;
		var reason = "";
		if (module.georequeststatuscode[code]) {
			reason = module.georequeststatuscode[code];
		}

		dhtml.deleteAllChildren(module.directionElement);

		var latlngsource = module.sourcemarker.getLatLng();
		// Find addresstype marker of source address and send the type of marker to the createMarker.
		var addresstype = getAddresTypeAttribute("source_combo");
		createMarker("marker_0", latlngsource.lat(), latlngsource.lng(), module.sourcedisplayaddress, addresstype);

		var latlngdestination = module.destinationmarker.getLatLng();
		// Find addresstype marker of source address and send the type of marker to the createMarker.
		addresstype = getAddresTypeAttribute("destination_combo");
		createMarker("marker_1", latlngdestination.lat(), latlngdestination.lng(), module.destinationdisplayaddress, addresstype);

		/*
		 * Sets the center of the map
		 * latlngsource is the latitude and longitude of map.
		 * Second argument 13 is the zoom level for map.
		 * There are 1 to 20 zoom possible zoom levels.
		 */
		module.mapobj.setCenter(latlngsource, module.gmapZoomLevel);
		dhtml.deleteAllChildren(module.errorCommentElement);
		dhtml.addTextNode(module.errorCommentElement, reason);
		dhtml.addClassName(module.errorCommentElement, "errorinfo_marker_visible");
		dhtml.removeClassName(module.errorCommentElement, "errorinfo_marker_invisible");
		enableDisableInputFields(false);
	});
	
	/**
	 * When gdirection request is send to the google map it returns path between two location
	 * and then it adds path and marker overlays to the map.
	 * when overlays are added this "addoverlay" event occurs.
	 * Now their default markers are markerA and makerB but here it is needed to have
	 * a marker type like home business and other markers.
	 * So here when overlays are added to the map we remove the overlays and then
	 * add markers and polyline between the source and destination.
	 */
	GEvent.addListener(this.gdir, "addoverlay", function() {
		/**
		 * Here google map loads source marker images as markerA and destionation marker image as markerB
		 * but here we want to set marker images according to addresstype.
		 * So first clear all these markers and overlays.
		 */
		module.mapobj.clearOverlays();

		/**
		 * In drictionpane it contains markerA and markerB image.
		 * So here find the <img> elements and then chnage the src attribute of it.
		 */
		var imgs = getElementsByAttribute(module.directionElement, "img", "jsvalues");
		module.directionElement.style.visibility = "hidden";

		var sourcedestinationpathpolyline = module.gdir.getPolyline();
		module.mapobj.addOverlay(sourcedestinationpathpolyline);

		enableDisableInputFields(false);
		var latlngsource = module.sourcemarker.getLatLng();
		
		// If both location are same then no need to complete the path.
		if(sourcedestinationpathpolyline.getVertexCount() > 1)
		{
			var completepathsourcepolyline = new GPolyline([latlngsource, sourcedestinationpathpolyline.getVertex(0)], "#8583F3", 6, 0.7);
			module.mapobj.addOverlay(completepathsourcepolyline);
		}
		
		// Find addresstype marker of source address and send the type of marker to the createMarker.
		var sourceaddresstype = getAddresTypeAttribute("source_combo");
		createMarker("marker_0", latlngsource.lat(), latlngsource.lng(), module.sourcedisplayaddress, sourceaddresstype);
		setTimeout(function() { 
			setMarkerImage(imgs[0], sourceaddresstype);
			}, 5000);
		//setMarkerImage(imgs[0], addresstype);
		
		var latlngdestination = module.destinationmarker.getLatLng();

		if(sourcedestinationpathpolyline.getVertexCount() > 1)
		{
			var completepathdestinationpolyline = new GPolyline([latlngdestination, sourcedestinationpathpolyline.getVertex(sourcedestinationpathpolyline.getVertexCount()-1)], "#8583F3", 6, 0.7);
			module.mapobj.addOverlay(completepathdestinationpolyline);
		}

		// Find addresstype marker of destination address and send the type of marker to the createMarker.
		var destinationaddresstype = getAddresTypeAttribute("destination_combo");
		createMarker("marker_1", latlngdestination.lat(), latlngdestination.lng(), module.destinationdisplayaddress, destinationaddresstype);
		
		setTimeout(function() { 
			setMarkerImage(imgs[1], destinationaddresstype);
			}, 5000);
		//setMarkerImage(imgs[1], addresstype);
		
		setTimeout(function() {
			module.directionElement.style.visibility = "visible";
		}, 7000);
	});

}

/**
 * Function which execute an action. 
 *
 * @param string type the action type
 * @param object action the action tag 
 */ 
contactgmapitemmodule.prototype.execute = function(type, action) {

	// Call excute method of superclass.
	contactgmapitemmodule.superclass.execute.call(type, action);
	switch(type)
	{
		case "item":
			this.item(action);
			break;
		case "getAttachments":		// Uploaded Attachment list.
			this.attachmentsList(action);
			break;
	}
}

/**
 * Function which adds data in the dialogbox fields.
 * @param object action the action tag 
 */ 
contactgmapitemmodule.prototype.item = function(action) {
	var message = action.getElementsByTagName("item")[0];
	
	var addresstypearray = new Array();
	addresstypearray[0] = "business_address";
	addresstypearray[1] = "home_address";
	addresstypearray[2] = "other_address";
	// Saving all types of addresses in temporary array.
	var addresses = new Array();
	addresses[0] = dhtml.getXMLValue(message, "business_address", "").replace(/\n/g, " ");
	addresses[1] = dhtml.getXMLValue(message, "home_address", "").replace(/\n/g, " ");
	addresses[2] = dhtml.getXMLValue(message, "other_address", "").replace(/\n/g, " ");

	dhtml.getElementById("home_address_lat").value = dhtml.getXMLValue(message, "home_address_lat");
	dhtml.getElementById("home_address_lng").value = dhtml.getXMLValue(message, "home_address_lng");
	dhtml.getElementById("business_address_lat").value = dhtml.getXMLValue(message, "business_address_lat");
	dhtml.getElementById("business_address_lng").value = dhtml.getXMLValue(message, "business_address_lng");
	dhtml.getElementById("other_address_lat").value = dhtml.getXMLValue(message, "other_address_lat");
	dhtml.getElementById("other_address_lng").value = dhtml.getXMLValue(message, "other_address_lng");

	dhtml.getElementById("home_address").value = dhtml.getXMLValue(message, "home_address");
	dhtml.getElementById("business_address").value = dhtml.getXMLValue(message, "business_address");
	dhtml.getElementById("other_address").value = dhtml.getXMLValue(message, "other_address");

	this.defaultAddress = "home";
	if(PLUGIN_CONTACTGMAP_CONTACTS_AS_DEFAULT_LOCATION)
		this.setContactsDefaultAddress();

	// Adding address in source amd destination comboboxes.
	var sourceComboElement = dhtml.getElementById("source_combo");
	var destinationComboElement = dhtml.getElementById("destination_combo");
	
	/**
	 * source_address_type_icon is the flag
	 * 0 -> Business.
	 * 1 -> Home.
	 * 2 -> Other.
	 * 3 -> custom. 
	 */
	this.address_type_icon = 3;
	// Set address type flag with each option of source and destination combobox.
	for(var i = 0; i < addresses.length; i++)
	{	
		if(addresses[i].trim() != ""){
			var sourceOption = dhtml.addElement(sourceComboElement, "option");
			sourceOption.value = addresses[i];
			sourceOption.text = addresses[i];
			sourceOption.setAttribute("addresstype", addresstypearray[i]);

			if(this.address_type_icon == 3)
				this.address_type_icon = i;

			var destinationOption = dhtml.addElement(destinationComboElement, "option");
			destinationOption.value = addresses[i];
			destinationOption.text = addresses[i];
			destinationOption.setAttribute("addresstype", addresstypearray[i]);
		}
	}
	this.setContactTypeMarker(this.sourceMarkerElement, this.address_type_icon, "_pointer");
	this.setContactTypeMarker(this.destinationMarkerElement, this.address_type_icon, "_pointer");
}

/**
 * Function will set the addresstype marker of different elements.
 * Elements are source and destination marker of address_selection_field, errorinfo and shownotice.
 * @param object element element in which adresstype marker is need to be added.
 * @param string markerid type of an address type marker e.g. business, home and other.
 * @param object flag it is a type of marker whether it is a pointer or a simple.
 */
contactgmapitemmodule.prototype.setContactTypeMarker = function(element, markerid, flag) {
	switch (markerid)
	{
		case "business_address":
		case 0:
			dhtml.removeClassName(element, "icon_home" + flag);
			dhtml.removeClassName(element, "icon_other" + flag);
			dhtml.addClassName(element, "icon_business" + flag);
		break;
		case "home_address":
		case 1:
			dhtml.removeClassName(element, "icon_business" + flag);
			dhtml.removeClassName(element, "icon_other" + flag);
			dhtml.addClassName(element, "icon_home" + flag);
		break;
		default:
			dhtml.removeClassName(element, "icon_business" + flag);
			dhtml.removeClassName(element, "icon_home" + flag);
			dhtml.addClassName(element, "icon_other" + flag);
		break;
	}
}
/**
 * Function will create an object of class GMap2 in order to create a map.
 * @param object mapelement in which googlemap will be loaded
 * @return object map this object handles the all map functionalities.
 */
contactgmapitemmodule.prototype.initGmapObject = function(mapelement) {
	var map = new GMap2(mapelement);
	/**
	 * set UI for the map which internally performs these functions.
	 * map.addControl(new GLargeMapControl());
	 * map.addControl(new GMapTypeControl());
	 * map.addControl(new GScaleControl());
	 */
	map.setUIToDefault();

	// add OverviewMapControl in the googlemap.
	map.addControl(new GOverviewMapControl());

	return map;
}

/**
 * Function will set cet center of the map as one of the contact's address.
 * It will set address home, business and other address in priority.
 */
contactgmapitemmodule.prototype.setContactsDefaultAddress = function()
{
	var address = dhtml.getElementById(this.defaultAddress + "_address").value;
	if(address == "" || address == "null"){
		if(this.defaultAddress == "home"){
			this.defaultAddress = "business";
			this.setContactsDefaultAddress();
			return;
		} else if(this.defaultAddress == "business"){
			this.defaultAddress = "other";
			this.setContactsDefaultAddress();
			return;
		} else if(this.defaultAddress == "other"){
			this.defaultAddress = "home";
			this.mapobj.setCenter(PLUGIN_CONTACTGMAP_DEFAULT_MAP_CENTER, PLUGIN_CONTACTGMAP_DEFAULT_MAP_ZOOM_LEVEL);
			return;
		}
	}
	this.addressTypeFlag = "default location";
	this.getGeoLocationsFromGoogle(address);
}

/**
 * Function will fetch source address from the dialogbox.
 * @return string sourceaddress source address.
 */
contactgmapitemmodule.prototype.getSourceAddress = function()
{
	var sourceaddress;
	if (dhtml.getElementById("select_source_combo").checked) {
		var source = dhtml.getElementById("source_combo");
		if(source.selectedIndex != -1)
			sourceaddress = source.options[source.selectedIndex].text;
		else
			sourceaddress = "";
	} else{
		var source = dhtml.getElementById("source_text");
		sourceaddress = source.value;
	}
	return sourceaddress.trim();
}

/**
 * Function will fetch destination address from the dialogbox.
 * @return string destinationaddress destination address.
 */
contactgmapitemmodule.prototype.getdestinationAddress = function()
{
	var destinationaddress;
	if (dhtml.getElementById("select_destination_combo").checked) {
		var destination = dhtml.getElementById("destination_combo");
		if(destination.selectedIndex != -1)
			destinationaddress = destination.options[destination.selectedIndex].text;
		else
			destinationaddress = "";
	} else{
		var destination = dhtml.getElementById("destination_text");
		destinationaddress = destination.value;
	}
	return destinationaddress.trim();
}

/**
 * Function is called by on click event of getDirection button in contactgmap dialog.
 * It will initialize all variable of the map.
 * Then it will start with sourceaddress fetching.
 */
contactgmapitemmodule.prototype.getDirection = function()
{
	enableDisableInputFields(true);
	this.mapobj.clearOverlays();
	
	dhtml.addClassName(this.errorCommentElement, "errorinfo_marker_invisible");
	dhtml.removeClassName(this.errorCommentElement, "errorinfo_marker_visible");
	dhtml.deleteAllChildren(this.errorCommentString);
	dhtml.deleteAllChildren(this.directionElement);

	// sourcemarker saves marker object for source.
	this.sourcemarker = null;

	/** 
	* sourcedisplayaddress saves resolved address for source.
	* When address is resolved geocode sends a detailed address of that location.
	* This address is store in sourcedisplayaddress variable.
	*/
	this.sourcedisplayaddress = null;
	// destinationmarker saves marker object for source.
	this.destinationmarker = null;

	// Empty previously filled errorCommentString.
	dhtml.deleteAllChildren(this.errorCommentString);

	/** 
	* destinationdisplayaddress saves resolved address for source.
	* When address is resolved geocode sends a detailed address of that location.
	* This address is store in destinationdisplayaddress variable.
	*/
	this.destinationdisplayaddress = null;
	
	// Assign address type to addressTypeFlag
	this.addressTypeFlag = "source";

	sourceaddress = module.getSourceAddress();

	// Resolve source address and find geocode.
	if(sourceaddress != "") {
		this.getGeoLocationsFromGoogle(sourceaddress);
	} else {
		this.sourcemarker = null;
		this.destinationmarker = null;
		var sourceicondiv = dhtml.addElement(this.errorCommentString, "div", "icon");
		
		// If address string is empty then set other address marker in errorcommentstring.
		this.setContactTypeMarker(sourceicondiv, 3, "");

		dhtml.addTextNode(this.errorCommentString, this.georequeststatuscode[G_GEO_MISSING_ADDRESS]);
		this.findGDirection();
	}
}


/**
 * Function which first checks for cached data and if cached data is not available then it sends request for geocoding.
 * @param string search passes this string to the GClientGeocoder for resolving address.
 */
contactgmapitemmodule.prototype.getGeoLocationsFromGoogle = function(search) {
	/** 
	 * getLocations() method performs a geocode, 
	 * It converts a human-readable address into a latitude/longitude pair.
	 * getLocations() sends a request to the Google geocoding service,
	 * asking it to parse the given address and handle the response in the callback function resolvedaddress.
	 */
	if(search == dhtml.getElementById("business_address").value && 
		!isNaN(parseFloat(dhtml.getElementById("business_address_lat").value)) && 
		!isNaN(parseFloat(dhtml.getElementById("business_address_lng").value)))	{

		var lat = dhtml.getElementById("business_address_lat").value;
		var lng = dhtml.getElementById("business_address_lng").value;
		var address = dhtml.getElementById("business_address").value;

		if(this.addressTypeFlag == "default location"){
			this.mapobj.setCenter(new GLatLng(lat, lng), this.gmapZoomLevel);
		}else if(this.addressTypeFlag == "source"){
			createMarker("marker_0", lat, lng, address);
			this.sourcemarker = this.marker["marker_0"];
			this.sourcedisplayaddress = address;
			this.resolveDestinationAddress();

		}else if(this.addressTypeFlag == "destination"){
			createMarker("marker_0", lat, lng, address);
			this.destinationmarker = this.marker["marker_0"];
			this.destinationdisplayaddress = address;
			this.findGDirection();
		}
	}else if(search == dhtml.getElementById("home_address").value && 
		!isNaN(parseFloat(dhtml.getElementById("home_address_lat").value)) && 
		!isNaN(parseFloat(dhtml.getElementById("home_address_lng").value))){

		var lat = dhtml.getElementById("home_address_lat").value;
		var lng = dhtml.getElementById("home_address_lng").value;
		var address = dhtml.getElementById("home_address").value;
		
		if(this.addressTypeFlag == "default location"){
			this.mapobj.setCenter(new GLatLng(lat, lng), this.gmapZoomLevel);
		}else if(this.addressTypeFlag == "source"){
			createMarker("marker_0", lat, lng, address);
			this.sourcemarker = this.marker["marker_0"];
			this.sourcedisplayaddress = address;
			this.resolveDestinationAddress();

		}else if(this.addressTypeFlag == "destination"){
			createMarker("marker_0", lat, lng, address);
			this.destinationmarker = this.marker["marker_0"];
			this.destinationdisplayaddress = address;
			this.findGDirection();
		}

	}else if(search == dhtml.getElementById("other_address").value && 
		!isNaN(parseFloat(dhtml.getElementById("other_address_lat").value)) && 
		!isNaN(parseFloat(dhtml.getElementById("other_address_lng").value))){

		var lat = dhtml.getElementById("other_address_lat").value;
		var lng = dhtml.getElementById("other_address_lng").value;
		var address = dhtml.getElementById("other_address").value;
		
		if(this.addressTypeFlag == "default location"){
			this.mapobj.setCenter(new GLatLng(lat, lng), this.gmapZoomLevel);
		}else if(this.addressTypeFlag == "source"){
			createMarker("marker_0", lat, lng, address);
			this.sourcemarker = this.marker["marker_0"];
			this.sourcedisplayaddress = address;
			this.resolveDestinationAddress();

		}else if(this.addressTypeFlag == "destination"){
			createMarker("marker_0", lat, lng, address);
			this.destinationmarker = this.marker["marker_0"];
			this.destinationdisplayaddress = address;
			this.findGDirection();
		}
	}else{
		this.geo.getLocations(search, module.resolvedaddress);
	}
}

/**
 * Function will resolve address.
 * There are three options for resolved address
 * 1) No locations : In this case it will show an error message.
 * 2) One location : In this case it will take that address as a resolved address.
 * 3) More than one locations : In this case it will show all possible 
 *    location in gdirection pane at left side. User can choose address from there.
 * @param object result this is an object sent by the google map api after resolving address
 *						It contains an array of possible resolve addresses.
 * @return object map this object handles the all map functionalities.
 */
contactgmapitemmodule.prototype.resolvedaddress = function(result) {
	// for an address if it is resolved then result.status.code value will be G_GEO_SUCCESS
	if (result.Status.code == G_GEO_SUCCESS) {
		/*
		 * If more than one locations are resolved for the address.
		 * Then display those placemarks in right side directionpane
		 */
		if(result.Placemark.length > 1)	{
			enableDisableInputFields(false);

			dhtml.deleteAllChildren(module.directionElement);

			if(module.addressTypeFlag == "default location"){
				var coords = result.Placemark[0].Point.coordinates;
				module.mapobj.setCenter(new GLatLng(coords[1], coords[0]), module.gmapZoomLevel);
				return;
			}else if(module.addressTypeFlag == "source") {
				var markerdiv = dhtml.addElement(module.directionElement, "div", "shownotice");
				var sourcemarkerdiv = dhtml.addElement(markerdiv, "div", "icon");

				// Find addresstype marker of source address and send the type of marker to the createMarker.
				var addresstype = getAddresTypeAttribute("source_combo");
				module.setContactTypeMarker(sourcemarkerdiv, addresstype, "");

				dhtml.addTextNode(markerdiv, dgettext("plugin_contactgmap", "Did you mean") + ":");
			} else if(module.addressTypeFlag == "destination"){
				// If there is an error then display it.
				var markerdiv = dhtml.addElement(module.directionElement, "div", "shownotice");
				var destinationmarkerdiv = dhtml.addElement(markerdiv, "div", "icon");

				// Find addresstype marker of destination address and send the type of marker to the createMarker.
				var addresstype = getAddresTypeAttribute("destination_combo");
				module.setContactTypeMarker(destinationmarkerdiv, addresstype, "");

				dhtml.addTextNode(markerdiv, dgettext("plugin_contactgmap", "Did you mean") + ":");
			}

			var locationlisttable = dhtml.addElement(module.directionElement, "table", "gamptablenoborder", "locationList");
			var locationlisttbody = dhtml.addElement(locationlisttable, "tbody");

			// display all resolved placemarks in right side directionpane
			var placeMarkLength = result.Placemark.length;
			for(var i = 0; i<placeMarkLength; i++)
			{
				var placemark = result.Placemark[i];
				var coords = placemark.Point.coordinates;
				var address = placemark.address;
				createMarker("marker_" + i, coords[1], coords[0], address);

				var locationlistrow = dhtml.addElement(locationlisttbody, "tr");
				var locationlistfirstdata = dhtml.addElement(locationlistrow, "td", "tabledata");

				var icondiv = dhtml.addElement(locationlistfirstdata, "div", "icon gmapicons icon_iconb" + (i + 1), "marker_" + i);
				dhtml.addEvent(-1, icondiv, "click", eventShowMarker);

				var locationlistseconddata = dhtml.addElement(locationlistrow, "td");
				var locationreference = dhtml.addElement(locationlistseconddata, "a", "gamplocationlistpointer", "marker_" + i);
				dhtml.addEvent(module, locationreference, "click", saveMarker);
				dhtml.addTextNode(locationreference, address);
			}

			showMarkerByArrayID("marker_0");
		}

		/**
		 * If only one location is resolved for the address then save it and 
		 * If it is source then call resolveDestinationAddress() for resolving destination address.
		 * If it is destination then call findGDirection() for showing directions.
		 */
		else if(result.Placemark.length == 1) {
			var p = result.Placemark[0].Point.coordinates;
			var lat = p[1];
			var lng = p[0];
			var address = result.Placemark[0].address;
			
			/*
			 * If address is selected from the combobox then it is the part of contact address
			 * So if it is resolved to one location then it is need to be cached.
			 */
			if(module.addressTypeFlag == "default location"){
				var coords = result.Placemark[0].Point.coordinates;
				module.mapobj.setCenter(new GLatLng(coords[1], coords[0]), module.gmapZoomLevel);
				return;
			}else if(module.addressTypeFlag == "source") {
				// Draw addresstype marker in source div according to source address selection.
				var addresstype = getAddresTypeAttribute("source_combo");
				createMarker("marker_0", lat, lng, address, addresstype);
				if(dhtml.getElementById("select_source_combo").checked) {
					module.locationResolved("source", module.getSourceAddress(), lat, lng);
				}
				module.sourcemarker = module.marker["marker_0"];
				module.sourcedisplayaddress = address;
				module.resolveDestinationAddress();

			}else if(module.addressTypeFlag == "destination") {
				// Draw addresstype marker in destination div according to destination address selection.
				var addresstype = getAddresTypeAttribute("destination_combo");
				createMarker("marker_0", lat, lng, address, addresstype);
				if(dhtml.getElementById("select_destination_combo").checked) {
					module.locationResolved("destination", module.getdestinationAddress(), lat, lng);
				}
				module.destinationmarker = module.marker["marker_0"];
				module.destinationdisplayaddress = address;
				module.findGDirection();
			}
		}
	}
	/**
	 * If no locations are resolved for the address then 
	 * display error message in right side dirctionpane.
	 */
	else {
		if(module.addressTypeFlag == "default location"){
			if(module.defaultAddress == "home"){
				module.defaultAddress = "business";
				module.setContactsDefaultAddress();
				return;
			} else if(module.defaultAddress == "business"){
				module.defaultAddress = "other";
				module.setContactsDefaultAddress();
				return;
			} else if(module.defaultAddress == "other"){
				module.defaultAddress = "home";
			}
			module.mapobj.setCenter(PLUGIN_CONTACTGMAP_DEFAULT_MAP_CENTER, PLUGIN_CONTACTGMAP_DEFAULT_MAP_ZOOM_LEVEL);
			return;
		}else if(module.addressTypeFlag == "source") {
			module.sourcemarker = null;
			var sourceicondiv = dhtml.addElement(module.errorCommentString, "div", "icon");

			// Find addresstype marker of source address and attach the marker to the errorcomment string.
			var addressType = getAddresTypeAttribute("source_combo");
			module.setContactTypeMarker(sourceicondiv, addressType, "");

			dhtml.addTextNode(module.errorCommentString, module.georequeststatuscode[result.Status.code]);
			module.findGDirection();

		} else if(module.addressTypeFlag == "destination") {
			var destinationicondiv = dhtml.addElement(module.errorCommentString, "div", "icon");

			// Find addresstype marker of destination address and attach the marker to the errorcomment string.
			var addressType = getAddresTypeAttribute("destination_combo");
			module.setContactTypeMarker(destinationicondiv, addressType, "");

			dhtml.addTextNode(module.errorCommentString, module.georequeststatuscode[result.Status.code]);

			module.destinationmarker = null;
			module.findGDirection();
		}
	}
}

/**
 * Function will resolve destination address.
 * After Source address resolved this function is called for resolving destination address.
 */
contactgmapitemmodule.prototype.resolveDestinationAddress = function() {
	if(this.addressTypeFlag == "source") {
		this.addressTypeFlag = "destination";
		destinationaddress = module.getdestinationAddress();

		if(destinationaddress != ""){
			// Resolve Geocode for Destination address.
			this.getGeoLocationsFromGoogle(destinationaddress);

		} else {
			var destinationicondiv = dhtml.addElement(this.errorCommentString, "div", "icon");

			// If address string is empty then set other address marker in errorcommentstring.
			this.setContactTypeMarker(destinationicondiv, 3, "");
			dhtml.addTextNode(this.errorCommentString, this.georequeststatuscode[G_GEO_MISSING_ADDRESS]);
			this.findGDirection();
		}

	}else if(this.addressTypeFlag == "destination") {
		dhtml.deleteAllChildren(this.directionElement);
	}
	
}

/**
 * When one location is resolved this function will be called which is used for caching.
 * @param object mapelement in which googlemap will be loaded
 * @return object map this object handles the all map functionalities.
 */
contactgmapitemmodule.prototype.locationResolved = function(type, address, lat, lng)
{
	if(address == dhtml.getElementById("business_address").value){
		dhtml.getElementById("business_address_lat").value = lat;
		dhtml.getElementById("business_address_lng").value = lng;
	}else if(address == dhtml.getElementById("home_address").value){
		dhtml.getElementById("home_address_lat").value = lat;
		dhtml.getElementById("home_address_lng").value = lng;
	}else if(address == dhtml.getElementById("other_address").value){
		dhtml.getElementById("other_address_lat").value = lat;
		dhtml.getElementById("other_address_lng").value = lng;
	}
	this.props[type + "_address"] = address;
	this.props[type + "_lat"] = lat;
	this.props[type + "_lng"] = lng;
}

/**
 * Function uses a gdirection object and displays the path between two points.
 * This function uses GDirection object for resolving path
 * If only one address is resolved then that is shown and error for other address is shown in directionpane.
 * If both address are not resolved then errors for both address is shown in directionpane.
 */
contactgmapitemmodule.prototype.findGDirection = function()
{
	// Send caching request.
	for (x in this.props){
		this.save(this.props);
		break;
	}

	this.mapobj.clearOverlays();
	/*
	 * If source address and destination address are resolved then
	 * Display path.
	 */
	if(this.sourcemarker != null && this.destinationmarker != null) {
		//this.directionElement.innerHTML = "";
		dhtml.deleteAllChildren(this.directionElement);
		// Source co-ordinates in latitude longitude format.
		var latlngsource = this.sourcemarker.getLatLng();
		// Destination co-ordinates in latitude longitude format.
		var latlngdestination = this.destinationmarker.getLatLng();

		// Get the language from settings.
		var localSettings = webclient.settings.get("global/language", "en_EN");
		/**
		 * GDirection object gdir resolves path between two locations with passed two location co-ordinates.
		 * Also set the language according to setting.
		 * Now description of path in direction pane will be according to settings language.
		 */
		this.gdir.load("from: " + latlngsource + " to: " + latlngdestination, {locale:localSettings});
	}
	/**
	 * if source marker is not resolved then resolving destination marker is held down.
	 * So in this case : Show error message in right side directionpane for source address.
	 */
	else if(this.sourcemarker == null && this.destinationmarker == null) {
		//this.errorCommentElement.innerHTML = this.errorCommentString;
		dhtml.addClassName(this.errorCommentElement, "errorinfo_marker_visible");
		dhtml.removeClassName(this.errorCommentElement, "errorinfo_marker_invisible");
		enableDisableInputFields(false);
	}
	/**
	 * If source address is not resolved and destination address is resolved then
	 * Show error message in right side directionpane for source address.
	 * Show destnation marker in map.
	 */
	else if(this.sourcemarker == null){
		var latlngdestination = this.destinationmarker.getLatLng();

		var addresstype = getAddresTypeAttribute("destination_combo");
		// Create marker for destination
		createMarker("marker_0", latlngdestination.lat(), latlngdestination.lng(), this.destinationdisplayaddress, addresstype);

		this.mapobj.setCenter(latlngdestination, this.gmapZoomLevel);

		dhtml.addClassName(this.errorCommentElement, "errorinfo_marker_visible");
		dhtml.removeClassName(this.errorCommentElement, "errorinfo_marker_invisible");
		enableDisableInputFields(false);
	}
	/**
	 * If source address is resolved and destination address is not resolved then
	 * Show source marker in map.
	 * Show error message in right side directionpane for destination address.
	 */
	else if(this.destinationmarker == null){
		var latlngsource = this.sourcemarker.getLatLng();

		// Find addresstype marker of source address and send the type of marker to the createMarker.
		var addresstype = getAddresTypeAttribute("source_combo");
		var sourceComboElement = dhtml.getElementById("source_combo");
		// Create marker for source
		createMarker("marker_0", latlngsource.lat(), latlngsource.lng(), this.sourcedisplayaddress, addresstype);

		this.mapobj.setCenter(latlngsource, this.gmapZoomLevel);
		dhtml.addClassName(this.errorCommentElement, "errorinfo_marker_visible");
		dhtml.removeClassName(this.errorCommentElement, "errorinfo_marker_invisible");
		enableDisableInputFields(false);

		var newline = dhtml.addElement(this.directionElement, "br");
		var sourceicondiv = dhtml.addElement(this.directionElement, "div", "icon", "source");

		// According to addresstype marker of destination address and send the type of marker to the createMarker.
		this.setContactTypeMarker(sourceicondiv, addresstype, "_pointer");
		dhtml.addEvent(module, sourceicondiv, "click", eventViewMarker);

		var sourcelocationreference = dhtml.addElement(this.directionElement, "a", "gamplocationlistpointer", "source");

		dhtml.addEvent(module, sourcelocationreference, "click", eventViewMarker);
		dhtml.addTextNode(sourcelocationreference, this.sourcedisplayaddress);
	}
}

/**
 * Function resize the dialog box elements like directionpane and map element when dialogbox is resized
 */
contactgmapitemmodule.prototype.resize = function()
{
	// Fetch the height of window title element.
	title_element_height = dhtml.getElementById("windowtitle").offsetHeight;

	// Fetch the height of subtitle element.
	subtitle_element_height = dhtml.getElementById("subtitle").offsetHeight;

	// Get the map element and set height according to resize.
	map_element = dhtml.getElementById("map");
	map_element.style.height = document.documentElement.offsetHeight - 40 - subtitle_element_height - title_element_height + "px";

	/**
	 * Fetch the height of inputfield element which contains combobox and textfield
	 * for selecting source and destination address.
	 */
	address_selection_field_element_height = dhtml.getElementById("address_selection_field").offsetHeight;

	// Fetch the height of errorcomment element which is used for displaying error.
	errorcomment_element_height = dhtml.getElementById("errorinfo").offsetHeight;
	
	// Get the directions element and set height according to resize.
	directions_element = dhtml.getElementById("directioninfo");
	if (errorcomment_element_height != 0){
		errorcomment_element_height += 10;
	}
	directions_element.style.height = document.documentElement.offsetHeight - 60 - address_selection_field_element_height - subtitle_element_height - title_element_height - errorcomment_element_height + "px";
}