/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/**
 * Function will create a marker object and will display in google map.
 * @param integer id for distinguishing markers.
 * @param object lat latitude of the marker.
 * @param object lng longitude of the marker.
 * @param string address display contents of info window.
 * @param string iconType demotes type of image that marker needs e.g. home, factory and sphere image.
 */
function createMarker(id, lat, lng, address, iconType)
{
	// Create icon for maker.
	var icon = new GIcon(module.baseIcon);

	icon.image = PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY + "/iconb" + (id+1) + ".png";

	if(isNaN(id))
	{
		markerid = Number(id.replace("marker_",""));
		icon.image = PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY + "/iconb" + (markerid + 1) + ".png";
	}
	// If iconType is set then load image accordingly.
	if(iconType)
	{
		switch (iconType)
		{
			case "home_address":
				icon.image = PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY + "/icon_home.png";
			break;
			case "business_address":
				icon.image = PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY + "/icon_business.png";
			break;
			default:
				icon.image = PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY + "/icon_other.png";
			break;
		}
	}

	var latlng = new GLatLng(lat, lng);
	module.marker[id] = new GMarker(latlng, icon);
	module.address[id] = address;
	
	// onClick event for markers. It displays infowindow.
	GEvent.addListener(module.marker[id], "click", function() {
		module.marker[id].openInfoWindow(address);
	});

	// Add marker in googlemap
	module.mapobj.addOverlay(module.marker[id]);
}

/**
 * Function will set map as marker in center.
 * @param object element marker object.
 */
function eventViewMarker(moduleObject, element, event)
{
	var elementId = element.id;

	if(elementId == "source" && moduleObject.sourcemarker) {
		moduleObject.mapobj.setCenter(moduleObject.sourcemarker.getLatLng(), moduleObject.gmapZoomLevel);
	} else if(elementId == "destination" && moduleObject.destinationmarker) {
		moduleObject.mapobj.setCenter(moduleObject.destinationmarker.getLatLng(), moduleObject.gmapZoomLevel);
	} else {
		if(elementId == "source") {
			dhtml.deleteAllChildren(moduleObject.errorCommentString);

			// Draw addresstype marker in source div according to source address selection.
			var sourceicondiv = dhtml.addElement(moduleObject.errorCommentString, "div", "icon");
			
			var addressType = getAddresTypeAttribute("source_combo");
			moduleObject.setContactTypeMarker(sourceicondiv, addressType, "");
			dhtml.addTextNode(moduleObject.errorCommentString, dgettext("plugin_contactgmap", "Source marker can not found") + ".");

			dhtml.addClassName(moduleObject.errorCommentElement, "errorinfo_marker_visible");
			dhtml.removeClassName(moduleObject.errorCommentElement, "errorinfo_marker_invisible");
		} else if(elementId == "destination") {
			dhtml.deleteAllChildren(moduleObject.errorCommentString);

			// Draw addresstype marker in destination div according to destination address selection.
			var destinationicondiv = dhtml.addElement(moduleObject.errorCommentString, "div", "icon");

			var addressType = getAddresTypeAttribute("destination_combo");
			moduleObject.setContactTypeMarker(sourceicondiv, addressType, "");

			dhtml.addTextNode(moduleObject.errorCommentString, dgettext("plugin_contactgmap", "Destination marker can not found") + ".");

			dhtml.addClassName(moduleObject.errorCommentElement, "errorinfo_marker_visible");
			dhtml.removeClassName(moduleObject.errorCommentElement, "errorinfo_marker_invisible");
		}
	}
}

/**
 * Function will save marker as sourcemarker or destinationmarker for further use.
 * It also saves sourcedisplayaddress and destinationdisplayaddress for infowindow of marker.
 * If address is
 * A) source address then resolve destination address
 * B) destination address then resolve directions.
 * @param integer id it is an index in marker array.
 */
function saveMarker(moduleObject, element, event)
{
	var id = element.id;
	dhtml.deleteAllChildren(moduleObject.errorCommentString);
	dhtml.deleteAllChildren(moduleObject.directionElement);
	dhtml.addClassName(module.errorCommentElement, "errorinfo_marker_invisible");
	dhtml.removeClassName(module.errorCommentElement, "errorinfo_marker_visible");

	if(moduleObject.addressTypeFlag == "source")
	{
		moduleObject.sourcemarker = moduleObject.marker[id];
		moduleObject.sourcedisplayaddress = moduleObject.address[id];
		var sourceTextElement = dhtml.getElementById("source_text");
		var selectSourceTextElement = dhtml.getElementById("select_source_text");
		sourceTextElement.value = moduleObject.sourcedisplayaddress;
		dhtml.setValue(selectSourceTextElement, true);
		eventChangeAddressFieldFocus(moduleObject, sourceTextElement, false);

		moduleObject.resolveDestinationAddress();
	}
	else if(moduleObject.addressTypeFlag == "destination")
	{
		moduleObject.destinationmarker = moduleObject.marker[id];
		moduleObject.destinationdisplayaddress = moduleObject.address[id];
		
		var destinationTextElement = dhtml.getElementById("destination_text");
		var selectDestinationTextElement = dhtml.getElementById("select_destination_text");
		destinationTextElement.value = moduleObject.destinationdisplayaddress;
		dhtml.setValue(selectDestinationTextElement, true);
		eventChangeAddressFieldFocus(moduleObject, destinationTextElement, false);

		moduleObject.findGDirection();
	}
	enableDisableInputFields(true);
}

/**
 * Function will set map as marker in center.
 * @param integer markerid it is an index in marker array.
 */
function eventShowMarker(moduleObject, element, event)
{
	var markerid = element.id;
	// Call showMarkerByArrayID function for showing marker in center.
	showMarkerByArrayID(markerid);
}

/**
 * Function will set map as marker in center.
 * @param integer markerid it is an index in marker array.
 */
function showMarkerByArrayID(markerid)
{
	module.mapobj.setCenter(module.marker[markerid].getLatLng(), module.gmapZoomLevel);
}

/**
 * Function will check the radiobutton.
 * It will call eventChangeAddressFieldFocus for setting addresstype marker in source/destination marker ekement.
 * @param string element.id gives the id of radiobutton.
 */
function eventOnChecked(moduleObject, element, event)
{
	var element = dhtml.getElementById(element.id.replace("select_",""));
	eventChangeAddressFieldFocus(moduleObject, element, event);
}

/**
 * Function will auto-check the radiobutton.
 * Function will draw addresstype marker in source and destination div
 * according to source and destination address selection.
 * @param string element.id gives the id of radiobutton.
 */
function eventChangeAddressFieldFocus(moduleObject, element, event)
{
	// Select the element and set the checked value to true to make radio button checked.
	switch (element.id)
	{
		case "source_combo":
			var radio_button_element = dhtml.getElementById("select_source_combo");
			var addressType = getAddresTypeAttribute("source_combo");
			moduleObject.setContactTypeMarker(moduleObject.sourceMarkerElement, addressType, "_pointer");
		break;

		case "source_text":
			var radio_button_element = dhtml.getElementById("select_source_text");
			moduleObject.setContactTypeMarker(moduleObject.sourceMarkerElement, 3, "_pointer");
		break;

		case "destination_combo":
			var radio_button_element = dhtml.getElementById("select_destination_combo");
			var addressType = getAddresTypeAttribute("destination_combo");
			moduleObject.setContactTypeMarker(moduleObject.destinationMarkerElement, addressType, "_pointer");
		break;

		case "destination_text":
			var radio_button_element = dhtml.getElementById("select_destination_text");
			moduleObject.setContactTypeMarker(moduleObject.destinationMarkerElement, 3, "_pointer");
		break;
	}
	dhtml.setValue(radio_button_element, true);
}

/**
 * Function which calls getDirection method of contactgmapitemmodule.
 * @param object moduleObject module object ofcontactgmapitemmodule.
 */
function eventGetDirection(moduleObject, element, event)
{
	moduleObject.getDirection();
}

/**
 * Function which attaches event with div element which shows source/destination marker.
 * callback function shows source/ destination marker in center of the map.
 * @param object element HTML element of div.
 */
function setShowMarkerHandler(element)
{
	if (element){
		dhtml.addEvent(module, element, "click", eventViewMarker);
	}
}

/**
 * Function which attaches event with combobox and textfield elements.
 * onfocus for text field.
 * onclick for combobox.
 * callback function checks corresponding radiobutton automatically.
 * @param object element HTML element for textfield/combobox.
 * @param string elementType combo or textfield.
 */
function setCheckedMarkerHandler(element, elementType)
{
	if (element && elementType){
		if(elementType == "combo") {
			dhtml.addEvent(module, element, "click", eventChangeAddressFieldFocus);
			dhtml.addEvent(module, element, "change", eventChangeAddressFieldFocus);
		} else
			dhtml.addEvent(module, element, "focus", eventChangeAddressFieldFocus);
	}
}

/**
 * Function which attaches event with RadioButton onChcked event.
 * callback function sets for addresstype maker.
 * @param object element HTML element for textfield/combobox.
 */
function setOnCheckedHandler(element)
{
	if (element){
		dhtml.addEvent(module, element, "change", eventOnChecked);
	}
}
/**
 * Function which attaches event with button.
 * callback function calls getDirection method of contactgmapitemmodule.
 * @param object element HTML element for button.
 */
function setGetDirectionHandler(element)
{
	if (element){
		dhtml.addEvent(module, element, "click", eventGetDirection);
	}
}

/**
 * This function returns addresstype of selected address.
 * e.g. home, business, other or custom address
 * @param string elementid is the id of the combo box element.
 * @return string addresstype returns the addresstype.
 */
function getAddresTypeAttribute(elementid)
{
	// Get combobox element
	var element = dhtml.getElementById(elementid);
	var addresstype = "custom_address";
	var radioelementid = "select_" + elementid;
	/**
	 * If radio button of combobox is selected and any address is selected
	 * then set the addrestype value according to selected address.
	 */
	if(dhtml.getElementById(radioelementid).checked && element.selectedIndex != -1) {
		addresstype = element.options[element.selectedIndex].getAttribute("addresstype");
	}
	return addresstype;
}

/**
 * This function will disable input fields when processing gor geocoding or gdirection is going on.
 * and after completion process input fields are enabled.
 * @param boolean disableValue disableValue value is set with the disabled property of inputfields.
 */
function enableDisableInputFields(disableValue)
{
	module.getDirectionElement.disabled = disableValue;

	var sourceElement = dhtml.getElementById("select_source_combo");
	sourceElement.disabled = disableValue;
	
	var sourceElement = dhtml.getElementById("select_source_text");
	sourceElement.disabled = disableValue;
	
	var sourceElement = dhtml.getElementById("select_destination_combo");
	sourceElement.disabled = disableValue;
	
	var sourceElement = dhtml.getElementById("select_destination_text");
	sourceElement.disabled = disableValue;

	var sourceElement = dhtml.getElementById("source_combo");
	sourceElement.disabled = disableValue;
	
	var sourceElement = dhtml.getElementById("source_text");
	sourceElement.disabled = disableValue;
	
	var sourceElement = dhtml.getElementById("destination_combo");
	sourceElement.disabled = disableValue;
	
	var sourceElement = dhtml.getElementById("destination_text");
	sourceElement.disabled = disableValue;

	if(disableValue) {
		module.getDirectionElement.value = "Processing...";
	} else {
		module.getDirectionElement.value = "Get Direction";
	}
}

/**
 * Function used to get the elements by attributes.
 * usefull while changing the images of marker in address
 * @param object oElm parent Element in which we need to find the elements, * for document.
 * @param string strTagName tag name on which type of elements we want to find.
 * @param string strAttributeName attribute name
 * @param string strAttributeValue attribute value [optional]
 * @return array arrReturnElements array of elements found
 */
function getElementsByAttribute(oElm, strTagName, strAttributeName, strAttributeValue){
    var arrElements = (strTagName == "*" && document.all)? document.all : oElm.getElementsByTagName(strTagName);
    var arrReturnElements = new Array();
    var oAttributeValue = (typeof strAttributeValue != "undefined")? new RegExp("(^|\\s)" + strAttributeValue + "(\\s|$)") : null;
    var oCurrent;
    var oAttribute;
    for(var i=0; i<arrElements.length; i++){
        oCurrent = arrElements[i];
        oAttribute = oCurrent.getAttribute(strAttributeName);
        if(typeof oAttribute == "string" && oAttribute.length > 0){
            if(typeof strAttributeValue == "undefined" || (oAttributeValue && oAttributeValue.test(oAttribute))){
                arrReturnElements.push(oCurrent);
            }
        }
    }
    return arrReturnElements;
}

function setMarkerImage(imgElement, imageName)
{
	switch (imageName)
	{
		case "home_address":
			imgElement.src = PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY + "/icon_home.png";
		break;

		case "business_address":
			imgElement.src = PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY + "/icon_business.png";
		break;

		case "other_address":
			imgElement.src = PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY + "/icon_other.png";
		break;

		default:
			imgElement.src = PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY + "/icon_other.png";
		break;
	}
}