<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php

function getModuleName(){
	return "contactgmapitemmodule";
}

function getModuleType(){
	return "item";
}

function getDialogTitle(){
	return dgettext("plugin_contactgmap", "Contact on Google Map");
}

function getIncludes(){
	return array(
			"client/modules/contactitemmodule.js",
			"plugins/contactgmap/dialogs/contactgmap.js",
			"plugins/contactgmap/".getModuleName().".js"
		);
}

function getJavaScript_onload(){

?>
	// Set path of the plugin image directory in variable.
	<? if(defined('PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY') && defined('DEFAULT_MAP_CENTER_LNG')) { ?>
		PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY = '<?= PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY ?>';
	<? } else { ?>
		// default path
		PLUGIN_CONTACTGMAP_IMAGE_DIRECTORY = '<?= PATH_PLUGIN_DIR ?>'+ '/contactgmap/img';
	<? } ?>

	// Initializes module.
	module.init(moduleID);
	// Sets the storeid and parententryid for module.
	module.setData(<?=get("storeid","false","'")?>, <?=get("parententryid","false","'")?>);

	// Sets the entryid and rootentryid for module.
	module.open(<?=get("entryid","false","'")?>, <?=get("rootentryid","false","'")?>);

	// Resizes body accoring to size of dialogbox.
	resizeBody();

	<? if(defined('PLUGIN_CONTACTGMAP_DEFAULT_MAP_CENTER_LAT') && defined('PLUGIN_CONTACTGMAP_DEFAULT_MAP_CENTER_LNG')) { ?>
		PLUGIN_CONTACTGMAP_DEFAULT_MAP_CENTER = new GLatLng(<?= PLUGIN_CONTACTGMAP_DEFAULT_MAP_CENTER_LAT ?>, <?= PLUGIN_CONTACTGMAP_DEFAULT_MAP_CENTER_LNG ?>);
	<? } else { ?>
		PLUGIN_CONTACTGMAP_DEFAULT_MAP_CENTER = new GLatLng(0, 0);
	<? } ?>

	<? if(defined('PLUGIN_CONTACTGMAP_DEFAULT_MAP_ZOOM_LEVEL')) { ?>
		PLUGIN_CONTACTGMAP_DEFAULT_MAP_ZOOM_LEVEL = <?= PLUGIN_CONTACTGMAP_DEFAULT_MAP_ZOOM_LEVEL ?>;
	<? } else { ?>
		PLUGIN_CONTACTGMAP_DEFAULT_MAP_ZOOM_LEVEL = 1;
	<? } ?>

	<? if(defined('PLUGIN_CONTACTGMAP_CONTACTS_AS_DEFAULT_LOCATION')) { ?>
		PLUGIN_CONTACTGMAP_CONTACTS_AS_DEFAULT_LOCATION = '<?= PLUGIN_CONTACTGMAP_CONTACTS_AS_DEFAULT_LOCATION ?>';
	<? } else { ?>
		PLUGIN_CONTACTGMAP_CONTACTS_AS_DEFAULT_LOCATION = false;
	<? } ?>

	// Initializes all google map objects and html elements.
	module.initContactGmapObjects();

	// Add event for source and destination element which shows A/B image.
	setShowMarkerHandler(dhtml.getElementById("source"));
	setShowMarkerHandler(dhtml.getElementById("destination"));

	// Add event for comboboxes and text fields to check radio buttons automatically.
	setCheckedMarkerHandler(dhtml.getElementById("source_combo"), "combo");
	setCheckedMarkerHandler(dhtml.getElementById("source_text"), "text");
	setCheckedMarkerHandler(dhtml.getElementById("destination_combo"), "combo");
	setCheckedMarkerHandler(dhtml.getElementById("destination_text"), "text");

	setOnCheckedHandler(dhtml.getElementById("select_source_combo"));
	setOnCheckedHandler(dhtml.getElementById("select_source_text"));
	setOnCheckedHandler(dhtml.getElementById("select_destination_combo"));
	setOnCheckedHandler(dhtml.getElementById("select_destination_text"));

	// Add event for GetDirection button.
	setGetDirectionHandler(dhtml.getElementById("Get_Direction"));

<?php } // getJavaSctipt_onload

function getBody() {
?>
	<input id="home_address_lat" type="hidden">
	<input id="home_address_lng" type="hidden">
	<input id="business_address_lat" type="hidden">
	<input id="business_address_lng" type="hidden">
	<input id="other_address_lat" type="hidden">
	<input id="other_address_lng" type="hidden">

	<input id="home_address" type="hidden">
	<input id="business_address" type="hidden">
	<input id="other_address" type="hidden">


	<table id="gmapcontenttable" cellpadding="5" cellspacing="0">
		<tbody>
			<tr>
				<td class="direction_panel">
					<div id="address_selection_field">
						<table id="gampinputtable" cellpadding="5" cellspacing="0">
							<tbody>
								<tr>
									<td class="tabledata">
										<div id="source" class="icon icon_other_pointer"></div>
									</td>
									<td class="tabledata">
										<input type="radio" id="select_source_combo" name="select_source" checked="checked">
									</td>
									<td class="tablecombodata">
										<select id="source_combo" class="combobox">
										</select>
									</td>
								</tr>
								<tr>
									<td>&nbsp;</td>
									<td class="tabledata">
										<input id="select_source_text" name="select_source" type="radio">
									</td>
									<td>
										<input id="source_text" class="field" type="text">
									</td>
								</tr>
								<tr>
									<td class="tabledata">
										<div id="destination" class="icon icon_other_pointer"></div>
									</td>
									<td class="tabledata">
										<input type="radio" id="select_destination_combo" name="select_destination" checked="checked">
									</td>
									<td class="tablecombodata">
										<select id="destination_combo" class="combobox">
										</select>
									</td>
								</tr>
								<tr>
									<td>&nbsp;</td>
									<td class="tabledata">
										<input id="select_destination_text" name="select_destination" type="radio">
									</td>
									<td>
										<input id="destination_text" class="field" type="text">
									</td>
								</tr>
								<tr>
									<td align="right" colspan="3">
										<input id="Get_Direction" class="combobutton_main" type="button" value="Get Direction">
									</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div><hr /></div>
					<div id="directions">
						<div id="errorinfo"></div>
						<div id="directioninfo"></div>
					</div>
				</td>
				<td>
					<div id="map"></div>
				</td>
			</tr>
		</tbody>
	</table>
<?php
} // getBody
?>