/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/**
 * Plugincontactgmap
 *
 * Plugin for loading google map dialogbox
 */
Plugincontactgmap.prototype = new Plugin;
Plugincontactgmap.prototype.constructor = Plugincontactgmap;
Plugincontactgmap.superclass = Plugin.prototype;

/**
 * constructor
 */
function Plugincontactgmap() {}

/**
 * Plugincontactgmap init method
 *
 * registers for Plugincontactgmap events 
 */
Plugincontactgmap.prototype.init = function(){
	/**
	 * gmap plugins is loads the Google Map Api which is needed for google map handling
	 * So if gmap plugin is not loaded then dont add menuitem in contextmenu.
	 */
	if(webclient.pluginManager.pluginExists("gmap")) {
		// hook registration for the event -> when context menu of contactlist module loads.
		this.registerHook("client.module.contactlistmodule.contextmenu.buildup");
	}
}

/**
 * Plugincontactgmap execute
 * It is called when registered events of Plugincontactgmap are triggered 
 */
Plugincontactgmap.prototype.execute = function(eventID, data){
	switch(eventID) {
		case "client.module.contactlistmodule.contextmenu.buildup":
			this.addContextMenuItem(data["contextmenu"]);
			break;
	}
}

/**
 * Function which adds context menuitem in contextmenu of contactlist. 
 * menu button name is show Contact on Map.
 * @param object data array of contexte menu menuitems 
 */
Plugincontactgmap.prototype.addContextMenuItem = function(data){
	// Add separator and "Show Contact on Map" mneubutton in context menu of contactlist module.
	data.push(webclient.menu.createMenuItem("seperator", ""));
	data.push(webclient.menu.createMenuItem("show_contact_on_map", dgettext("plugin_contactgmap", "Show Contact on Map"), false, eventPluginContactgmapListContactMenuOpenGmap));
}

/**
 * Function which opens dialogbox with Googlemap. 
 */
function eventPluginContactgmapListContactMenuOpenGmap(moduleObject, element, event) {
	element.parentNode.style.display = "none";

	// Open dialog to select space.
	var rowelement = dhtml.getElementById(element.parentNode.elementid);
	var entryid = moduleObject.entryids[rowelement.id];
	var uri = DIALOG_URL + "task=contactgmap&plugin=contactgmap&storeid=" + moduleObject.storeid + "&parententryid=" + moduleObject.entryid + "&entryid=" + entryid;
	webclient.openWindow(moduleObject, 'contact', uri, 780, 560, true);
}