Ext.namespace('Zarafa.plugins.dropboxattachment');

/**
 * @class Zarafa.plugins.dropboxattachment.DropboxAttachmentPlugin
 * @extends Zarafa.core.Plugin
 * This class is used for adding files from the users's Dropbox folder
 * to his emails as attachments
 */
Zarafa.plugins.dropboxattachment.DropboxAttachmentPlugin = Ext.extend(Zarafa.core.Plugin, {

	/**
	 * @constructor
	 * @param {Object} config
	 */
	constructor : function(config)
	{
		config = config || {};

		Ext.applyIf(config, {
			name : 'dropboxattachment'
		});

		Zarafa.plugins.dropboxattachment.DropboxAttachmentPlugin.superclass.constructor.call(this, config);
	},

	/**
	 * initialises insertion point for plugin
	 * @protected
	 */
	initPlugin : function()
	{
		Zarafa.plugins.dropboxattachment.DropboxAttachmentPlugin.superclass.initPlugin(this, arguments);
		this.registerInsertionPoint('main.attachment.method', this.onAttachmentInsertion)
	},

	/**
	 * Insert dropbox option in all attachment suggestions
	 */
	onAttachmentInsertion : function(include, btn) {
		return {
			text : _('Dropbox'),
			handler : this.showDropboxAttachmentDialog.createDelegate(this, [btn]),
			scope: this,
			iconCls: 'icon_dropbox'
		};
	},

	/**
	 * Initializes Dialog for adding attachment from Dropbox to email
	 * @param {Object} btn
	 * @private
	 */
	showDropboxAttachmentDialog : function(btn)
	{
		var emailRecord = btn.record;
		Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.plugins.dropboxattachment.dialogs.AttachmentContentPanel, emailRecord, {
			title : _('Add attachment from Dropbox')
		});
	}
});

/**
 * registers plugin
 */
Zarafa.onReady(function() {
	if(container.getSettingsModel().get('zarafa/v1/plugins/dropbox/enable') === true)  {
		container.registerPlugin( new Zarafa.plugins.dropboxattachment.DropboxAttachmentPlugin());
	}
});
