<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php

function getDialogTitle() {
	return _("SMIME Attachments");
}

function getJavaScript_onload(){ ?>
					if(parentwindow.module) {
						var filelist = dhtml.getElementById("filelist");
						
						/**
						 * NOTE: We do not want to send attachments of original mail
						 * when we are replying to that mail. But new attachments 
						 * can be sent with that mail.
						 */						
						if (parentwindow.module && parentwindow.module.messageAction){ 
							if (parentwindow.module.messageAction == "reply" || parentwindow.module.messageAction == "replyall"){
								parentwindow.module.attachments = "";
							}
						}

                            
							<? 
							    // delete attachments uploaded the plain way. User
							    // has to repload to encrypt 
							    // and / or sign							    
							    unset($_SESSION["files"]);							    
						    ?>

                            // Populate the attachment selection box
                            var filelist = dhtml.getElementById("filelist");
                            for(var i=0; i < opener.smimeAttachmentList.length; i++) {
                                var y = document.createElement('option');
                                var tmp = opener.smimeAttachmentList[i];
                                if (smime_checkWindows() == 0)
                                    tmp = tmp.substr(tmp.lastIndexOf('\\')+1);
                                else
                                    tmp = tmp.substr(tmp.lastIndexOf('/')+1);
                                y.text = tmp;
                                filelist.add(y, null);
                            }
                


					}
					webclient.menu.showMenu();
<?php } // getJavaScript_onload						


function getBody(){ ?>
		<div id="attachments">
			<form id="upload" action="<?=$_SERVER["REQUEST_URI"]?>" method="POST" enctype="multipart/form-data">
<?php
	$htmloutput = '';
	$GLOBALS['PluginManager']->triggerHook("server.dialog.attachments.setup.getbody.uploadformhtml", array( "html" => &$htmloutput ));
	echo $htmloutput;
?>
				<fieldset>
					<legend><?=_("Add attachments")?></legend>
					<dl>
						<dt><label for="attachment"><?=_("Filename")?>:</label></dt>
						<dd><input type="file" id="attachment" name="attachments[]" onchange="smime_updateFilelistAdd(this);this.value=''" /></dd>
						<dd> (<?= _("max filesize") ?>: <?= getMaxUploadSize(true) ?>)</dd>
					</dl>
	
					<input type="hidden" name="MAX_FILE_SIZE" value="<?= getMaxUploadSize(false) ?>" />
					<input type="hidden" name="dialog_attachments" value="<?=$_REQUEST["dialog_attachments"]?>" />
				</fieldset>
			</form>

			<fieldset id="files">
				<legend><?=_("Files currently attached")?></legend>
				<form id="action" action="<?=$_SERVER["REQUEST_URI"]?>" method="POST">
					<div>
						<div class="filelist">
							<select id="filelist" size="10" onchange="attachmentSelect();"></select>
						</div>
						<div class="attach_buttons">
								<input id="delete" class="button_delete" type="button" value="<?=_("Delete")?>" title="<?=_("Delete selected file")?>" onclick="smime_updateFilelistDelete(document.getElementById('filelist').selectedIndex);" /><br/>

								<input type="hidden" name="dialog_attachments" value="<?=$_REQUEST["dialog_attachments"]?>" />
								<input id="deleteattachment" type="hidden" name="deleteattachment" value="" />
								<input id="type" type="hidden" name="type" value="" />
						</div>
					</div>
				</form>
			</fieldset>
			
			<?=createCloseButton("window.close();")?>
		</div>
<?php } // getBody
?>
