/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/**
 * S/MIME support for webaccess
 *
 *
 * Created on 10.2009
 * Author: Giorgos Logiotatidis <seadog@sealabs.net>
 *
 * S/MIME support for webacess
 * Currently works only for Firefox
 * Support for encrypting, decrypting, signing and verifying 
 * S/MIME emails.
 *
 * Encryption works only for one reciptient for this version
 * 
 */
Pluginsmime.prototype = new Plugin;
Pluginsmime.prototype.constructor = Pluginsmime;
Pluginsmime.superclass = Plugin.prototype;

function Pluginsmime(){}
var smimeEncrypt = false;
var smimeSign = false;
var smimeAttachmentList = new Array();
var crlf = '\r\n';

Pluginsmime.prototype.init = function(){        
    this.registerHook("client.module.previewreadmailitemmodule.item.before");
    this.registerHook("client.module.readmailitemmodule.item.before");
}

Pluginsmime.prototype.execute = function(eventID, data){
    switch(eventID) {
        case "client.module.readmailitemmodule.item.before":
            if (dhtml.getXMLValue(data['message'], 'message_class') == 'IPM.Note.SMIME')
                smime_decode(data);
            else if (dhtml.getXMLValue(data['message'], 'message_class') == 'IPM.Note.SMIME.MultipartSigned')
                smime_signed(data);
            break;
        case "client.module.previewreadmailitemmodule.item.before":
		// we display only signed  massages in preview panel
		if (dhtml.getXMLValue(data['message'], 'message_class') == 'IPM.Note.SMIME.MultipartSigned')
			smime_signed(data);
		break;
   }
}

/// ****************************************************************************
/// Viewing signed and encrypted messages starts here
/// ****************************************************************************

/**
 * Display the proper messages according to the 'validSignature' variable
 * set by the 'signedMessage' function in 'plugin.smime.php'
 * 
 * @param mixed data object(s) from the bus
 * @return void
 */
function smime_signed(data) {
    // verifycation is server side
    // we only need display tag the message's sign status
    var validSignature = dhtml.getXMLValue(data['message'], 'validSignature');
	var msg;
    
    if (validSignature == 1)
        msg = _("This message is signed");
    else if (validSignature == 0)
        msg = _("This message is signed but we cannot verify the signature. Maybe the contents of the message have been altered.");
    else if (validSignature == -1)
        msg = _("This message couldn't be verified because of a server error");
        
    smime_addInfoBlock(msg);
}

/**
 * Create new notification blocks
 * 
 * @param string to display
 * @return void
 */ 
function smime_addInfoBlock(msg) {
    var extrainfo = dhtml.getElementById("extrainfo");
    dhtml.addElement(extrainfo, "p", false, false, msg);
    extrainfo.style.display = "block";
}

/**
 * If the message if encrypted:
 * 1. set the proper notification block
 * 2. read the encrypted message from the 'encrypted*' variables 
 *     set by 'encryptedMessage' function in 'plugin.smime.php'
 * 3. Decrypt the message
 * 4. Parse the decrypted message, display the text part, save attachements
 *
 * @param mixed data object(s) from the bus
 * @return void
 */
function smime_decode(data) { 
    // check browser
    if (smime_checkBrowser() == -1) {
        smime_setXMLValue(data['message'], 'body', _('Your browser does not support this function'));
        return;
    }

    // set extrainfo
    smime_addInfoBlock(_("This message is encrypted"));

    // For some strange reason we collect only 4096 characteres from getXMLValue
    // so we splitted the encrypted message in many chunks
    i=0;
    var cipherText = "";
    while (true) {
        var tmp = dhtml.getXMLValue(data['message'], "encrypted" + i)
        if (tmp == null)
            break;
        
        cipherText += tmp;
        i++;
    }
    
    if (cipherText == "")
        // no encrypted message;
        return;
    
    try {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
    }
    catch(e) {
	    r = confirm(_("Firefox secure access, needed for S/MIME plugin to work is not enabled. If you want to configure secure access, please press 'OK' and download the 'zarafaconf.html' file offered to you. Afterwards open the file and press 'Allow' on the security notice."));
	    
	    if (r) 
	        window.location="plugins/smime/userconf.php";
        else {
            alert(_("Cannot continue the S/MIME procedure."))
            return;
        }
    }
    var cmsmsg = Components.classes["@mozilla.org/nsCMSSecureMessage;1"].createInstance(Components.interfaces.nsICMSSecureMessage);

    try {
        var text = cmsmsg.receiveMessage(cipherText);
    } catch(e) {
        var text = "We couldn't decrypt this message. Propably you don't the correct private key or an error occured.";
        smime_setXMLValue(data['message'], 'body', text);
        return;
    }

    c = smime_getContentType(text);

    if (c.substr(0, 9) == "multipart" || c == "application/x-pkcs7-mime" ) 
        attachments = smime_parseMultipart(data['message'], text);
    else 
        attachments = smime_parseSinglepart(data['message'], text);

    // maybe we got an error
    if (typeof(attachments[0]) == 'undefined') {
        var text = "We couldn't decrypt this message. Propably you don't the correct private key or an error occured.";
        smime_setXMLValue(data['message'], 'body', text);
        return;
    }

    // if the first attachment is text and base64 encoded, decode first
    if (attachments[0]['type'].substr(0, 4) == "text") {
    
        if (attachments[0]['encoding'] == 'base64') {
            // remove CRLF for atob to work
            attachments[0]['data'] = attachments[0]['data'].replace(/\r*\n*=*/g,"");
            // convert bas64 to binary
            attachments[0]['data'] = atob(attachments[0]['data']);
        }
        
        if (attachments[0]['type'] == "text/html")
    	    smime_setXMLValue(data['message'], 'isHTML', 1);
	
	    smime_setXMLValue(data['message'], 'body', attachments[0]['data']);
    }


    // When user closes the mail window we should delete the decrypted attachments
    // from disk
    var onunload = document.body.getAttribute('onunload');
    if (onunload)
        onunload += "smime_deleteAttachmentsFromDisk(attachments);";
    else
        onunload = "smime_deleteAttachmentsFromDisk(attachments);";
    document.body.setAttribute('onunload', onunload);

    // Save decrypted attachments to disk
	smime_saveAttachmentsToDisk(attachments);

}

/**
 * For each decrypted attachement
 *  1. Save on disk, in the tmp directory of the O/S, using proper permissions (rw-------) (400)
 *  2. Set links in the attachements field
 *
 * @param Array containing the attachments
 * @return void
 */
function smime_saveAttachmentsToDisk(attachments) {
    try {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
    }
    catch(e) {
	    r = confirm(_("Firefox secure access, needed for S/MIME plugin to work is not enabled. If you want to configure secure access, please press 'OK' and download the 'zarafaconf.html' file offered to you. Afterwards open the file and press 'Allow' on the security notice."));
	    
	    if (r) 
	        window.location="plugins/smime/userconf.php";
        else {
            alert(_("Cannot continue the S/MIME procedure."))
            return;
        }
    }

	// Get user temporatry directory using XPCOM
	var file = Components.classes["@mozilla.org/file/directory_service;1"].
                     getService(Components.interfaces.nsIProperties).
                     get("TmpD", Components.interfaces.nsIFile);
    	tmpPath =  file.path + "/";
	if (smime_checkWindows() == 0)
		tmpPath = smime_convertPath(tmpPath);
    
	var attachmentsElement = dhtml.getElementById("attachments");
	
    // if first attachmenst is not text/*  i should be i=0
    if (attachments[0]['type'].substr(0,4) == "text")
        i = 1;
    else
        i = 0;
    		
	for (; i<attachments.length; i++) {
	    // create file. mode 400 is read write permissions for user, nothing for others
        var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
        aFile.initWithPath(tmpPath+attachments[i]['filename']);
        aFile.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 400);
    
        var stream = Components.classes["@mozilla.org/network/safe-file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
        stream.init(aFile, -1, 0600, 0);
        // remove CRLF for atob to work
        f = attachments[i]['data'].replace(/\r*\n*=*/g,"");
        // convert bas64 to binary
        f = atob(f);
        size = f.length;
        stream.write(f, size);
        if (stream instanceof Components.interfaces.nsISafeOutputStream)
            stream.finish();
        else 
            stream.close();

        // add attachments to page
        
        // calculate attachment size
    	var kb = Math.round(size / 1024) + _("kb");
    	if(size < 1024)
    		kb = size + _("B");

        // warning for this to work special firefox configuration is needed
        // http://kb.mozillazine.org/Links_to_local_pages_don%27t_work
    	var path = aFile.path;
    	if (smime_checkWindows() == 0)
    		path = aFile.path.replace(/\\/g, "/");
            attachmentsElement.innerHTML += '<a href="file://' + path + '" target="_blank">' + attachments[i]['filename'] + " (encrypted) (" + kb + ")</a> ";
        
        // now save the actual path into the array
        // note that final filename maybe different from the original
        // filename, because we use createUnique function which will
        // prevent us from overwriting an existing file with the same
        // name, by providing a new filename
        attachments[i]['filename'] = aFile.path;
    }	
}

/**
 * Convert a string (path) from Unix style to Windows style
 *
 * @param String
 * @return String
 */
function smime_convertPath(path) {
	path = path.replace(/\//g, "\\");
	return path;
}

/**
 * Check if the browser is running on windows
 *
 * @return Int
 */
function smime_checkWindows() {
    if (navigator.userAgent.toLowerCase().indexOf('windows') > -1)
        return 0;

    return -1;
}

/**
 * Delete all the generated, decrypted attachments from disk.
 * Call when user closes the message view window.
 *
 * @param Array containing the attachments
 * @return void
 */
function smime_deleteAttachmentsFromDisk(attachments) {
    try {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
    }
    catch(e) {
	    r = confirm(_("Firefox secure access, needed for S/MIME plugin to work is not enabled. If you want to configure secure access, please press 'OK' and download the 'zarafaconf.html' file offered to you. Afterwards open the file and press 'Allow' on the security notice."));
	    
	    if (r) 
	        window.location="plugins/smime/userconf.php";
        else {
            alert(_("Cannot continue the S/MIME procedure."))
            return;
        }
    }

    // if first attachmenst is not text/*  i should be i=0
    if (attachments[0]['type'].substr(0,4) == "text")
        i = 1;
    else
        i = 0;

    for (; i<attachments.length; i++) {
        var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance();
        if (aFile instanceof Components.interfaces.nsILocalFile) {
            aFile.initWithPath(attachments[i]['filename']);
            // false is for not recursive
            aFile.remove(false);
        }
    }
}

/**
 * Set value in XML field
 *
 * @param XML stream
 * @param String look for in the xml (tag)
 * @param Value to set to the XML tag
 * @return void
 */
function smime_setXMLValue(xml, tag, value) {
    var element = dhtml.getXMLNode(xml, tag);
    
	if (element) {
	    if (element.firstChild && typeof(element.firstChild.nodeValue)!="undefined")
    	    element.firstChild.nodeValue = value;
        else
            element.appendChild(document.createTextNode(value));
    }   
}

/**
 * Parse a multipart message 
 *
 * @param XML stream
 * @param Mime part
 * @param Mime boundary
 * @return Array containing attachments
 */
function smime_parseMultipart(xml, text, boundary) {
    var attachments = new Array();

    // if we are given no boundary find it
    if (typeof(boundary) == "undefined") {
        start = text.indexOf("boundary=");
        start += 10;
        end = text.indexOf('"', start);
        boundary = text.slice(start, end);
    }
    var boundary = '--' + boundary;

    // get the different mime parts
    var slices = text.split(boundary);        

    // parse each mime part
    for(var i=1,j=0; i< slices.length-1; i++, j++) {
        attachments[j] = new Array();
        attachments[j]['type'] = smime_getContentType(slices[i]);
        attachments[j]['filename'] = smime_getAttachmentFilename(slices[i]);
        attachments[j]['data'] = smime_getData(slices[i]);
        attachments[j]['encoding'] = smime_getTransferEncoding(slices[i]);   
        
        // if we get both html and txt mime we keep the html
        if (attachments[j]['type'] == 'multipart/alternative') {
            var tmp = smime_parseMultipart(xml, attachments[i]['data'], smime_getBoundary(slices[i]));
            var d = tmp[1]['type'] == "text/html" ? 1 : 2;
            attachments[j]['type'] = tmp[d]['type'];
            attachments[j]['filename'] = tmp[d]['filename'];
            attachments[j]['data'] = tmp[d]['data'];
            attachments[j]['encoding'] = tmp[d]['encoding'];
        }
        // if the mime part is a signature we remove it and
        // inform the user that the message is signed
        else if (attachments[j]['type'] == 'application/x-pkcs7-signature' || attachments[j]['type'] == 'application/pkcs7-signature') {
            attachments.splice(j, 1);
            j -= 1;
            smime_addInfoBlock(_("This is message is signed but currently there is no support for verifying encrypted messages"));
        }
        // if the mime part is  multipart/mixed then we
        // parse this part and attach the results to the attachments
        else if (attachments[j]['type'] == "multipart/mixed") {
            // parse the multipart/mixed
            tmp = smime_parseMultipart(xml, attachments[j]['data'], smime_getBoundary(slices[i]));

            // remove the multipart/mixed attachment
            attachments.splice(j, 1);
            j -= 1;     
                
            // add the multipart/mixed parts into the attachment list
            for (var k=0; k<tmp.length; k++) {            
                var tmpentry = new Array();
                tmpentry['type'] = tmp[k]['type'];
                tmpentry['filename'] = tmp[k]['filename'];
                tmpentry['data'] = tmp[k]['data'];
                tmpentry['encoding'] = tmp[k]['encoding'];   
                attachments.push(tmpentry);
            }             
            // fix j value to count the new attachemnts
            j += tmp.length;                  
        }
                    
     
    }
    return attachments;
} 

/**
 * Parse a singlepart message 
 *
 * @param XML stream
 * @param Mime string
 * @return Array containing attachment
 */
function smime_parseSinglepart(xml, text) {
    var attachments = new Array();
    
    attachments[0] = new Array();
    attachments[0]['type'] = smime_getContentType(text);
    attachments[0]['filename'] = smime_getAttachmentFilename(text);
    attachments[0]['data'] = smime_getData(text);
    attachments[0]['encoding'] = smime_getTransferEncoding(text);   
    
    // if we get both text/html and text/txt parts
    // keep the text/html
    if (attachments[0]['type'] == 'multipart/alternative') {
        tmp = smime_parseMultipart(xml, attachments[i]['data'], smime_getBoundary(text));
        var d = tmp[0]['type'] == "text/html" ? 1 : 2;
        attachments[0]['type'] = tmp[d]['type'];
        attachments[0]['filename'] = tmp[d]['filename'];
        attachments[0]['data'] = tmp[d]['data'];
        attachments[0]['encoding'] = tmp[d]['encoding'];
    }

    return attachments;
}

/**
 * Get the data of a mime part
 *
 * @param Mime string
 * @return Data string
 */
function smime_getData(text) {
    offset = 4;    
    start = text.indexOf('\r\n\r\n');
    if (start == -1) {
        start = text.indexOf('\n\n');
        offset = 2;
    }
    
    if (start == -1)
        return "";
    
    return text.substring(start+offset, text.length-1);
}

/**
 * Get the 'Content-Transfer-Encoding' header of the mime part 'text'
 *
 * @param Mime string
 * @return encoding string, null when not found
 */
function smime_getTransferEncoding(text) {
    regex = RegExp("Content-Transfer-Encoding: (.*?)(\r\n|\n)", "i");
    matched = regex.exec(text);
    
    if (matched)
        return matched[1].toLowerCase();
    else 
        return null;
}

/**
 * Get the mime boundary of a mime part
 *
 * @param Mime string
 * @return boundary string, null when not found
 */
function smime_getBoundary(text) {
    regex = RegExp("Content-Type: (.*?)(\r{0,1}\n)* boundary=\"(.*?)\"", "i");
    matched = regex.exec(text);
    
    if (matched)
        return matched[3];
    else
        return null;
}

/**
 * Get the 'Content-Type' header of a mime part
 *
 * @param Mime string
 * @return content-type string, null when not found
 */
function smime_getContentType(text) {
	regex = RegExp("Content-Type: (.*?)(\r\n|\n)","i");
	matched = regex.exec(text);

	if (matched)
	{
		typeFields = matched[1].split(";");
		return typeFields[0].toLowerCase();
	}
	else
		return null;
}

/**
 * Get the filename of a mime part 'text'
 *
 * @param Mime string
 * @return filename string
 */
function smime_getAttachmentFilename(text) {
    regex = RegExp("content-disposition: (.*?);(\r{0,1}\n)* filename=\"(.*?)\"(\r{0,1}\n)", "i");
    matched = regex.exec(text);
    
    if (matched)
        return matched[3];
    else {
        // we failed to find the filename in content-disposition, so
        // try find the filename in content-type
        regex = RegExp("content-type: (.*?);(\r{0,1}\n)* name=\"(.*?)\"", "i");
        matched = regex.exec(text);

        if (matched) 
            return matched[3];
        else
            return "unkown";
    }  
}


/// ****************************************************************************
/// Sending starts here
/// ****************************************************************************

/**
 * Warn the user that the email is going to be saved on server unencrypted
 * and if accepts save it
 *
 * @return void
 */
function smime_saveEmail() {
    if (!smimeEncrypt) {
        submit_createmail(false);
    }
    else {
        r = confirm(_('This message will be saved unencrypted and attachments will be lost'));
        if (r) 
            submit_createmail(false);
        else
            alert(_('Message not saved!'));
    }
}

/**
 * Combine text and attachments in single or multipart message and encrypt and/or 
 * sign 
 *
 * @return void
 */
function smime_submitCreateMail() {
    // if not signed and not encrypted, nothing to do!
    if (!smimeEncrypt && !smimeSign) {
        submit_createmail(true);
        return;
    }

    // if encrypt and more than one reciptiens, complain
    // that is not supported
    emailList = smime_findEmails(dhtml.getElementById('to').value);
    emailList = emailList.concat(smime_findEmails(dhtml.getElementById('cc').value));
    emailList = emailList.concat(smime_findEmails(dhtml.getElementById('bcc').value));    
    if (smimeEncrypt && emailList.length > 1) {
        alert(_("Sending encrypted messages to multiple reciptients is currently not supported!"));
        return;
    }
        
    // if sign or encrypt
    // set message class
    smime_setMessageClass();
 
    // get body
    var body = smime_getBody();
    
    // if we don't have attachments display the body
    if (smimeAttachmentList.length == 0)
        body[0] = "Content-Type: " + body[1] + "; charset=utf8" + crlf 
                    + "Content-Transfer-Encoding: base64" + crlf + crlf
                    + btoa(smime_transformText(body[0]));
    
    // we have attachments
    // create a mime multipart/mixed envelop and include every attachment
    else {
        var boundary = smime_generateMIMEBoundary(); 
        var emailText = 'Content-Type: multipart/mixed; boundary="' + boundary + '"' + crlf + crlf;
        emailText += '--' + boundary + crlf;
        emailText += "Content-Type: " + body[1] + "; charset=utf8" + crlf 
                    + "Content-Transfer-Encoding: base64" + crlf + crlf
                    + btoa(smime_transformText(body[0]));
        emailText += crlf + '--' + boundary;

        for (var i=0; i< smimeAttachmentList.length; i++) {
            try {
                netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
            }
            catch(e) {
        	    r = confirm(_("Firefox secure access, needed for S/MIME plugin to work is not enabled. If you want to configure secure access, please press 'OK' and download the 'zarafaconf.html' file offered to you. Afterwards open the file and press 'Allow' on the security notice."));
        	    
        	    if (r) 
        	        window.location="plugins/smime/userconf.php";
                else {
                    alert(_("Cannot continue the S/MIME procedure."))
                    return -1;
                }
            }        

            // get data and mime type of the attachment
            var bytes = smime_getFileContents(smimeAttachmentList[i]);    
            var mimeType = smime_getMime(smimeAttachmentList[i]);
            
            // convert to base64
            var base64Attachment = smime_breakLines(btoa(bytes));
            
            // remove path from filename
            var filename = smime_checkWindows() == -1 ? smimeAttachmentList[i].substr(smimeAttachmentList[i].lastIndexOf('/')+1) : smimeAttachmentList[i].substr(smimeAttachmentList[i].lastIndexOf('\\')+1);
            emailText += crlf + 'Content-Type: ' + mimeType + '; name="' + filename + '"' +crlf;
            emailText += "Content-Transfer-Encoding: base64" + crlf +crlf;
            emailText += base64Attachment ;
            emailText += crlf + '--' + boundary;                       
        }
        emailText += '--';
        body[0] = emailText;       
    }
    

    // if signed is checked    
    if (smimeSign)
        body[0] = smime_signText(body[0], body[1]);
    // user canceled the operation or an error occured
    if (body[0] == -1)
        return;
    
    // if encrypt is checked
    if (smimeEncrypt) {
        certList = smime_findCerts(emailList);
    
        if (certList == -1)
            return;

        body[0] = smime_encryptText(certList[0], body[0])
    }
    
    // remove the body from the body. The body is now attached to email
    // as a pkcs attachment
    smime_clearBody();
    
    // upload the attachment
    smime_sendRequest(body[0]);
    // we call submit_create when uploading of the encrypted / signed
    // attachment is finished
    //submit_createmail(true);
}

/**
 * Break the lines of a base64 string to conform to 65 characters
 * per line limit.
 *
 * @param string
 * @return string
 */
function smime_breakLines(text) 
{
	return text.replace(/[\s\S]{65}/g,"$&\r\n");
}

/**
 * Use xpcom sniffer service to figure attachment mime type
 *
 * @param filename
 * @return mimeType string
 */
function smime_getMime(filename) {
    var ios = Components.classes["@mozilla.org/network/io-service;1"].
                        getService(Components.interfaces.nsIIOService);

    // fix the path
    if (smime_checkWindows() == 0)
        filename = filename.replace(/\\/g, "/");

    // open the file
    var url = ios.newURI("file://" + filename, null, null);
    if (!url || !url.schemeIs("file")) throw "Expected a file URL.";
    var aFile = url.QueryInterface(Components.interfaces.nsIFileURL).file;
    var istream = Components.classes["@mozilla.org/network/file-input-stream;1"].
                            createInstance(Components.interfaces.nsIFileInputStream);
    istream.init(aFile, -1, -1, false);
    var bstream = Components.classes["@mozilla.org/binaryinputstream;1"].
                            createInstance(Components.interfaces.nsIBinaryInputStream);
    bstream.setInputStream(istream);
    var bytes = bstream.readByteArray(bstream.available());
    
    // sniff the mime type
    var catMgr = Components.classes["@mozilla.org/categorymanager;1"].getService(Components.interfaces.nsICategoryManager);
    var sniffers = catMgr.enumerateCategory("content-sniffing-services");
    var snifferCID = sniffers.getNext().QueryInterface(Components.interfaces.nsISupportsCString).toString();
    var sniffer = Components.classes[snifferCID].getService(Components.interfaces.nsIContentSniffer);
    try {
        mimeType = sniffer.getMIMETypeFromContent(null, bytes, bytes.length);
    } catch (e) {
        mimeType = "application/octet-stream";
    }

    return mimeType;
}

/**
 * Get the contents of a file
 * 
 * @param filename
 * @return binary blob
 */
function smime_getFileContents(filename) {
    var ios = Components.classes["@mozilla.org/network/io-service;1"].
                        getService(Components.interfaces.nsIIOService);
    
    // if the path
    if (smime_checkWindows() == 0)
        filename = filename.replace(/\\/g, "/");

    // open file and get contents
    var url = ios.newURI("file://" + filename, null, null);
    if (!url || !url.schemeIs("file")) throw "Expected a file URL.";
    var File = url.QueryInterface(Components.interfaces.nsIFileURL).file;
    var istream = Components.classes["@mozilla.org/network/file-input-stream;1"].
                            createInstance(Components.interfaces.nsIFileInputStream);
    istream.init(File, -1, -1, false);
    var bstream = Components.classes["@mozilla.org/binaryinputstream;1"].
                            createInstance(Components.interfaces.nsIBinaryInputStream);
    bstream.setInputStream(istream);
    var bytes = bstream.readBytes(bstream.available()); 
    
    return bytes;
}

/**
 * Find email addresses in a string
 * 
 * @param string with ; seperated email addresses
 * @return string array with email addresses
 */
function smime_findEmails(str) {
    var a = str.split(';')
    var emailList = new Array();
    for (i in a) {
        e = a[i];
        var email = e.match(/([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+/);
        if (email)
            emailList.push(email[0]);
    }	               

    return emailList;
}

/**
 * Set the message class
 *
 * @return void
 */
function smime_setMessageClass() {
    element = dhtml.getElementById('message_class');
    
    if (smimeEncrypt)
        element.value = "IPM.Note.SMIME";
    else if (smimeSign)
        element.value = "IPM.Note.SMIME.MultipartSigned";
}

/**
 * Toggle smimeEncrypt variable and the UI buttons
 *
 * @return void
 */
function smime_toggleEncrypt() {
    // check browser
    if (smime_checkBrowser() == -1) {
        alert(_('Your browser does not support this function'));
        return -1;
    }

    var e = dhtml.getElementById('smimelink_encrypt');

    if (smimeEncrypt) {
        smimeEncrypt = false;
        dhtml.removeClassName(e, 'menubuttonselected');
    }
    else {
        smimeEncrypt = true;
        dhtml.addClassName(e, 'menubuttonselected');
    }   
    
    smime_toggleAttachments();         
    setMessageChanged();
}

/**
 * Toggle smimeSign variable and the UI buttons
 *
 * @return void
 */
function smime_toggleSign() {
    // check browser
    if (smime_checkBrowser() == -1) {
        alert(_('Your browser does not support this function'));
        return -1;
    }

    var e = dhtml.getElementById('smimelink_sign');

    if (smimeSign) {
        smimeSign = false;
        dhtml.removeClassName(e, 'menubuttonselected');
    }
    else {
        smimeSign = true;
        dhtml.addClassName(e, 'menubuttonselected');
    }
    
    smime_toggleAttachments();         
    setMessageChanged();
}

/**
 * Toggle attachment button execution code, to activate smime attachments
 * dialog
 *
 * @return void
 */
function smime_toggleAttachments() {
    var e = document.getElementsByTagName('input');

    for (var i=0; i< e.length; i++)
        if (e[i].value == _("Attachments") + ":")
            if (smimeEncrypt || smimeSign) {
                if (e[i].getAttribute("onclick").indexOf("smimeattachments") != -1) 
                    // we don't need to change anything
                    return;
                    
                e[i].setAttribute('onclick', "webclient.openWindow(module, 'attachments', DIALOG_URL+'task=smimeattachments&plugin=smime&store=' + module.storeid + '&entryid=' + (module.messageentryid?module.messageentryid:'') + '&dialog_attachments=' + dhtml.getElementById('dialog_attachments').value, 550, 350, '0');");
                
                // check attachments field
                var itemattachments = document.getElementById("itemattachments");
                if (itemattachments.childNodes.length > 1) {
                    alert("Will you have to reupload your attachments");
                    
                    for (var i=0; i < itemattachments.childNodes.length; i++) { 
                        itemattachments.removeChild(itemattachments.childNodes[1]); 
                    }                
                }
            }                
            else { 
                e[i].setAttribute('onclick', "webclient.openWindow(module, 'attachments', DIALOG_URL+'task=attachments_modal&store=' + module.storeid + '&entryid=' + (module.messageentryid?module.messageentryid:'') + '&dialog_attachments=' + dhtml.getElementById('dialog_attachments').value, 550, 350, '0');");
                
                //reset list
                smimeAttachmentList = new Array();
                // clear attachments field
                var itemattachments = document.getElementById("itemattachments");
                if (itemattachments.childNodes.length > 1) {
                    alert("Will you have to reupload your attachments");
                    
                    for (var i=0; i < itemattachments.childNodes.length; i++) { 
                        itemattachments.removeChild(itemattachments.childNodes[1]); 
                    }                
                }
                
            }
}

/**
 * Check if user browser is firefox
 *
 * @return 0 on success, -1 on failure
 */
function smime_checkBrowser() {
    if (navigator.userAgent.toLowerCase().indexOf('firefox') > -1)
        return 0;

    return -1;
}

function smime_vCert(cert) {
    var Ci = Components.interfaces;
    var verificationResult = cert.verifyForUsage(Ci.nsIX509Cert.CERT_USAGE_EmailRecipient);
    var emailAddress = cert.emailAddress;

	switch (verificationResult) {
		case Ci.nsIX509Cert.VERIFIED_OK:
			return 0;
			break;
		case Ci.nsIX509Cert.NOT_VERIFIED_UNKNOWN:
			alert("Certificate for reciptient '" + emailAddress + "' error: Not verified / Unkown");
			break;
		case Ci.nsIX509Cert.CERT_REVOKED:
			alert("Certificate for reciptient '" + emailAddress + "' error: Certificate Revoked");
			break;
		case Ci.nsIX509Cert.CERT_EXPIRED:
			alert("Certificate for reciptient '" + emailAddress + "' error: Certificate Expired");
			break;
		case Ci.nsIX509Cert.CERT_NOT_TRUSTED:
			alert("Certificate for reciptient '" + emailAddress + "' error: Certificate not Trusted");
			break;
		case Ci.nsIX509Cert.ISSUER_NOT_TRUSTED:
			alert("Certificate for reciptient '" + emailAddress + "' error: Issuer not Trusted");
			break;
		case Ci.nsIX509Cert.ISSUER_UNKNOWN:
			alert("Certificate for reciptient '" + emailAddress + "' error: Issuer not Unknown");
			break;
		case Ci.nsIX509Cert.INVALID_CA:
			alert("Certificate for reciptient '" + emailAddress + "' error: Invalid CA");
			break;
		default:
			alert("Certificate for reciptient '" + emailAddress + "' error: Unexpected error");
			break;
	}
	
	return -1;        
}                

/**
 * Find the certificates for a given email list
 *
 * @param array with emails
 * @param array with certificates (nsIX509Cert xpcom objects)
 */
function smime_findCerts(emailList) {
    var certList = new Array();
    try {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
    }
    catch(e) {
	    r = confirm(_("Firefox secure access, needed for S/MIME plugin to work is not enabled. If you want to configure secure access, please press 'OK' and download the 'zarafaconf.html' file offered to you. Afterwards open the file and press 'Allow' on the security notice."));
	    
	    if (r) 
	        window.location="plugins/smime/userconf.php";
        else {
            alert(_("Cannot continue the S/MIME procedure."))
            return -1;
        }
    }
    var certdb = Components.classes["@mozilla.org/security/x509certdb;1"].getService(Components.interfaces.nsIX509CertDB);

    for (email in emailList) {       
        var em = emailList[email];
        try {
            var cert = certdb.findCertByEmailAddress(null, em);
            if (smime_vCert(cert) == 0)
                certList.push(cert);

        }
        catch (e) {
            alert(_("Error: Certificate for email '") + em + _("' not found! Try installing the certificate using firefox's certificate manager or uncheck 'encrypt' button"));
            return -1;
        }
    }

    return certList;
}

/**
 * Transform the text to comply to standarts
 *
 * @param text
 * @return text
 */
function smime_transformText(text) {              

    if (text.charAt(0) == "\n") {
        text = crlf + 
        text.substring(1).replace(/([^\r])(?=\n)/g,"$1\r");
    } 
    else {
        text = text.replace(/([^\r])(?=\n)/g,"$1\r");
    }

    for (var i=0; i<text.length; i++)
        text = unescape(encodeURIComponent(text));

    return text;
}

/**
 * Get the typed body from the new message dialog
 *
 * @return array with two elements: (body string, body mime/type)
 */
function smime_getBody() {
    var b = new Array();
    // try to get FCKeditor
    var inst = 'undefined';
    if (typeof FCKeditorAPI != 'undefined')
        var inst =  FCKeditorAPI.GetInstance('html_body');

    if (inst == 'undefined') {
        b[0] = dhtml.getElementById('html_body').value;
        b[1] = 'text/plain';
    }
    else {
        b[0] = inst.GetHTML(); 
        b[1] = 'text/html';
    }

    return b;
}

/**
 * Encrypt text with certificate
 *
 * @param nsIX509Cert array
 * @param string to encrypt
 * @return encrypted binary
 */
function smime_encryptText(cert, body) {   
    try {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
    }
    catch(e) {
	    r = confirm(_("Firefox secure access, needed for S/MIME plugin to work is not enabled. If you want to configure secure access, please press 'OK' and download the 'zarafaconf.html' file offered to you. Afterwards open the file and press 'Allow' on the security notice."));
	    
	    if (r) 
	        window.location="plugins/smime/userconf.php";
        else {
            alert(_("Cannot continue the S/MIME procedure."))
            return -1;
        }
    }
    var cmsmsg = Components.classes["@mozilla.org/nsCMSSecureMessage;1"].createInstance(Components.interfaces.nsICMSSecureMessage);
    var derLength = new Object;
    var derData = [];
    var derCert = cert.getRawDER(derLength, derData);                        
    var certChars = ""
    for (var j=0;j<derCert.length;j++)
        certChars += String.fromCharCode(derCert[j]);    
    
    var certbase64 = btoa(certChars);
    var cipherText = cmsmsg.sendMessage(body, certbase64); // this in fact returns cipher text as a string.
    c = atob(cipherText);

    return c;    
}

/**
 * Create an signed envelop, sign and include the text
 * 
 * @param string text to sign
 * @param string text mimetype
 * @return signed text envelop
 */
function smime_signText(body, type) {
    crlf = '\r\n';
    boundary = smime_generateMIMEBoundary();
    
    text = 'Content-Type: multipart/signed; protocol="application/x-pkcs7-signature";' + crlf + '\tmicalg=sha1; boundary="' + boundary + '"' + crlf + crlf + 'This is a S/MIME signed message' + crlf + crlf;
    text += "--" + boundary + crlf;
    text += body;
    text += crlf + "--" + boundary + crlf;
    text += 'Content-Type: application/x-pkcs7-signature; name="smime.p7s"' + crlf + 'Content-Transfer-Encoding: base64' + crlf + 'Content-Disposition: attachment; filename="smime.p7s"' + crlf + 'Content-Description: S/MIME Cryptographic Signature' +crlf+crlf;
    
    signed = crypto.signText(body, 'auto');
    if (signed == "error:userCancel") {
            alert(_("User canceled the signing operation."));
            return -1;
    }
    
    else if (signed == "error:noMatchingCert") {
            alert(_("You don't have certificates for signing"));
            return -1;
    }
    
    else if (signed == "error:internalError") {
            alert(_("Internal error. Please check the validity of the signing certificate through Firefox Certificate Manager."));
            return -1;
    }
    
    text += signed;
    text += crlf + "--" + boundary + '--' + crlf;
    
    return text;
}

/**
 * Get DragNDrop information 
 * 
 * @return mixed data
 */
function smime_getDnDInfo() { 
    // from zarafaDND extension
    if(typeof getDnDinfo == "function") {
    	var dndinfo = getDnDinfo();
    	if(dndinfo.url && dndinfo.dialog_attachments)
    		return dndinfo;
    	else
    		return false;
    	
    }
    else {
    	return false;
    }
}

/**
 * Upload signed and/or encrypted attachment to the server
 *
 * @param encrypted and/or signed text
 * @return void
 */
function smime_sendRequest(cipherText) {
    // from zarafaDND extension
    //
    // Get the encrypted text and uploads it to the webserver
    // as an s/mime attachment
    filename = "smime.p7m";
    url = smime_getDnDInfo().url;

	http_request = false;
    http_request = new XMLHttpRequest();
    if (!http_request) {
    	alert(_('Cannot create XMLHTTP instance'));
    	return false;
    }

    // prepare the MIME POST data
    var boundaryString = smime_generateMIMEBoundary();
    var boundary = '--' + boundaryString;
    var requestbody = boundary + crlf 
                    + 'Content-Disposition: form-data; name="dialog_attachments"' + crlf 
                    + crlf 
                    + smime_getDnDInfo().dialog_attachments 
                    + crlf 
                    + boundary + crlf
                    + 'Content-Disposition: form-data; name="attachments[]"; filename='
                    + '"' + filename + '"'
                    + crlf
                    + 'Content-Type: application/x-pkcs7-mime; smime-type=enveloped-data; name='
                    + '"' + filename + '"'
                    + crlf 
                    + crlf + cipherText 
                    + crlf + boundary 
                    +'--' + crlf;

	http_request.onreadystatechange = function(){
		if (http_request.readyState != 4) 
			return;
		submit_createmail(true);
	}
                
    http_request.open('POST', url, true);
    http_request.setRequestHeader(
            "Content-type", "multipart/form-data; boundary=\"" + boundaryString + "\""
            );
    http_request.setRequestHeader("Connection", "close");
    http_request.setRequestHeader("Content-length", requestbody.length);

    http_request.sendAsBinary(requestbody);
}



/**
 * Generate a random string of length 20
 * 
 * @return string
 */
function smime_randomString() {
	var chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
	var string_length = 20;
	var randomstring = '';
	for (var i=0; i<string_length; i++) {
		var rnum = Math.floor(Math.random() * chars.length);
		randomstring += chars.substring(rnum,rnum+1);
	}
	return randomstring;
}

/**
 * Generate MIME boundary
 *
 * @return string
 */
function smime_generateMIMEBoundary() {
        var rString = "zarafasmime." + smime_randomString();
        return rString;
}

/**
 * Clear the html_body UI element
 *
 * @return void
 */
function smime_clearBody() {
    if (typeof dhtml.FCKeditorAPI == 'undefined') {
        // no FCKEditor
        b = content.document.getElementById('html_body')
        b.value = ""
    }
    else {
        var inst =  dhtml.FCKeditorAPI.GetInstance('html_body');
        inst.SetHTML("");
    }
}

/**
 * Set the html_body UI element to a passed value
 *
 * @param text
 * @return void
 */
function smime_setBody(body) {
    if (typeof dhtml.FCKeditorAPI == 'undefined') {
        // no FCKEditor
        b = content.document.getElementById('html_body')
        b.value = body;
    }
    else {
        var inst = dhtml.FCKeditorAPI.GetInstance('html_body');
        inst.SetHTML(body);
    }
}

/**
 * Read the file path of the selected attachment, append to smimeAttachmentList
 * and filelist UI 
 *
 * @param input html element
 * @return void
 */
function smime_updateFilelistAdd(fileinput) {
    // update attachment window filelist
    var filelist = document.getElementById('filelist');
    var file = document.createElement('option');
    file.appendChild(document.createTextNode(fileinput.value));
    filelist.appendChild(file);    
    
    // update parent window filelist
    var itemattachments = opener.document.getElementById("itemattachments")
    var file = document.createElement('span');
    file.appendChild(document.createTextNode(" " + fileinput.value + ";"));
    itemattachments.appendChild(file);

    // we need xpcom access to get the full path
	try {
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
	} catch (e) {	    
	    r = confirm(_("Firefox secure access, needed for S/MIME plugin to work is not enabled. If you want to configure secure access, please press 'OK' and download the 'zarafaconf.html' file offered to you. Afterwards open the file and press 'Allow' on the security notice."));
	    
	    if (r) 
	        window.location="plugins/smime/userconf.php";
        else {
            alert(_("Cannot continue the S/MIME procedure."))
            return -1;
        }
	}
	
    // store the full path here to upload later
    opener.smimeAttachmentList.push(fileinput.value);

}

/**
 * Delete attachment from smimeAttachmentList and filelist UI 
 *
 * @param int index
 * @return void
 */
function smime_updateFilelistDelete(index) {

    if (index == -1)
        // no file selected
        return;
    
    //remove from window filelist
    var filelist = document.getElementById('filelist');
    var kids = filelist.childNodes;
    filelist.removeChild(kids[index]);

    // update parent window filelist
    var itemattachments = opener.document.getElementById("itemattachments")
    var kids = itemattachments.childNodes;
    itemattachments.removeChild(kids[index + 1]);
    
    // remove from smimeAttachmentList
    opener.smimeAttachmentList.splice(index, 1);
}
