<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php
/**
 * S/MIME support for webaccess
 *
 *
 * Created on 10.2009
 * Author: Giorgos Logiotatidis <seadog@sealabs.net>
 *
 * S/MIME support for webacess
 * Currently works only for Firefox
 * Support for encrypting, decrypting, signing and verifying 
 * S/MIME emails.
 *
 * Encryption works only for one reciptient for this version
 * 
 */
 
class Pluginsmime extends Plugin {

    /***
     * Get plugin includes
     *
     * @param mixed $data object(s) related to the hook
     * @return void
     */
     function dialogGetIncludes(&$data) {
        // ignore all dialos except createmail
        if ($data['task'] != 'createmail') return;
        $data['includes'][] = $this->getPluginPath() . 'plugin.smime.css';
     }
        
    /***
     * Function adds the Encrypt and Sign buttons to the menu of the createmail dialog
     *
     * @param mixed $data object(s) related to the hook
     * @return void
     */ 
    function modifyDialogMenu(&$data) {
    
        // ingore all dialogs except "createmail"
        if ($data["task"] != "createmail") return;

        // hijack the 'Send' and 'Save' buttons
        // to execute our functions
        for ($c=0; $c < count($data['buttons']); $c++) {
            if ($data['buttons'][$c]['id'] == 'send') {
               $data['buttons'][$c]['callback'] = 'function() { smime_submitCreateMail(); }';
            }
            if ($data['buttons'][$c]['id'] == 'save') {
                $data['buttons'][$c]['callback'] = 'function() { smime_saveEmail(); }';
            }
        }
            
        // create new buttons for 'Sign' and 'Encrypt'
        $data['buttons'][] = array(
                                'id' => 'seperator',
                                'name' => '',
                                'title' => '',
                                'callback' => ''
                            );

        $data['buttons'][] = array(
                                'id' => 'smimelink_encrypt',
                                'name' => dgettext('plugin_smime', 'Encrypt'),
                                'title' => dgettext('plugin_smime', 'Encrypt this email'),
                                'callback' => 'function() { smime_toggleEncrypt(); }' // set variable encrypt to 'true'
                            );
        $data['buttons'][] = array(
                                'id' => 'smimelink_sign',
                                'name' => dgettext('plugin_smime', 'Sign'),
                                'title' => dgettext('plugin_smime', 'Sign this email'),
                                'callback' => 'function() { smime_toggleSign(); }' // set variable encrypt to 'true'
                            );
                            
    }

    /***
     * When viewing an encrypted message, populate the encrypted* tag in
     * the $data objects with the encrypted data
     *
     * @param mixed $data object(s) related to the hook
     * @return void
     */     
    function encryptedMessage($data) {
        // check if we have attachments
        if ($data['data']['item']['hasattach'] != 1)
            return;        

        // find the encrypted attachment
        for ($c=0; $c < count($data['data']['item']['attachments']['attachment']); $c++) 
            if ($data['data']['item']['attachments']['attachment'][$c]['filetype'] == "application/x-pkcs7-mime" or $data['data']['item']['attachments']['attachment'][$c]['filetype'] == "application/pkcs7-mime")
                break;           
                
        if ($c == count($data['data']['item']['attachments']['attachment']))
            // we didn't find any
            return;

        // check attachment
        $attachment = mapi_message_openattach($data['message'], $c);
        $stream = mapi_openpropertytostream($attachment, PR_ATTACH_DATA_BIN);
		$stat = mapi_stream_stat($stream);
        $cipherText = "";

		// Save attachment to $cipherText
		for($i = 0; $i < $stat["cb"]; $i += BLOCK_SIZE)
			$cipherText .= mapi_stream_read($stream, BLOCK_SIZE);

        $cipherText = base64_encode($cipherText);
        
        $cipherText = str_split($cipherText,4096);

        for($i=0; $i < count($cipherText); $i++) {
            $data['data']['item']['encrypted' . $i] = $cipherText[$i];           
            // FIXME with larger files (3mb) breaks. maybe a bus error, or php error?
            if ($i > 750)
                break;   
        }
        
        $data['data']['item']['body'] = "This encrypted email cannot be displayed in the Preview Panel. Open the message to read it.";
 
        // hide the encrypted attachment
        $data['data']['item']['attachments']['attachment'][$c]['hidden'] = 1;
       
    }

    /***
     * When viewing signed only messages verify the message origin using
     * php pkcs7 functionality and set the validSignature value
     *
     * @param mixed $data object(s) related to the hook
     * @return void
     */ 
    function signedMessage($data) {
    
        $data['data']['item']['validSignature'] = 0;
                   
        // check if we have attachments
        if ($data['data']['item']['hasattach'] != 1)
            return;
            
        // find the correct attachment
        for ($c=0; $c < count($data['data']['item']['attachments']['attachment']); $c++) 
            if ($data['data']['item']['attachments']['attachment'][$c]['filetype'] == "multipart/signed")
                break;
                
        if ($c == count($data['data']['item']['attachments']['attachment']))
            // we did not find any 
            return;
        
        
        // create a temporaty file and store the signed attachment there
        $attachment = mapi_message_openattach($data['message'], $c);
        $stream = mapi_openpropertytostream($attachment, PR_ATTACH_DATA_BIN);
		$stat = mapi_stream_stat($stream);
		$tmpfname = tempnam(Null, 'zsmime');
		$tmpfp = fopen($tmpfname, "w");
		for($i = 0; $i < $stat["cb"]; $i += BLOCK_SIZE) {
			// Print streamc
			fprintf($tmpfp, "%s", mapi_stream_read($stream, BLOCK_SIZE));
		}
		fclose($tmpfname);
		
		// now verify the attachment 
        $verify = openssl_pkcs7_verify($tmpfname, PKCS7_BINARY);

        // if attachment is verified correctly signed
        if ($verify == 1) {
            $data['data']['item']['validSignature'] = '1';
            
            $tmpfp = fopen($tmpfname, "r");
            for ($k=0; $k < count($data['data']['item']['attachments']['attachment']); $k++) {
                // poor (?) way of checking that the attachment is verified
                // find if the name of the attachment is included in the signed part
                $name = '"'.$data['data']['item']['attachments']['attachment'][$k]['name'].'"';              

                while ($line = fscanf($tmpfp, "Content-Disposition: attachment;%s")) 
                    if(strstr($line[0], $name) == 0) {
                        $data['data']['item']['attachments']['attachment'][$k]['name'] .= ' (verified)';
                        break;
                    fprintf($fp, $line[0]);
                }    
                    
                // rewind the file
                fseek($tmpfp, 0);    
            }           
            fclose($tmpfp);
                     
        }
        // if attachment is NOT verified correctly signed
        else if ($verify == -1) {
              $data['data']['item']['validSignature'] = -1;
        }
        // if an error occurs
        else {
              $data['data']['item']['validSignature'] = 0;
        }

        // remove temporary file
        unlink($tmpfname);
        // hide the signed attachment        
        $data['data']['item']['attachments']['attachment'][$c]['hidden'] = 1;
            
    }
    
    /***
     * Initialize the Plugin and register all hooks
     *
     * @ return void
     */
     function init() {
        $this->registerHook('server.dialog.general.setup.getincludes');
        $this->registerHook('server.dialog.general.setup.getmenubuttons');
        $this->registerHook('server.module.itemmodule.open.after');
     }
     
     /***
      * Function is executed when a hook is triggered by the PluginManager
      *
      * @param string $eventID the id of the triggered hook
      * @param mixed $data object(s) related to the hook
      * @return void
      */
      function execute($eventID, &$data) {
            switch($eventID) {
                case 'server.dialog.general.setup.getincludes':
                    $this->dialogGetIncludes($data);
                    break;
                case 'server.dialog.general.setup.getmenubuttons':
                    $this->modifyDialogMenu($data);
                    break;
                case 'server.module.itemmodule.open.after':               
                    if ($data['data']['item']['message_class'] == 'IPM.Note.SMIME.MultipartSigned')
                        $this->signedMessage($data);
                    elseif ($data['data']['item']['message_class'] == 'IPM.Note.SMIME')
                        $this->encryptedMessage($data);             
                    break;
            }
      }

}

?>
