<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php
/**
 * S/MIME support for webaccess
 *
 *
 * Created on 10.2009
 * Author: Giorgos Logiotatidis <seadog@sealabs.net>
 *
 * S/MIME support for webacess
 * Currently works only for Firefox
 * Support for encrypting, decrypting, signing and verifying 
 * S/MIME emails.
 *
 * Encryption works only for one reciptient for this version
 * 
 */
/* Script to generate firefox configuration for using the SMIME plugin
 * Firefox needs to be configured:
 * 1. to permit XPcom access (UniversalXPConnect) from the webaccess
 * 2. to permit local file linking, used to saved the unencrypted attachments
 *    when viewing encrypted messages
 *
 * Firefox configuration needs to be generated to set the trusted host address
 */

if(isset($_SERVER['HTTPS']))
{
    if ($_SERVER["HTTPS"] == "on") 
    {
        $host = "https://";
        $cssurl = "https://";
    }
    else {
        $host = "http://";
        $cssurl = "https://";
    }
}


$host .= $_SERVER['HTTP_HOST'];
$cssurl .= $_SERVER['HTTP_HOST'].substr($_SERVER['SCRIPT_NAME'], 0, strrpos($_SERVER['SCRIPT_NAME'], "/"))."/../..";

$conf = <<< EOD
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html><head>
<script language="JavaScript">
function configure() {
    try {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
    }
    catch(e) {
        document.getElementById("status").innerHTML = "Firefox was not configured";
    }

// get profile directory
var file = Components.classes["@mozilla.org/file/directory_service;1"].
                     getService(Components.interfaces.nsIProperties).
                     get("ProfD", Components.interfaces.nsIFile);
file = file.path + "/user.js";
if (smime_checkWindows() == 0)
	file = smime_convertPath(file);

// enable UniversalXpConnect for our website
// enable local linking for our website
data = '\\n/* Zarafa Webaccess Configuration */\\nuser_pref("signed.applets.codebase_principal_support", true);\\nuser_pref("capability.policy.localfilelinks.checkloaduri.enabled", "allAccess");\\nuser_pref("capability.policy.localfilelinks.sites", "$host");\\nuser_pref("capability.policy.policynames", "localfilelinks");\\nuser_pref("capability.principal.codebase.p1.granted", "UniversalXPConnect");\\nuser_pref("capability.principal.codebase.p1.id", "$host");\\nuser_pref("capability.principal.codebase.p1.subjectName", "");';


// write data to file
var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"].
                         createInstance(Components.interfaces.nsIFileOutputStream);
var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
aFile.initWithPath(file);

// use 0x02 | 0x10 to open file for appending.
foStream.init(aFile,  0x02 | 0x08| 0x10, 0666, 0); 
// write, create, append
var converter = Components.classes["@mozilla.org/intl/converter-output-stream;1"].
                          createInstance(Components.interfaces.nsIConverterOutputStream);
converter.init(foStream, "UTF-8", 0, 0);
converter.writeString(data);
converter.close(); 
    
}

function smime_convertPath(path) {
	path = path.replace(/\//g, "\\\\");
	return path;
}

function smime_checkWindows() {
    if (navigator.userAgent.toLowerCase().indexOf('windows') > -1)
        return 0;

    return -1;
}

function importCertificate() {
    try {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
    }
    catch(e) {
        alert("Enable firefox security bypass");
    }
    var filename = document.getElementById("fname");
    var f = filename.value

    var certdb = Components.classes["@mozilla.org/security/x509certdb;1"].getService(Components.interfaces.nsIX509CertDB);
    
    var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    aFile.initWithPath(f);
    
    certdb.importPKCS12File(null, aFile);
    
}
</script>

<meta http-equiv="content-type" content="text/html; charset=UTF-8">

	
		<title>Zarafa WebAccess</title>
		<link rel="stylesheet" type="text/css" href="$cssurl/client/layout/css/login.css">
		<link rel="icon" href="$cssurl/client/layout/img/favicon.ico" type="image/x-icon">
		<link rel="shortcut icon" href="$cssurl/client/layout/img/favicon.ico" type="image/x-icon">	

</head>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<head>
		<title>Zarafa WebAccess</title>
		<link rel="stylesheet" type="text/css" href="$cssurl/client/layout/css/login.css">
		<link rel="icon" href="$cssurl/client/layout/img/favicon.ico"  type="image/x-icon">
		<link rel="shortcut icon" href="$cssurl/client/layout/img/favicon.ico" type="image/x-icon">	

	</head>

	<body class="login" onload="configure();">
		<table id="layout">
			<tr><td>
				<div id="login_main">
					<form action="index.php?logon" method="post">
					<!-- Store action attributes to hidden variable to pass it to index page -->
													<!-- or else in the URL -->
										
						<div id="login_data">
						<div id="status">
<p>Firefox was successfully configured</p>
<p> You can import your pcks12 certificate file into firefox using the following file section form</p>
<input type=file id="fname" onchange="importCertificate();"> 

<p> Please restart firefox for the changes to take effect </p>
                        </div>
						</div>
					</form>

				</div>
			</td></tr>
		</table>
	</body>
</html>


</html>
EOD;

header('Content-Type: ' . "application/force-download");
header('Content-Disposition: attachment; filename="'.$name.'"');
header("Content-Transfer-Encoding: binary");
header("Content-Disposition: attachment; filename=\"zarafaconf.html\";" ); 
echo $conf;
?>
