<?php
/**
 * DSPAM training plugin
 *
 * Author: Holger de Carne <hdecarne@gmail.com>
 *
 */

class Plugindspam extends Plugin {

	private $_log;

	function Plugindspam() {
		$defaults = $this->getDefaults();
		$this->_log = $defaults['dspam_log'];
		$this->log('Status: Plugindspam constructed');
	}

	function init() {
		$this->registerHook('server.module.maillistmodule.execute.before');
		$this->log('Status: Plugindspam initialized');
	}

	function execute($eventID, &$data) {
		switch($eventID) {
		case 'server.module.maillistmodule.execute.before':
			$this->log('Event: server.module.maillistmodule.execute.before');
			$this->mailListModuleExecute($data['moduleObject']);
			break;
		}
	}

	function mailListModuleExecute(&$maillist) {
		$defaults = $this->getDefaults();
		foreach($maillist->data as $action) {
			if(isset($action['attributes']) && isset($action['attributes']['type'])) {
				if (isset($defaults['dspam_train_spam_cmd']) && isset($defaults['dspam_train_ham_cmd'])) {
					$store = $maillist->getActionStore($action);
					$parentEntryID = $maillist->getActionParentEntryID($action);
					$entryID = $maillist->getActionEntryID($action);
					$actionType = $action['attributes']['type'];
					$this->log('Action: '.$actionType);
					switch($actionType) {
					case 'dspamTrainSPAM':
						$result = $this->invokeDSPAMTrain($store, $entryID, $defaults['dspam_train_spam_cmd']);
						if ($result) {
							$maillist->delete($store, $parentEntryID, array($entryID), $action);
						}
						break;
					case 'dspamTrainHAM':
						$result = $this->invokeDSPAMTrain($store, $entryID, $defaults['dspam_train_ham_cmd']);
						break;
					}
				} else {
					$this->log('Error: Parameter dspam_train_spam_cmd or dspam_train_ham_cmd is not defined in config.php');
				}
			}
		}
	}

	function invokeDSPAMTrain($store, $entryID, $cmdPattern) {
		$status = false;
		$defaults = $this->getDefaults();
		$session = $this->getSession();
		$message = mapi_msgstore_openentry($store, $entryID);
		$props = mapi_getprops($message, array(PR_TRANSPORT_MESSAGE_HEADERS));
		if (isset($props[PR_TRANSPORT_MESSAGE_HEADERS])) {
			$headers = str_replace("\r", '', $props[PR_TRANSPORT_MESSAGE_HEADERS]);
			$addressBook = mapi_openaddressbook($session->getSession());
			$stream = mapi_inetmapi_imtoinet($session->getSession(), $addressBook, $message, array());
			if($stream) {
				$user = $session->getUserName();
				$cmd = str_replace('%u', $user, $cmdPattern);
				$this->log('Debug: Invoking command "'.$cmd.'"');
				$pipe = popen($cmd, 'w');
				if($pipe) {
					$this->log('Debug: Streaming message to command');
					fwrite($pipe, $headers);
					fwrite($pipe, "\n");
					$this->log($headers);
					while(($read = mapi_stream_read($stream, 4096))) {
						$read = str_replace("\r", '', $read);
						fwrite($pipe, $read);
						$this->log($read, false);
					}
					$this->log('');
					$pclose = pclose($pipe);
					$status = ($pclose == 0);
					if(!$status) {
						$this->log('Error: Command "'.$cmd.'" finished with status '.$pclose);
					} else {
						$this->log('Debug: Command "'.$cmd.'" finished with status '.$pclose);
					}
				} else {
					$this->log('Error: Failed to open command "'.$cmd.'"');
				}
			} else {
				$this->log('Error: Failed to open MAPI stream');
			}
		} else {
			$this->log('Error: Message has no headers');
		}
		return $status;
	}

	function getDefaults() {
		return $GLOBALS['pluginconfig']['dspam']['defaults'];
	}

	function getSession() {
		return $GLOBALS["mapisession"];
	}

	function log($message, $newline = true) {
		if($this->_log) {
			$log = fopen($this->_log, 'a');
			if($log) {
				fwrite($log, $message);
				if($newline) {
					fwrite($log, "\n");
				}
				fclose($log);
			}
		}
	}

}

?>
