<?php
/**
 * Global plugin settings.
 */

/**
 * Logging - Logging is only meant for debugging purposes. Please note that
 * sensitive information (e.g. manager password, phone numbers) might be visible
 * in this log.
 */
define('PLUGIN_PLACECALL_LOGGING_ENABLED', false);
define('PLUGIN_PLACECALL_LOGGING_FILE', '/tmp/placecall.log');

/**
 * The plugin either allows to the user to enter his phone manually
 * or it derives the phone identifier from a specific user property.
 * For the latter define the user property here containing the user's phone.
 * Setting this option to false allows the user to enter the phone on it's own. 
 */
define('PLUGIN_PLACECALL_CALLER_PROPERTY', false);

/**
 * Prior to invoking the PBX the callee's number is normalized to the following format:
 * INTPREFIX INTCODE NATCODE 12345678
 * with INTPREFIX: The international calling prefix (e.g. 00)
 *      INTCODE  : The international calling code (e.g. 49 for Germany)
 *      INTPREFIX: The national call prefix (e.g. 0)
 *      NATCODE  : The national country calling code (e.g. 89 for Munich) 
 * e.g.: 12345678			=>	00498912345678
 *       069 12345678		=>	00496912345678
 *       0049 30 12345678	=>	00493012345678
 *       +41 79 12345678	=>	00417912345678
 */
define('PLUGIN_PLACECALL_INTPREFIX', '00');
define('PLUGIN_PLACECALL_INTCODE', '49');
define('PLUGIN_PLACECALL_NATPREFIX', '0');
define('PLUGIN_PLACECALL_NATCODE', '89');

/**
 * The PBX interface to use.
 * 'astspool': Use Asterisk Call Files to originate the call.
 * 'astmgr'  : Use the Asterisk Manager API to originate the call.
 * 'fsesl'   : Use the Freeswitch event socket to originate the call.
 * 'cli'     : Use command line interface to originate the call.
 */
define('PLUGIN_PLACECALL_API','astmgr');

/**
 * Settings for Asterisk Call File generation:
 * TMPPATH    : The temporary folder to create the Call File; need to be on the same fs
 *              as the outgoing folder, to ensure that mv is not a copy operation
 * OUTGOINGDIR: The Asterisk monitored spool folder
 * CHGGRP     : The group of the created Call File; should be the Asterisk group to grant
 *              write access to the Asterisk user.
 * CHANNEL    : See Asterisk documentation ($1 is replaced by the user's phone) 
 * MAXRETRIES : See Asterisk documentation
 * RETRYTIME  : See Asterisk documentation
 * WAITTIME   : See Asterisk documentation
 * CONTEXT    : See Asterisk documentation
 * PRIORITY   : See Asterisk documentation
 */
define('PLUGIN_PLACECALL_ASTSPOOL_TMPPATH', '/var/spool/asterisk/tmp');
define('PLUGIN_PLACECALL_ASTSPOOL_OUTGOINGDIR', '/var/spool/asterisk/outgoing');
define('PLUGIN_PLACECALL_ASTSPOOL_CHGGRP', 'asterisk');
define('PLUGIN_PLACECALL_ASTSPOOL_CHANNEL', 'SIP/%1$s');
define('PLUGIN_PLACECALL_ASTSPOOL_MAXRETRIES', 1);
define('PLUGIN_PLACECALL_ASTSPOOL_RETRYTIME', 60);
define('PLUGIN_PLACECALL_ASTSPOOL_WAITTIME', 30);
define('PLUGIN_PLACECALL_ASTSPOOL_CONTEXT', 'sip');
define('PLUGIN_PLACECALL_ASTSPOOL_PRIORITY', 1);

/**
 * Settings for Asterisk Manager API access:
 * HOST    : The host to connect to 
 * PORT    : The port to connect to
 * USERNAME: The user name to use for login as defined in manager.conf
 * SECRET  : The password to use for login as defined in manager.conf
 * CHANNEL : See Asterisk documentation (%1$s is replaced by the user's phone) 
 * TIMEOUT : See Asterisk documentation
 * CONTEXT : See Asterisk documentation
 * PRIORITY: See Asterisk documentation
 */
define('PLUGIN_PLACECALL_ASTMGR_HOST', 'localhost');
define('PLUGIN_PLACECALL_ASTMGR_PORT', 5038);
define('PLUGIN_PLACECALL_ASTMGR_USERNAME', 'apache');
define('PLUGIN_PLACECALL_ASTMGR_SECRET', 'secret');
define('PLUGIN_PLACECALL_ASTMGR_CHANNEL', 'SIP/%1$s');
define('PLUGIN_PLACECALL_ASTMGR_TIMEOUT', 10000);
define('PLUGIN_PLACECALL_ASTMGR_CONTEXT', 'sip');
define('PLUGIN_PLACECALL_ASTMGR_PRIORITY', 1);

/**
 * Settings for Freeswitch event socket access:
 * HOST      : The host to connect to
 * PORT      : The port to connect to
 * SECRET    : The password to use for authentication
 * ORIGINATE : See Freeswitch documentation (%1$s is replaced by the user's phone and %2$s by the called number)
 */
define('PLUGIN_PLACECALL_FSESL_HOST', 'localhost');
define('PLUGIN_PLACECALL_FSESL_PORT', 8021);
define('PLUGIN_PLACECALL_FSESL_SECRET', 'ClueCon');
define('PLUGIN_PLACECALL_FSESL_ORIGINATE', 'originate sofia/internal/%1$s %2$s xml default %2$s %2$s');

/**
 * Settings for CLI invocation:
 * CMD: The command line to invoke (%1$s is replaced by the user's phone and %2$s by the called number)
 */
define('PLUGIN_PLACECALL_CLI_CMD', '/opt/freeswitch/bin/fs_cli -p ClueCon -x "originate sofia/internal/%1$s %2$s xml default %2$s %2$s"');

/**
 * Per user plugin settings.
 */

/**
 * Enable the placecall plugin for all clients
 */
define('PLUGIN_PLACECALL_USER_DEFAULT_ENABLE', false);

?>
