<?php
/*
 * Copyright 2012-2013 Holger de Carne
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Affero General Public License, version 3,
* as published by the Free Software Foundation with the following additional
* term according to sec. 7:
*
* According to sec. 7 of the GNU Affero General Public License, version
* 3, the terms of the AGPL are supplemented with the following terms:
*
* "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
* the Program under the AGPL does not imply a trademark license.
* Therefore any rights, title and interest in our trademarks remain
* entirely with us.
*
* However, if you propagate an unmodified version of the Program you are
* allowed to use the term "Zarafa" to indicate that you distribute the
* Program. Furthermore you may use our trademarks where it is necessary
* to indicate the intended purpose of a product or service provided you
* use it in accordance with honest practices in industrial or commercial
* matters.  If you want to propagate modified versions of the Program
* under the name "Zarafa" or "Zarafa Server", you may only do so if you
* have a written permission by Zarafa B.V. (to acquire a permission
		* please contact Zarafa at trademark@zarafa.com).
*
* The interactive user interface of the software displays an attribution
* notice containing the term "Zarafa" and/or the logo of Zarafa.
* Interactive user interfaces of unmodified and modified versions must
* display Appropriate Legal Notices according to sec. 5 of the GNU
* Affero General Public License, version 3, when you propagate
* unmodified or modified versions of the Program. In accordance with
* sec. 7 b) of the GNU Affero General Public License, version 3, these
* Appropriate Legal Notices must retain the logo of Zarafa or display
* the words "Initial Development by Zarafa" if the display of the logo
* is not reasonably feasible for technical reasons. The use of the logo
* of Zarafa in Legal Notices is allowed for unmodified and modified
* versions of the software.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

class astmgrPlaceCallAPI extends PlaceCallAPI{

	private $_socket = false;
	
	public function __construct($module) {
		parent::__construct($module);
	}
	
	public function placeCall($caller, $callee) {
		$status = false;
		$this->log("DEBUG: Orginating call via Asterisk Manager for caller '{$caller}' and callee '{$callee}'...");
		if($this->login() !== false) {
			$status = $this->originate($caller, $callee);
			$this->logoff();
		}
		return $status;
	}
	
	private function login() {
		$this->_socket = fsockopen(PLUGIN_PLACECALL_ASTMGR_HOST,PLUGIN_PLACECALL_ASTMGR_PORT,$errno,$errstr,1);
		if($this->_socket !== false) {
			stream_set_timeout($this->_socket, 1);
			$loginAction = 'Action: Login';
			$loginAction .= "\r\nUsername: ".PLUGIN_PLACECALL_ASTMGR_USERNAME;
			$loginAction .= "\r\nSecret: ".PLUGIN_PLACECALL_ASTMGR_SECRET;
			$loginAction .= "\r\nEvents: off";
			$loginAction .= "\r\n\r\n";
			$response = $this->sendRecv($loginAction);
			if(stripos($response,'Response: Success') === false) {
				$this->log('ERROR: Asterisk Manager login failed');
				fclose($this->_socket);
				$this->_socket = false;
			}
		} else {
			$this->log('ERROR: Connection to '.PLUGIN_PLACECALL_ASTMGR_HOST.':'.PLUGIN_PLACECALL_ASTMGR_PORT." failed with error: ({$errno}) ${errstr}");
		}
		return $this->_socket;
	}
	
	private function logoff() {
		$logoffAction = 'Action: Logoff';
		$logoffAction .= "\r\n\r\n";
		$this->sendRecv($logoffAction);
		fclose($this->_socket);
		$this->_socket = false;
	}
	
	private function originate($caller, $callee) {
		$callchannel = sprintf(PLUGIN_PLACECALL_ASTMGR_CHANNEL, $caller);
		$originateAction = 'Action: Originate';
		$originateAction .= "\r\nChannel: {$callchannel}";
		$originateAction .= "\r\nExten: {$callee}";
		$originateAction .= "\r\nCallerID: {$callee}";
		$originateAction .= "\r\nPriority: ".PLUGIN_PLACECALL_ASTMGR_PRIORITY;
		$originateAction .= "\r\nTimeout: ".PLUGIN_PLACECALL_ASTMGR_TIMEOUT;
		$originateAction .= "\r\nContext: ".PLUGIN_PLACECALL_ASTMGR_CONTEXT;
		$originateAction .= "\r\nAsync: 1";
		$originateAction .= "\r\n\r\n";
		$response = $this->sendRecv($originateAction);
		return stripos($response,'Response: Success') !== false;
	}
	
	private function sendRecv($action) {
		$response = false;
		if($this->_socket !== false) {
			$this->log('DEBUG: Sending request');
			$this->log($action, false);
			fputs($this->_socket, $action);
			do {
				$received = fgets($this->_socket);
				if($received !== false) {
					$response .= $received;
				}
				$status = stream_get_meta_data($this->_socket);
			} while($received != "\r\n" && $status['timed_out'] == false);
			$this->log('DEBUG: Received response');
			$this->log($response, false);
		}
		return $response;
	}
	
}

?>
