Ext.namespace('Zarafa.plugins.spamtrain');

/**
 * @class Zarafa.plugins.spamtrain.ABOUT
 * @extends String
 *
 * The copyright string holding the copyright notice for the spamtrain Plugin.
 */
Zarafa.plugins.spamtrain.ABOUT = ""
	+ "<p>Copyright (C) 2012-2013  Holger de Carne</p>"

	+ "<p>This program is free software: you can redistribute it and/or modify "
	+ "it under the terms of the GNU Affero General Public License as "
	+ "published by the Free Software Foundation, either version 3 of the "
	+ "License, or (at your option) any later version.</p>"

	+ "<p>This program is distributed in the hope that it will be useful, "
	+ "but WITHOUT ANY WARRANTY; without even the implied warranty of "
	+ "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
	+ "GNU Affero General Public License for more details.</p>"

	+ "<p>You should have received a copy of the GNU Affero General Public License "
	+ "along with this program.  If not, see <a href=\"http://www.gnu.org/licenses/\" target=\"_blank\">http://www.gnu.org/licenses/</a>.</p>";
Ext.namespace('Zarafa.plugins.spamtrain');

/**
 * @class Zarafa.plugins.spamtrain.SpamtrainPlugin
 * @extends Zarafa.core.Plugin
 *
 * This class integrates the plugin into the WebApp and allows
 * the user to train the spam filter with spam and ham mails.
 */
Zarafa.plugins.spamtrain.SpamtrainPlugin = Ext.extend(Zarafa.core.Plugin, {

	/**
	 * @constructor
	 * @param {Object} config Configuration object
	 *
	 */
	constructor : function (config)	{
		config = config || {};
		
		Ext.applyIf(config, {
			name : 'spamtrain',
			displayName : _('Spam training plugin'),
			about : Zarafa.plugins.spamtrain.ABOUT
		});
		Zarafa.plugins.spamtrain.SpamtrainPlugin.superclass.constructor.call(this, config);
		this.registerInsertionPoint('context.mail.contextmenu.options', this.putTrainSpamInContextMenu, this);
		this.registerInsertionPoint('context.mail.contextmenu.options', this.putTrainHamInContextMenu, this);
	},

	/**
	 * Creates the train spam command entry.
	 *
	 * @return {Zarafa.core.ui.menu.ConditionalItem} menuItem MenuItem instance
	 */
	putTrainSpamInContextMenu : function() {
		return {
			xtype				: 'zarafa.conditionalitem',
			text				: _('Junk', 'plugin_spamtrain'),
			overflowText		: _('Junk', 'plugin_spamtrain'),
			iconCls				: 'icon_spamtrain_spam',
			singleSelectOnly	: true,
			handler				: this.trainSpam,
			scope				: this
		};
	},

	/**
	 * Creates the train ham command entry.
	 *
	 * @return {Zarafa.core.ui.menu.ConditionalItem} menuItem MenuItem instance
	 */
	putTrainHamInContextMenu : function() {
		return {
			xtype				: 'zarafa.conditionalitem',
			text				: _('No junk', 'plugin_spamtrain'),
			overflowText		: _('No junk', 'plugin_spamtrain'),
			iconCls				: 'icon_spamtrain_ham',
			singleSelectOnly	: true,
			handler				: this.trainHam,
			scope				: this
		};
	},

	/**
	 * Perform a spam train call with the currently selected mail.
	 *
	 * @param {Object} menuitem The menu item which was clicked
	 */
	trainSpam : function(menuitem) {
		var selectedRecords = menuitem.getRecords();
		var selectedRecord = selectedRecords[0];
		
		container.getRequest().singleRequest('spamtrainmodule', 'trainspam', {
			entryid : selectedRecord.get('entryid'),
			parent_entryid : selectedRecord.get('parent_entryid'),
			store_entryid : selectedRecord.get('store_entryid'),
			profile : 'spamtrain'
		});
	},

	/**
	 * Perform a ham train call with the currently selected email.
	 *
	 * @param {Object} menuitem The menu item which was clicked
	 */
	trainHam : function(menuitem) {
		var selectedRecords = menuitem.getRecords();
		var selectedRecord = selectedRecords[0];
		
		container.getRequest().singleRequest('spamtrainmodule', 'trainham', {
			entryid : selectedRecord.get('entryid'),
			parent_entryid : selectedRecord.get('parent_entryid'),
			store_entryid : selectedRecord.get('store_entryid'),
			profile : 'spamtrain'
		});
	}

});

Zarafa.onReady(function() {
	if(container.getSettingsModel().get('zarafa/v1/plugins/spamtrain/enable') === true) {
		container.registerPlugin(new Zarafa.plugins.spamtrain.SpamtrainPlugin());
	}
});
