<?php

/*
 * Copyright 2011 - 2012 COMBIRD
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation with the following additional
 * term according to sec. 7:
 *
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 *
 * "Combird" is a trademark of Van Leyden Multimedia B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 *
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Combird" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Combird" or "Combird SyrinX voice plugin", you may only do 
 * so if you have a written permission by Combird (to acquire a 
 * permission please contact Combird at info@combird.nl).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */




/*
 * asterisk.php
 * this file is called from javascript. example: asterisk.php?nummer=1234567890
 */

include('/../config.php');
include('../users.php');
include('./class.syrinxfunctions.php');

// if they actually supplied a number ...
if ($_GET['nummer']) {
	try {

		$nr = SYRINX_DIAL_PREFIX . $_GET['nummer'];
		$nr = str_replace("(", "", $nr);
		$nr = str_replace(")", "", $nr);
		$nr = str_replace(" ", "", $nr);
		$nr = str_replace("-", "", $nr);
		$nr = str_replace("+", "00", $nr);

		$func = new syrinxFunctions(); // gain access to decryption functions.
		$user = $func->getUser(); //get our local user.
		makeCall($nr, $user); //establish a call between caller and called.
		echo 'dialed succesfully.'; // if we do not get an error, we return succes.
	} catch( Exception $e ) {
		echo 'Error.'; // if for whatever reason this fails, we let the javascript know we bailed.
	}
}

// Make call function.
function makeCall($toNumber,$fromUser) {
	// Fetch some parameters from the config.php.
    	$managerUser = SYRINX_MAN_USR; 
    	$managerPwd = SYRINX_MAN_PWD;
    	$managerPort = SYRINX_MAN_PORT;
    	$SystemIP = SYRINX_SERVER_IP;

	//Get userNumber
	$fromNumber = getUsernr($fromUser);
	if ($fromNumber != -1) {	  
    		//Open connection and send data.
    		$socket = fsockopen($SystemIP,$managerPort, $errno, $errstr, 60);
    		if(!$socket){ die("Error Connecting to Asterisk Server ".$SystemIP);echo("Socket error"); }
    		fputs($socket, "Action: Login\r\n");
    		fputs($socket, "UserName: ".$managerUser."\r\n");
    		fputs($socket, "Secret: ".$managerPwd."\r\n\r\n");
    		fputs($socket, "Action: Originate\r\n");
    		fputs($socket, "Channel: local/".$fromNumber."\r\n");
    		fputs($socket, "Context: default\r\n");
    		fputs($socket, "Exten: " . $toNumber . "\r\n");
    		fputs($socket, "Priority: 1\r\n");
    		fputs($socket, "Callerid: ".$fromNumber."\r\n\r\n");
    		fputs($socket, "Action: Logoff\r\n\r\n");
    		$wrets=fgets($socket,128);
	}
}

function getUsernr($fromUser) {
		// Find $fromUser in array $userMapping and return value e.g.
		//      $userMapping = array("admin@example.com" => "001" )
	$users = new syrinxUsers; //gain access to the function to get the users.
	$userMapping = $users->getUsers(); // obtain the array from users.php.
	$found = false;
	$result = "";
	foreach ($userMapping as $user => $num) { // for all users in the array, attempt to find our [ID] number.
		if (strcmp(strtolower(explode('@',$user)),strtolower($fromUser))) { // Find [USER], without looking at the '@domain'.
			$found = true;
			$result = $num;
			break;
		}
	}  
	
	if ($result != 0) {
		return $result;
	} else { // null value becomes invalidated.
		return -1;
	}
}
?>
