<?php

/*
 * Copyright 2011 - 2012 COMBIRD
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation with the following additional
 * term according to sec. 7:
 *
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 *
 * "Combird" is a trademark of Van Leyden Multimedia B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 *
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Combird" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Combird" or "Combird SyrinX voice plugin", you may only do 
 * so if you have a written permission by Combird (to acquire a 
 * permission please contact Combird at info@combird.nl).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */



include('../config.php');
class syrinxFunctions {
	// fetch USER from cookie.
	function getUser() {
		$tmpVar = explode('~', $this->decrypt($_COOKIE["SYRINX_SETTINGS"], PLUGIN_SYRINX_ENCRYPTKEY));
		return trim($tmpVar[0]);
	}

	function getPassword() {
		$tmpVar = explode("~", $this->decrypt($_COOKIE["SYRINX_SETTINGS"], PLUGIN_SYRINX_ENCRYPTKEY));
		return trim($tmpVar[1]);
	}

	// decrypt cookie.
	private function decrypt($string, $key) {
		$result = '';
		$string = $this -> safe_b64decode($string);

		for($i = 0; $i < strlen($string); $i++) {
			$char = substr($string, $i, 1);
			$keychar = substr($key, ($i % strlen($key)) - 1, 1);
			$char = chr(ord($char) - ord($keychar));
			$result .= $char;
		}
		return $result;
	}

	private function safe_b64decode($string) {
		$data = str_replace( array('-', '_'), array('+', '/'), $string);
		$mod4 = strlen($data) % 4;
		if($mod4) {
			$data .= substr('====', $mod4);
		}
		return    base64_decode($data);
	}

}
