/*
 * Copyright 2011 - 2012 COMBIRD
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation with the following additional
 * term according to sec. 7:
 *
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 *
 * "Combird" is a trademark of Van Leyden Multimedia B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 *
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Combird" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Combird" or "Combird SyrinX voice plugin", you may only do 
 * so if you have a written permission by Combird (to acquire a 
 * permission please contact Combird at info@combird.nl).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

Pluginsyrinxvoice.prototype = new Plugin;
Pluginsyrinxvoice.prototype.constructor = Pluginsyrinxvoice;
Pluginsyrinxvoice.superclass = Plugin.prototype;


function getCookie(c_name) {
	if (document.cookie.length>0){
  	c_start=document.cookie.indexOf(c_name + "=");
  	if (c_start!=-1){ 
   		 c_start=c_start + c_name.length+1; 
   		 c_end=document.cookie.indexOf(";",c_start);
   		 if (c_end==-1) c_end=document.cookie.length;
   			 return unescape(document.cookie.substring(c_start,c_end));
   	 	} 
  	}
	return false;
}

function Pluginsyrinxvoice() {}

Pluginsyrinxvoice.prototype.setPluginName("Pluginsyrinxvoice");

// This is loaded at webaccess startup.
Pluginsyrinxvoice.prototype.init = function() {
	this.registerHook("client.module.contactlistmodule.contextmenu.buildup");
}

//This fires up when selecting the contacts menu, the actual item is appended to the contextmenu.
Pluginsyrinxvoice.prototype.execute = function(eventID, data) {
	switch (eventID) {
		case 'client.module.contactlistmodule.contextmenu.buildup':
			this.addMenuItems(data["contextmenu"]);
			break;
	}
}

/// append to menu.
Pluginsyrinxvoice.prototype.addMenuItems = function(data) {
	var lang = getCookie("SYRINX_LANG");
	var call = "Call";
	
	if (lang.split(".")[0] == "nl_NL") {
		call = "Opbellen";
	}
	data.push(webclient.menu.createMenuItem("seperator", ""));
	data.push(webclient.menu.createMenuItem("syrinxCall", call, false, syrinxCall));
	data.push(webclient.menu.createMenuItem("seperator", ""));
}

// When someone selects the call option.
function syrinxCall(moduleObject, element, event) {
	// close the popup menu.
	element.parentNode.style.display = "none";	
	
	var temp = moduleObject.getSelectedMessages(); // fetch the selected contact ID.
	var tags = document.getElementById(temp);
	if (document.all) { // This is supposedly for IE. 
		var allElements = document.all; 
	} else { // This is for actual browsers.
		var allElements = tags.getElementsByTagName("*"); 
	}
	var teller = 0;
	var values = new Array();
	var inRow = false;
	var info = "";
	var value = "";
	for (var i = 0; i < allElements.length; i++) { // We cycle through all the Table rows and cells to collect data.
		var tagname = allElements[i].tagName;
		if (tagname == "TR") { // since data is formatted as row {info, value} we use the bool inRow to track our position.
			inRow = true;
		}
		if (inRow == true) {
			if (allElements[i].className == "info") {
				info = allElements[i].innerHTML;
			}
			if ( allElements[i].className == "value" ) {
				value = allElements[i].innerHTML;
			}
			if ((inRow == true) && (info != "") && (value != "")) { // if all values have been found, store the row.
				values[teller] = new Array(2);
				values[teller][0] = info;
				values[teller][1] = value;
				teller++;
				info = "";
				value = "";
				inRow = false;
			}
		}
	}
	
	var cyclus = 0;
	var number = "";
	if (values.length != 0) { // If there actually is data ...
		while(number == "") { // while we do not have our number yet ...
			var lang = getCookie("SYRINX_LANG");

			var zoekterm = ""; // note: we search for Business -> Home -> Mobile. Swap the numbers to switch priority.
			if (cyclus == 0) {
				if (lang.split(".")[0] == "nl_NL") {
					zoekterm = "Werk:";
				} else {
					zoekterm = "Business:";
				}
			} else if (cyclus == 1) {
				if (lang.split(".")[0] == "nl_NL") {
					zoekterm = "Thuis:";
				} else {
					zoekterm = "Home:";
				}
			} else if (cyclus == 2) {
				if (lang.split(".")[0] == "nl_NL") {
					zoekterm = "Mobiel:";
				} else {
					zoekterm = "Mobile:";
				}
			}
			for (var x = 0; x < values.length; x++) { 
				if (values[x][0] == zoekterm) {
					number = values[x][1];
					break;
				}
			}
			cyclus++; // The number was not found, continue to next cycle for alternate number.
			if (cyclus == 3) { // Nothing found. Report.
				var lang = getCookie("SYRINX_LANG");
        			var err1 = "SyrinxVoice could not find a Business, Home or Mobile phone number on the selected contact..";
        			if (lang.split(".")[0] == "nl_NL") {
        			        err1 = "De SyrinxVoice plugin kon niet een zakelijke, persoonlijke of mobiel nummer vinden bij de contactpersoon.";
        			}

				alert(err1);	
				return;
			}
		}
	}
	// Number found, proceed to dial.
	callNumber(number);
}

function callNumber(number) {
	var http = new XMLHttpRequest(); // create httpRequest.
        var url = "plugins/syrinxvoice/classes/asterisk.php?nummer=" + number; // the local URL, with a $_GET['nummer'] containing the number

	http.open('GET', url, false); // Open connection synchroniously, so we wait for a reply.
	http.send(); // execute.
	
	var lang = getCookie("SYRINX_LANG");
        var err1 = "Unable to dial. Please check your connection.";
	var err2 = "Unknown serverside dialing error.";
	if (lang.split(".")[0] == "nl_NL") {
                err1 = "Kan niet bellen. Controleer uw verbinding met de server.";
		err2 = "Onbekende serverbelfout";
        }


	if (http.responseText == "") { // No response from server.
		alert(err1);
	} else if (http.responseText != "dialed succesfully.") { // reply from server was != 'dialed succesfully.' -> assume error.
		alert(err2);
	}
}
