<?php
/*
 * Copyright 2011 - 2012 COMBIRD
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation with the following additional
 * term according to sec. 7:
 *
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 *
 * "Combird" is a trademark of Van Leyden Multimedia B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 *
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Combird" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Combird" or "Combird SyrinX voice plugin", you may only do 
 * so if you have a written permission by Combird (to acquire a 
 * permission please contact Combird at info@combird.nl).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * SyrinXVoice server plugin. This handles storing the username into a cookie.
 * this cookie will be encrypted and retrieved when making a SyrinXcall.
 */

class Pluginsyrinxvoice extends Plugin {
	
	function Pluginsyrinxvoice() {
	}

	function init() {  // Append the cookie when logging in.
		$this -> registerHook('server.index.login.success');
	}

	function execute($eventID, &$data) {
		switch($eventID) {
			case "server.index.login.success" :
				$this -> addCredentials($data); //write cookie.
				break;
		}
	}

	// this will write the cookie.
	function addCredentials(&$data) {
		$encrypted = $this -> encrypt($_SESSION['username'] . 
		'~' . $_SESSION['password'], PLUGIN_SYRINX_ENCRYPTKEY);
		// Store clientside cookie
		echo("<script> document.cookie = 'SYRINX_LANG=" . $_SESSION['lang'] . "'; </script>");
		echo("<script> document.cookie = 'SYRINX_SETTINGS=" . $encrypted . "'; </script>");
	}

	// encrypts the data which will be placed into the cookie.
	private function encrypt($string, $key) {
		$result = '';
		for($i = 0; $i < strlen($string); $i++) {
			$char = substr($string, $i, 1);
			$keychar = substr($key, ($i % strlen($key)) - 1, 1);
			$char = chr(ord($char) + ord($keychar));
			$result .= $char;
		}

		return $this -> safe_b64encode($result);
	}

	private function safe_b64encode($string) {
		$data = base64_encode($string);
		$data = str_replace( array('+', '/', '='), array('-', '_', ''), $data);
		return $data;
	}

}
?>
