/**
 * ABOUT.js zarafa calender to ics im/exporter
 *
 * Author: Christoph Haas <christoph.h@sprinternet.at>
 * Copyright (C) 2012-2013 Christoph Haas
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
Ext.namespace('Zarafa.plugins.calendarimporter');

/**
 * @class Zarafa.plugins.calendarimporter.ABOUT
 * @extends String
 *
 * The copyright string holding the copyright notice for the Zarafa calendarimporter Plugin.
 */
Zarafa.plugins.calendarimporter.ABOUT = ""
	+ "<p>Copyright (C) 2012-2013  Christoph Haas &lt;christoph.h@sprinternet.at&gt;</p>"

	+ "<p>This program is free software; you can redistribute it and/or "
	+ "modify it under the terms of the GNU Lesser General Public "
	+ "License as published by the Free Software Foundation; either "
	+ "version 2.1 of the License, or (at your option) any later version.</p>"

	+ "<p>This program is distributed in the hope that it will be useful, "
	+ "but WITHOUT ANY WARRANTY; without even the implied warranty of "
	+ "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU "
	+ "Lesser General Public License for more details.</p>"

	+ "<p>You should have received a copy of the GNU Lesser General Public "
	+ "License along with this program; if not, write to the Free Software "
	+ "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA</p>"

	+ "<hr />"

	+ "<p>The calendarimporter plugin contains the following third-party components:</p>"
	
	+ "<h1>iCalcreator v2.16.12</h1>"

	+ "<p>Copyright 2007-2013 Kjell-Inge Gustafsson kigkonsult</p>"

	+ "<p>This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.</p>"
	
	+ "<p>This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.</p>"
	
	+ "<h1>Ics-parser</h1>"

	+ "<p>Copyright 2002-2007 Martin Thoma <info@martin-thoma.de></p>"

	+ "<p>Licensed under the MIT License.</p>"
	
	+ "<p>Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.</p>"/**
 * timezones.js zarafa calender to ics im/exporter
 *
 * Author: Christoph Haas <christoph.h@sprinternet.at>
 * Copyright (C) 2012-2013 Christoph Haas
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/**
 * Timezone class
 *
 * This class can handle all our timezone operations and conversions.
 */ 
Ext.namespace("Zarafa.plugins.calendarimporter.data"); 

Zarafa.plugins.calendarimporter.data.Timezones = Ext.extend(Object, {

	store :	[
		['Pacific/Midway','(UTC -11:00) Midway, Niue, Pago Pago', -660],
		['Pacific/Fakaofo','(UTC -10:00) Adak, Fakaofo, Honolulu, Johnston, Rarotonga, Tahiti', -600],
		['Pacific/Marquesas','(UTC -09:30) Marquesas', -570],
		['America/Anchorage','(UTC -09:00) Gambier, Anchorage, Juneau, Nome, Sitka, Yakutat', -540],
		['America/Dawson','(UTC -08:00) Dawson, Los Angeles, Tijuana, Vancouver, Whitehorse, Santa Isabel, Metlakatla, Pitcairn', -480],
		['America/Dawson_Creek','(UTC -07:00) Dawson Creek, Hermosillo, Phoenix, Chihuahua, Mazatlan, Boise, Cambridge Bay, Denver, Edmonton, Inuvik, Ojinaga, Shiprock, Yellowknife', -420],
		['America/Chicago','(UTC -06:00) Beulah, Center, Chicago, Knox, Matamoros, Menominee, New Salem, Rainy River, Rankin Inlet, Resolute, Tell City, Winnipeg', -360],
		['America/Belize','(UTC -06:00) Belize, Costa Rica, El Salvador, Galapagos, Guatemala, Managua, Regina, Swift Current, Tegucigalpa', -360],
		['Pacific/Easter','(UTC -06:00) Easter', -360],
		['America/Bahia_Banderas','(UTC -06:00) Bahia Banderas, Cancun, Merida, Mexico City, Monterrey', -360],
		['America/Detroit','(UTC -05:00) Detroit, Grand Turk, Indianapolis, Iqaluit, Louisville, Marengo, Monticello, Montreal, Nassau, New York, Nipigon, Pangnirtung, Petersburg, Thunder Bay, Toronto, Vevay, Vincennes, Winamac', -300],
		['America/Atikokan','(UTC -05:00) Atikokan, Bogota, Cayman, Guayaquil, Jamaica, Lima, Panama, Port-au-Prince', -300],
		['America/Havana','(UTC -05:00) Havana', -300],
		['America/Caracas','(UTC -04:30) Caracas', -270],
		['America/Glace_Bay','(UTC -04:00) Bermuda, Glace Bay, Goose Bay, Halifax, Moncton, Thule', -240],
		['Atlantic/Stanley','(UTC -04:00) Stanley', -240],
		['America/Santiago','(UTC -04:00) Palmer, Santiago', -240],
		['America/Anguilla','(UTC -04:00) Anguilla, Antigua, Aruba, Barbados, Blanc-Sablon, Boa Vista, Curacao, Dominica, Eirunepe, Grenada, Guadeloupe, Guyana, Kralendijk, La Paz, Lower Princes, Manaus, Marigot, Martinique, Montserrat, Port of Spain, Porto Velho, Puerto Rico, Rio Branco, Santo Domingo, St Barthelemy, St Kitts, St Lucia, St Thomas, St Vincent, Tortola', -240],
		['America/Campo_Grande','(UTC -04:00) Campo Grande, Cuiaba', -240],
		['America/Asuncion','(UTC -04:00) Asuncion', -240],
		['America/St_Johns','(UTC -03:30) St Johns', -210],
		['America/Sao_Paulo','(UTC -03:00) Sao Paulo', -180],
		['America/Araguaina','(UTC -03:00) Araguaina, Bahia, Belem, Buenos Aires, Catamarca, Cayenne, Cordoba, Fortaleza, Jujuy, La Rioja, Maceio, Mendoza, Paramaribo, Recife, Rio Gallegos, Rothera, Salta, San Juan, Santarem, Tucuman, Ushuaia', -180],
		['America/Montevideo','(UTC -03:00) Montevideo', -180],
		['America/Godthab','(UTC -03:00) Godthab', -180],
		['America/Argentina/San_Luis','(UTC -03:00) San Luis', -180],
		['America/Miquelon','(UTC -03:00) Miquelon', -180],
		['America/Noronha','(UTC -02:00) Noronha, South Georgia', -120],
		['Atlantic/Cape_Verde','(UTC -01:00) Cape Verde', -60],
		['America/Scoresbysund','(UTC -01:00) Azores, Scoresbysund', -60],
		['Atlantic/Canary','(UTC) Canary, Dublin, Faroe, Guernsey, Isle of Man, Jersey, Lisbon, London, Madeira', 0],
		['Africa/Abidjan','(UTC) Abidjan, Accra, Bamako, Banjul, Bissau, Casablanca, Conakry, Dakar, Danmarkshavn, El Aaiun, Freetown, Lome, Monrovia, Nouakchott, Ouagadougou, Reykjavik, Sao Tome, St Helena', 0],
		['Africa/Algiers','(UTC +01:00) Algiers, Bangui, Brazzaville, Douala, Kinshasa, Lagos, Libreville, Luanda, Malabo, Ndjamena, Niamey, Porto-Novo, Tunis', 60],
		['Europe/Vienna','(UTC +01:00) Amsterdam, Andorra, Belgrade, Berlin, Bratislava, Brussels, Budapest, Ceuta, Copenhagen, Gibraltar, Ljubljana, Longyearbyen, Luxembourg, Madrid, Malta, Monaco, Oslo, Paris, Podgorica, Prague, Rome, San Marino, Sarajevo, Skopje, Stockholm, Tirane, Vaduz, Vatican, Vienna, Warsaw, Zagreb, Zurich', 60],
		['Africa/Windhoek','(UTC +01:00) Windhoek', 60],
		['Asia/Damascus','(UTC +02:00) Damascus', 120],
		['Asia/Beirut','(UTC +02:00) Beirut', 120],
		['Asia/Jerusalem','(UTC +02:00) Jerusalem', 120],
		['Asia/Nicosia','(UTC +02:00) Athens, Bucharest, Chisinau, Helsinki, Istanbul, Mariehamn, Nicosia, Riga, Sofia, Tallinn, Vilnius', 120],
		['Africa/Blantyre','(UTC +02:00) Blantyre, Bujumbura, Cairo, Gaborone, Gaza, Harare, Hebron, Johannesburg, Kigali, Lubumbashi, Lusaka, Maputo, Maseru, Mbabane, Tripoli', 120],
		['Asia/Amman','(UTC +02:00) Amman', 120],
		['Africa/Addis_Ababa','(UTC +03:00) Addis Ababa, Aden, Antananarivo, Asmara, Baghdad, Bahrain, Comoro, Dar es Salaam, Djibouti, Juba, Kaliningrad, Kampala, Khartoum, Kiev, Kuwait, Mayotte, Minsk, Mogadishu, Nairobi, Qatar, Riyadh, Simferopol, Syowa, Uzhgorod, Zaporozhye', 180],
		['Asia/Tehran','(UTC +03:30) Tehran', 210],
		['Asia/Yerevan','(UTC +04:00) Yerevan', 240],
		['Asia/Dubai','(UTC +04:00) Dubai, Mahe, Mauritius, Moscow, Muscat, Reunion, Samara, Tbilisi, Volgograd', 240],
		['Asia/Baku','(UTC +04:00) Baku', 240],
		['Asia/Kabul','(UTC +04:30) Kabul', 270],
		['Antarctica/Mawson','(UTC +05:00) Aqtau, Aqtobe, Ashgabat, Dushanbe, Karachi, Kerguelen, Maldives, Mawson, Oral, Samarkand, Tashkent', 300],
		['Asia/Colombo','(UTC +05:30) Colombo, Kolkata', 330],
		['Asia/Kathmandu','(UTC +05:45) Kathmandu', 345],
		['Antarctica/Vostok','(UTC +06:00) Almaty, Bishkek, Chagos, Dhaka, Qyzylorda, Thimphu, Vostok, Yekaterinburg', 360],
		['Asia/Rangoon','(UTC +06:30) Cocos, Rangoon', 390],
		['Antarctica/Davis','(UTC +07:00) Bangkok, Christmas, Davis, Ho Chi Minh, Hovd, Jakarta, Novokuznetsk, Novosibirsk, Omsk, Phnom Penh, Pontianak, Vientiane', 420],
		['Antarctica/Casey','(UTC +08:00) Brunei, Casey, Choibalsan, Chongqing, Harbin, Hong Kong, Kashgar, Krasnoyarsk, Kuala Lumpur, Kuching, Macau, Makassar, Manila, Perth, Shanghai, Singapore, Taipei, Ulaanbaatar, Urumqi', 480],
		['Australia/Eucla','(UTC +08:45) Eucla', 525],
		['Asia/Dili','(UTC +09:00) Dili, Irkutsk, Jayapura, Palau, Pyongyang, Seoul, Tokyo', 540],
		['Australia/Adelaide','(UTC +09:30) Adelaide, Broken Hill', 570],
		['Australia/Darwin','(UTC +09:30) Darwin', 570],
		['Antarctica/DumontDUrville','(UTC +10:00) Brisbane, Chuuk, DumontDUrville, Guam, Lindeman, Port Moresby, Saipan, Yakutsk', 600],
		['Australia/Currie','(UTC +10:00) Currie, Hobart, Melbourne, Sydney', 600],
		['Australia/Lord_Howe','(UTC +10:30) Lord Howe', 630],
		['Antarctica/Macquarie','(UTC +11:00) Efate, Guadalcanal, Kosrae, Macquarie, Noumea, Pohnpei, Sakhalin, Vladivostok', 660],
		['Pacific/Norfolk','(UTC +11:30) Norfolk', 690],
		['Antarctica/McMurdo','(UTC +12:00) Auckland, McMurdo, South Pole', 720],
		['Asia/Anadyr','(UTC +12:00) Anadyr, Fiji, Funafuti, Kamchatka, Kwajalein, Magadan, Majuro, Nauru, Tarawa, Wake, Wallis', 720],
		['Pacific/Chatham','(UTC +12:45) Chatham', 765],
		['Pacific/Enderbury','(UTC +13:00) Enderbury, Tongatapu', 780],
		['Pacific/Apia','(UTC +13:00) Apia', 780],
		['Pacific/Kiritimati','(UTC +14:00) Kiritimati', 840]
	],
	
	/* map all citys to the above timezones */
	map : {
		/*-11:00*/
		'Etc/GMT+11' : 'Pacific/Midway',
		'Pacific/Midway' : 'Pacific/Midway',
		'Pacific/Niue' : 'Pacific/Midway',
		'Pacific/Pago_Pago' : 'Pacific/Midway',
		'Pacific/Samoa' : 'Pacific/Midway',
		'US/Samoa' : 'Pacific/Midway',
		/*-10:00*/
		'America/Adak' : 'Pacific/Fakaofo',
		'America/Atka' : 'Pacific/Fakaofo',
		'Etc/GMT+10' : 'Pacific/Fakaofo',
		'HST' : 'Pacific/Fakaofo',
		'Pacific/Honolulu' : 'Pacific/Fakaofo',
		'Pacific/Johnston' : 'Pacific/Fakaofo',
		'Pacific/Rarotonga' : 'Pacific/Fakaofo',
		'Pacific/Tahiti' : 'Pacific/Fakaofo',
		'SystemV/HST10' : 'Pacific/Fakaofo',
		'US/Aleutian' : 'Pacific/Fakaofo',
		'US/Hawaii' : 'Pacific/Fakaofo',
		/*-9:30*/
		'Pacific/Marquesas' : 'Pacific/Marquesas',
		/*-9:00*/
		'AST' : 'America/Anchorage',
		'America/Anchorage' : 'America/Anchorage',
		'America/Juneau' : 'America/Anchorage',
		'America/Nome' : 'America/Anchorage',
		'America/Sitka' : 'America/Anchorage',
		'America/Yakutat' : 'America/Anchorage',
		'Etc/GMT+9' : 'America/Anchorage',
		'Pacific/Gambier' : 'America/Anchorage',
		'SystemV/YST9' : 'America/Anchorage',
		'SystemV/YST9YDT' : 'America/Anchorage',
		'US/Alaska' : 'America/Anchorage',
		/*-8:00*/
		'America/Dawson' : 'America/Dawson',
		'America/Ensenada' : 'America/Dawson',
		'America/Los_Angeles' : 'America/Dawson',
		'America/Metlakatla' : 'America/Dawson',
		'America/Santa_Isabel' : 'America/Dawson',
		'America/Tijuana' : 'America/Dawson',
		'America/Vancouver' : 'America/Dawson',
		'America/Whitehorse' : 'America/Dawson',
		'Canada/Pacific' : 'America/Dawson',
		'Canada/Yukon' : 'America/Dawson',
		'Etc/GMT+8' : 'America/Dawson',
		'Mexico/BajaNorte' : 'America/Dawson',
		'PST' : 'America/Dawson',
		'PST8PDT' : 'America/Dawson',
		'Pacific/Pitcairn' : 'America/Dawson',
		'SystemV/PST8' : 'America/Dawson',
		'SystemV/PST8PDT' : 'America/Dawson',
		'US/Pacific' : 'America/Dawson',
		'US/Pacific-New' : 'America/Dawson',
		/*-7:00*/
		'America/Boise' : 'America/Dawson_Creek',
		'America/Cambridge_Bay' : 'America/Dawson_Creek',
		'America/Chihuahua' : 'America/Dawson_Creek',
		'America/Creston' : 'America/Dawson_Creek',
		'America/Dawson_Creek' : 'America/Dawson_Creek',
		'America/Denver' : 'America/Dawson_Creek',
		'America/Edmonton' : 'America/Dawson_Creek',
		'America/Hermosillo' : 'America/Dawson_Creek',
		'America/Inuvik' : 'America/Dawson_Creek',
		'America/Mazatlan' : 'America/Dawson_Creek',
		'America/Ojinaga' : 'America/Dawson_Creek',
		'America/Phoenix' : 'America/Dawson_Creek',
		'America/Shiprock' : 'America/Dawson_Creek',
		'America/Yellowknife' : 'America/Dawson_Creek',
		'Canada/Mountain' : 'America/Dawson_Creek',
		'Etc/GMT+7' : 'America/Dawson_Creek',
		'MST' : 'America/Dawson_Creek',
		'MST7MDT' : 'America/Dawson_Creek',
		'Mexico/BajaSur' : 'America/Dawson_Creek',
		'Navajo' : 'America/Dawson_Creek',
		'PNT' : 'America/Dawson_Creek',
		'SystemV/MST7' : 'America/Dawson_Creek',
		'SystemV/MST7MDT' : 'America/Dawson_Creek',
		'US/Arizona' : 'America/Dawson_Creek',
		'US/Mountain' : 'America/Dawson_Creek',
		/*-6:00*/
		'America/Bahia_Banderas' : 'America/Chicago',
		'America/Belize' : 'America/Chicago',
		'America/Cancun' : 'America/Chicago',
		'America/Chicago' : 'America/Chicago',
		'America/Costa_Rica' : 'America/Chicago',
		'America/El_Salvador' : 'America/Chicago',
		'America/Guatemala' : 'America/Chicago',
		'America/Indiana/Knox' : 'America/Chicago',
		'America/Indiana/Tell_City' : 'America/Chicago',
		'America/Knox_IN' : 'America/Chicago',
		'America/Managua' : 'America/Chicago',
		'America/Matamoros' : 'America/Chicago',
		'America/Menominee' : 'America/Chicago',
		'America/Merida' : 'America/Chicago',
		'America/Mexico_City' : 'America/Chicago',
		'America/Monterrey' : 'America/Chicago',
		'America/North_Dakota/Beulah' : 'America/Chicago',
		'America/North_Dakota/Center' : 'America/Chicago',
		'America/North_Dakota/New_Salem' : 'America/Chicago',
		'America/Rainy_River' : 'America/Chicago',
		'America/Rankin_Inlet' : 'America/Chicago',
		'America/Regina' : 'America/Chicago',
		'America/Resolute' : 'America/Chicago',
		'America/Swift_Current' : 'America/Chicago',
		'America/Tegucigalpa' : 'America/Chicago',
		'America/Winnipeg' : 'America/Chicago',
		'CST' : 'America/Chicago',
		'CST6CDT' : 'America/Chicago',
		'Canada/Central' : 'America/Chicago',
		'Canada/East-Saskatchewan' : 'America/Chicago',
		'Canada/Saskatchewan' : 'America/Chicago',
		'Chile/EasterIsland' : 'America/Chicago',
		'Etc/GMT+6' : 'America/Chicago',
		'Mexico/General' : 'America/Chicago',
		'Pacific/Easter' : 'America/Chicago',
		'Pacific/Galapagos' : 'America/Chicago',
		'SystemV/CST6' : 'America/Chicago',
		'SystemV/CST6CDT' : 'America/Chicago',
		'US/Central' : 'America/Chicago',
		'US/Indiana-Starke' : 'America/Chicago',
		/*-5:00*/
		'America/Atikokan' : 'America/Detroit',
		'America/Bogota' : 'America/Detroit',
		'America/Cayman' : 'America/Detroit',
		'America/Coral_Harbour' : 'America/Detroit',
		'America/Detroit' : 'America/Detroit',
		'America/Fort_Wayne' : 'America/Detroit',
		'America/Grand_Turk' : 'America/Detroit',
		'America/Guayaquil' : 'America/Detroit',
		'America/Havana' : 'America/Detroit',
		'America/Indiana/Indianapolis' : 'America/Detroit',
		'America/Indiana/Marengo' : 'America/Detroit',
		'America/Indiana/Petersburg' : 'America/Detroit',
		'America/Indiana/Vevay' : 'America/Detroit',
		'America/Indiana/Vincennes' : 'America/Detroit',
		'America/Indiana/Winamac' : 'America/Detroit',
		'America/Indianapolis' : 'America/Detroit',
		'America/Iqaluit' : 'America/Detroit',
		'America/Jamaica' : 'America/Detroit',
		'America/Kentucky/Louisville' : 'America/Detroit',
		'America/Kentucky/Monticello' : 'America/Detroit',
		'America/Lima' : 'America/Detroit',
		'America/Louisville' : 'America/Detroit',
		'America/Montreal' : 'America/Detroit',
		'America/Nassau' : 'America/Detroit',
		'America/New_York' : 'America/Detroit',
		'America/Nipigon' : 'America/Detroit',
		'America/Panama' : 'America/Detroit',
		'America/Pangnirtung' : 'America/Detroit',
		'America/Port-au-Prince' : 'America/Detroit',
		'America/Thunder_Bay' : 'America/Detroit',
		'America/Toronto' : 'America/Detroit',
		'Canada/Eastern' : 'America/Detroit',
		'Cuba' : 'America/Detroit',
		'EST' : 'America/Detroit',
		'EST5EDT' : 'America/Detroit',
		'Etc/GMT+5' : 'America/Detroit',
		'IET' : 'America/Detroit',
		'Jamaica' : 'America/Detroit',
		'SystemV/EST5' : 'America/Detroit',
		'SystemV/EST5EDT' : 'America/Detroit',
		'US/East-Indiana' : 'America/Detroit',
		'US/Eastern' : 'America/Detroit',
		'US/Michigan' : 'America/Detroit',
		/*-4:30*/
		'America/Caracas' : 'America/Caracas',
		/*-4:00*/
		'America/Anguilla' : 'America/Santiago',
		'America/Antigua' : 'America/Santiago',
		'America/Argentina/San_Luis' : 'America/Santiago',
		'America/Aruba' : 'America/Santiago',
		'America/Asuncion' : 'America/Santiago',
		'America/Barbados' : 'America/Santiago',
		'America/Blanc-Sablon' : 'America/Santiago',
		'America/Boa_Vista' : 'America/Santiago',
		'America/Campo_Grande' : 'America/Santiago',
		'America/Cuiaba' : 'America/Santiago',
		'America/Curacao' : 'America/Santiago',
		'America/Dominica' : 'America/Santiago',
		'America/Eirunepe' : 'America/Santiago',
		'America/Glace_Bay' : 'America/Santiago',
		'America/Goose_Bay' : 'America/Santiago',
		'America/Grenada' : 'America/Santiago',
		'America/Guadeloupe' : 'America/Santiago',
		'America/Guyana' : 'America/Santiago',
		'America/Halifax' : 'America/Santiago',
		'America/Kralendijk' : 'America/Santiago',
		'America/La_Paz' : 'America/Santiago',
		'America/Lower_Princes' : 'America/Santiago',
		'America/Manaus' : 'America/Santiago',
		'America/Marigot' : 'America/Santiago',
		'America/Martinique' : 'America/Santiago',
		'America/Moncton' : 'America/Santiago',
		'America/Montserrat' : 'America/Santiago',
		'America/Port_of_Spain' : 'America/Santiago',
		'America/Porto_Acre' : 'America/Santiago',
		'America/Porto_Velho' : 'America/Santiago',
		'America/Puerto_Rico' : 'America/Santiago',
		'America/Rio_Branco' : 'America/Santiago',
		'America/Santiago' : 'America/Santiago',
		'America/Santo_Domingo' : 'America/Santiago',
		'America/St_Barthelemy' : 'America/Santiago',
		'America/St_Kitts' : 'America/Santiago',
		'America/St_Lucia' : 'America/Santiago',
		'America/St_Thomas' : 'America/Santiago',
		'America/St_Vincent' : 'America/Santiago',
		'America/Thule' : 'America/Santiago',
		'America/Tortola' : 'America/Santiago',
		'America/Virgin' : 'America/Santiago',
		'Antarctica/Palmer' : 'America/Santiago',
		'Atlantic/Bermuda' : 'America/Santiago',
		'Brazil/Acre' : 'America/Santiago',
		'Brazil/West' : 'America/Santiago',
		'Canada/Atlantic' : 'America/Santiago',
		'Chile/Continental' : 'America/Santiago',
		'Etc/GMT+4' : 'America/Santiago',
		'PRT' : 'America/Santiago',
		'SystemV/AST4' : 'America/Santiago',
		'SystemV/AST4ADT' : 'America/Santiago',
		/*-3:30*/
		'America/St_Johns' : 'America/St_Johns',
		'CNT' : '',
		'Canada/Newfoundland' : '',
		/*-3:00*/
		'AGT' : 'America/Sao_Paulo',
		'America/Araguaina' : 'America/Sao_Paulo',
		'America/Argentina/Buenos_Aires' : 'America/Sao_Paulo',
		'America/Argentina/Catamarca' : 'America/Sao_Paulo',
		'America/Argentina/ComodRivadavia' : 'America/Sao_Paulo',
		'America/Argentina/Cordoba' : 'America/Sao_Paulo',
		'America/Argentina/Jujuy' : 'America/Sao_Paulo',
		'America/Argentina/La_Rioja' : 'America/Sao_Paulo',
		'America/Argentina/Mendoza' : 'America/Sao_Paulo',
		'America/Argentina/Rio_Gallegos' : 'America/Sao_Paulo',
		'America/Argentina/Salta' : 'America/Sao_Paulo',
		'America/Argentina/San_Juan' : 'America/Sao_Paulo',
		'America/Argentina/Tucuman' : 'America/Sao_Paulo',
		'America/Argentina/Ushuaia' : 'America/Sao_Paulo',
		'America/Bahia' : 'America/Sao_Paulo',
		'America/Belem' : 'America/Sao_Paulo',
		'America/Buenos_Aires' : 'America/Sao_Paulo',
		'America/Catamarca' : 'America/Sao_Paulo',
		'America/Cayenne' : 'America/Sao_Paulo',
		'America/Cordoba' : 'America/Sao_Paulo',
		'America/Fortaleza' : 'America/Sao_Paulo',
		'America/Godthab' : 'America/Sao_Paulo',
		'America/Jujuy' : 'America/Sao_Paulo',
		'America/Maceio' : 'America/Sao_Paulo',
		'America/Mendoza' : 'America/Sao_Paulo',
		'America/Miquelon' : 'America/Sao_Paulo',
		'America/Montevideo' : 'America/Sao_Paulo',
		'America/Paramaribo' : 'America/Sao_Paulo',
		'America/Recife' : 'America/Sao_Paulo',
		'America/Rosario' : 'America/Sao_Paulo',
		'America/Santarem' : 'America/Sao_Paulo',
		'America/Sao_Paulo' : 'America/Sao_Paulo',
		'Antarctica/Rothera' : 'America/Sao_Paulo',
		'Atlantic/Stanley' : 'America/Sao_Paulo',
		'BET' : 'America/Sao_Paulo',
		'Brazil/East' : 'America/Sao_Paulo',
		'Etc/GMT+3' : 'America/Sao_Paulo',
		/*-2:00*/
		'America/Noronha' : 'America/Noronha',
		'Atlantic/South_Georgia' : 'America/Noronha',
		'Brazil/DeNoronha' : 'America/Noronha',
		'Etc/GMT+2' : 'America/Noronha',
		/*-1:00*/
		'America/Scoresbysund' : 'Atlantic/Cape_Verde',
		'Atlantic/Azores' : 'Atlantic/Cape_Verde',
		'Atlantic/Cape_Verde' : 'Atlantic/Cape_Verde',
		'Etc/GMT+1' : 'Atlantic/Cape_Verde',
		/*+0:00*/
		'Africa/Abidjan' : 'Africa/Abidjan',
		'Africa/Accra' : 'Africa/Abidjan',
		'Africa/Bamako' : 'Africa/Abidjan',
		'Africa/Banjul' : 'Africa/Abidjan',
		'Africa/Bissau' : 'Africa/Abidjan',
		'Africa/Casablanca' : 'Africa/Abidjan',
		'Africa/Conakry' : 'Africa/Abidjan',
		'Africa/Dakar' : 'Africa/Abidjan',
		'Africa/El_Aaiun' : 'Africa/Abidjan',
		'Africa/Freetown' : 'Africa/Abidjan',
		'Africa/Lome' : 'Africa/Abidjan',
		'Africa/Monrovia' : 'Africa/Abidjan',
		'Africa/Nouakchott' : 'Africa/Abidjan',
		'Africa/Ouagadougou' : 'Africa/Abidjan',
		'Africa/Sao_Tome' : 'Africa/Abidjan',
		'Africa/Timbuktu' : 'Africa/Abidjan',
		'America/Danmarkshavn' : 'Africa/Abidjan',
		'Atlantic/Canary' : 'Africa/Abidjan',
		'Atlantic/Faeroe' : 'Africa/Abidjan',
		'Atlantic/Faroe' : 'Africa/Abidjan',
		'Atlantic/Madeira' : 'Africa/Abidjan',
		'Atlantic/Reykjavik' : 'Africa/Abidjan',
		'Atlantic/St_Helena' : 'Africa/Abidjan',
		'Eire' : 'Africa/Abidjan',
		'Etc/GMT' : 'Africa/Abidjan',
		'Etc/GMT+0' : 'Africa/Abidjan',
		'Etc/GMT-0' : 'Africa/Abidjan',
		'Etc/GMT0' : 'Africa/Abidjan',
		'Etc/Greenwich' : 'Africa/Abidjan',
		'Etc/UCT' : 'Africa/Abidjan',
		'Etc/UTC' : 'Africa/Abidjan',
		'Etc/Universal' : 'Africa/Abidjan',
		'Etc/Zulu' : 'Africa/Abidjan',
		'Europe/Belfast' : 'Africa/Abidjan',
		'Europe/Dublin' : 'Africa/Abidjan',
		'Europe/Guernsey' : 'Africa/Abidjan',
		'Europe/Isle_of_Man' : 'Africa/Abidjan',
		'Europe/Jersey' : 'Africa/Abidjan',
		'Europe/Lisbon' : 'Africa/Abidjan',
		'Europe/London' : 'Africa/Abidjan',
		'GB' : 'Africa/Abidjan',
		'GB-Eire' : 'Africa/Abidjan',
		'GMT' : 'Africa/Abidjan',
		'GMT0' : 'Africa/Abidjan',
		'Greenwich' : 'Africa/Abidjan',
		'Iceland' : 'Africa/Abidjan',
		'Portugal' : 'Africa/Abidjan',
		'UCT' : 'Africa/Abidjan',
		'UTC' : 'Africa/Abidjan',
		'Universal' : 'Africa/Abidjan',
		'WET' : 'Africa/Abidjan',
		'Zulu' : 'Africa/Abidjan',
		/*+1:00*/
		'Africa/Algiers' : 'Europe/Vienna',
		'Africa/Bangui' : 'Europe/Vienna',
		'Africa/Brazzaville' : 'Europe/Vienna',
		'Africa/Ceuta' : 'Europe/Vienna',
		'Africa/Douala' : 'Europe/Vienna',
		'Africa/Kinshasa' : 'Europe/Vienna',
		'Africa/Lagos' : 'Europe/Vienna',
		'Africa/Libreville' : 'Europe/Vienna',
		'Africa/Luanda' : 'Europe/Vienna',
		'Africa/Malabo' : 'Europe/Vienna',
		'Africa/Ndjamena' : 'Europe/Vienna',
		'Africa/Niamey' : 'Europe/Vienna',
		'Africa/Porto-Novo' : 'Europe/Vienna',
		'Africa/Tunis' : 'Europe/Vienna',
		'Africa/Windhoek' : 'Europe/Vienna',
		'Arctic/Longyearbyen' : 'Europe/Vienna',
		'Atlantic/Jan_Mayen' : 'Europe/Vienna',
		'CET' : 'Europe/Vienna',
		'ECT' : 'Europe/Vienna',
		'Etc/GMT-1' : 'Europe/Vienna',
		'Europe/Amsterdam' : 'Europe/Vienna',
		'Europe/Andorra' : 'Europe/Vienna',
		'Europe/Belgrade' : 'Europe/Vienna',
		'Europe/Berlin' : 'Europe/Vienna',
		'Europe/Bratislava' : 'Europe/Vienna',
		'Europe/Brussels' : 'Europe/Vienna',
		'Europe/Budapest' : 'Europe/Vienna',
		'Europe/Copenhagen' : 'Europe/Vienna',
		'Europe/Gibraltar' : 'Europe/Vienna',
		'Europe/Ljubljana' : 'Europe/Vienna',
		'Europe/Luxembourg' : 'Europe/Vienna',
		'Europe/Madrid' : 'Europe/Vienna',
		'Europe/Malta' : 'Europe/Vienna',
		'Europe/Monaco' : 'Europe/Vienna',
		'Europe/Oslo' : 'Europe/Vienna',
		'Europe/Paris' : 'Europe/Vienna',
		'Europe/Podgorica' : 'Europe/Vienna',
		'Europe/Prague' : 'Europe/Vienna',
		'Europe/Rome' : 'Europe/Vienna',
		'Europe/San_Marino' : 'Europe/Vienna',
		'Europe/Sarajevo' : 'Europe/Vienna',
		'Europe/Skopje' : 'Europe/Vienna',
		'Europe/Stockholm' : 'Europe/Vienna',
		'Europe/Tirane' : 'Europe/Vienna',
		'Europe/Vaduz' : 'Europe/Vienna',
		'Europe/Vatican' : 'Europe/Vienna',
		'Europe/Vienna' : 'Europe/Vienna',
		'Europe/Warsaw' : 'Europe/Vienna',
		'Europe/Zagreb' : 'Europe/Vienna',
		'Europe/Zurich' : 'Europe/Vienna',
		'MET' : 'Europe/Vienna',
		'Poland' : 'Europe/Vienna',
		/*+2:00*/
		'ART' : 'Asia/Jerusalem',
		'Africa/Blantyre' : 'Asia/Jerusalem',
		'Africa/Bujumbura' : 'Asia/Jerusalem',
		'Africa/Cairo' : 'Asia/Jerusalem',
		'Africa/Gaborone' : 'Asia/Jerusalem',
		'Africa/Harare' : 'Asia/Jerusalem',
		'Africa/Johannesburg' : 'Asia/Jerusalem',
		'Africa/Kigali' : 'Asia/Jerusalem',
		'Africa/Lubumbashi' : 'Asia/Jerusalem',
		'Africa/Lusaka' : 'Asia/Jerusalem',
		'Africa/Maputo' : 'Asia/Jerusalem',
		'Africa/Maseru' : 'Asia/Jerusalem',
		'Africa/Mbabane' : 'Asia/Jerusalem',
		'Africa/Tripoli' : 'Asia/Jerusalem',
		'Asia/Amman' : 'Asia/Jerusalem',
		'Asia/Beirut' : 'Asia/Jerusalem',
		'Asia/Damascus' : 'Asia/Jerusalem',
		'Asia/Gaza' : 'Asia/Jerusalem',
		'Asia/Hebron' : 'Asia/Jerusalem',
		'Asia/Istanbul' : 'Asia/Jerusalem',
		'Asia/Jerusalem' : 'Asia/Jerusalem',
		'Asia/Nicosia' : 'Asia/Jerusalem',
		'Asia/Tel_Aviv' : 'Asia/Jerusalem',
		'CAT' : 'Asia/Jerusalem',
		'EET' : 'Asia/Jerusalem',
		'Egypt' : 'Asia/Jerusalem',
		'Etc/GMT-2' : 'Asia/Jerusalem',
		'Europe/Athens' : 'Asia/Jerusalem',
		'Europe/Bucharest' : 'Asia/Jerusalem',
		'Europe/Chisinau' : 'Asia/Jerusalem',
		'Europe/Helsinki' : 'Asia/Jerusalem',
		'Europe/Istanbul' : 'Asia/Jerusalem',
		'Europe/Kiev' : 'Asia/Jerusalem',
		'Europe/Mariehamn' : 'Asia/Jerusalem',
		'Europe/Nicosia' : 'Asia/Jerusalem',
		'Europe/Riga' : 'Asia/Jerusalem',
		'Europe/Simferopol' : 'Asia/Jerusalem',
		'Europe/Sofia' : 'Asia/Jerusalem',
		'Europe/Tallinn' : 'Asia/Jerusalem',
		'Europe/Tiraspol' : 'Asia/Jerusalem',
		'Europe/Uzhgorod' : 'Asia/Jerusalem',
		'Europe/Vilnius' : 'Asia/Jerusalem',
		'Europe/Zaporozhye' : 'Asia/Jerusalem',
		'Israel' : 'Asia/Jerusalem',
		'Libya' : 'Asia/Jerusalem',
		'Turkey' : 'Asia/Jerusalem',
		/*+3:00*/
		'Africa/Addis_Ababa' : 'Africa/Addis_Ababa',
		'Africa/Asmara' : 'Africa/Addis_Ababa',
		'Africa/Asmera' : 'Africa/Addis_Ababa',
		'Africa/Dar_es_Salaam' : 'Africa/Addis_Ababa',
		'Africa/Djibouti' : 'Africa/Addis_Ababa',
		'Africa/Juba' : 'Africa/Addis_Ababa',
		'Africa/Kampala' : 'Africa/Addis_Ababa',
		'Africa/Khartoum' : 'Africa/Addis_Ababa',
		'Africa/Mogadishu' : 'Africa/Addis_Ababa',
		'Africa/Nairobi' : 'Africa/Addis_Ababa',
		'Antarctica/Syowa' : 'Africa/Addis_Ababa',
		'Asia/Aden' : 'Africa/Addis_Ababa',
		'Asia/Baghdad' : 'Africa/Addis_Ababa',
		'Asia/Bahrain' : 'Africa/Addis_Ababa',
		'Asia/Kuwait' : 'Africa/Addis_Ababa',
		'Asia/Qatar' : 'Africa/Addis_Ababa',
		'Asia/Riyadh' : 'Africa/Addis_Ababa',
		'EAT' : 'Africa/Addis_Ababa',
		'Etc/GMT-3' : 'Africa/Addis_Ababa',
		'Europe/Kaliningrad' : 'Africa/Addis_Ababa',
		'Europe/Minsk' : 'Africa/Addis_Ababa',
		'Indian/Antananarivo' : 'Africa/Addis_Ababa',
		'Indian/Comoro' : 'Africa/Addis_Ababa',
		'Indian/Mayotte' : 'Africa/Addis_Ababa',
		/*+3:30*/
		'Asia/Tehran' : 'Asia/Tehran',
		'Iran' : 'Asia/Tehran',
		/*+4:00*/
		'Asia/Baku' : 'Asia/Dubai',
		'Asia/Dubai' : 'Asia/Dubai',
		'Asia/Muscat' : 'Asia/Dubai',
		'Asia/Tbilisi' : 'Asia/Dubai',
		'Asia/Yerevan' : 'Asia/Dubai',
		'Etc/GMT-4' : 'Asia/Dubai',
		'Europe/Moscow' : 'Asia/Dubai',
		'Europe/Samara' : 'Asia/Dubai',
		'Europe/Volgograd' : 'Asia/Dubai',
		'Indian/Mahe' : 'Asia/Dubai',
		'Indian/Mauritius' : 'Asia/Dubai',
		'Indian/Reunion' : 'Asia/Dubai',
		'NET' : 'Asia/Dubai',
		'W-SU' : 'Asia/Dubai',
		/*+4:30*/
		'Asia/Kabul' : 'Asia/Kabul',
		/*+5:00*/
		'Antarctica/Mawson' : 'Antarctica/Mawson',
		'Asia/Aqtau' : 'Antarctica/Mawson',
		'Asia/Aqtobe' : 'Antarctica/Mawson',
		'Asia/Ashgabat' : 'Antarctica/Mawson',
		'Asia/Ashkhabad' : 'Antarctica/Mawson',
		'Asia/Dushanbe' : 'Antarctica/Mawson',
		'Asia/Karachi' : 'Antarctica/Mawson',
		'Asia/Oral' : 'Antarctica/Mawson',
		'Asia/Samarkand' : 'Antarctica/Mawson',
		'Asia/Tashkent' : 'Antarctica/Mawson',
		'Etc/GMT-5' : 'Antarctica/Mawson',
		'Indian/Kerguelen' : 'Antarctica/Mawson',
		'Indian/Maldives' : 'Antarctica/Mawson',
		'PLT' : 'Antarctica/Mawson',
		/*+5:30*/
		'Asia/Calcutta' : 'Asia/Colombo',
		'Asia/Colombo' : 'Asia/Colombo',
		'Asia/Kolkata' : 'Asia/Colombo',
		'IST' : 'Asia/Colombo',
		/*+6:00*/
		'Antarctica/Vostok' : 'Antarctica/Vostok',
		'Asia/Almaty' : 'Antarctica/Vostok',
		'Asia/Bishkek' : 'Antarctica/Vostok',
		'Asia/Dacca' : 'Antarctica/Vostok',
		'Asia/Dhaka' : 'Antarctica/Vostok',
		'Asia/Qyzylorda' : 'Antarctica/Vostok',
		'Asia/Thimbu' : 'Antarctica/Vostok',
		'Asia/Thimphu' : 'Antarctica/Vostok',
		'Asia/Yekaterinburg' : 'Antarctica/Vostok',
		'BST' : 'Antarctica/Vostok',
		'Etc/GMT-6' : 'Antarctica/Vostok',
		'Indian/Chagos' : 'Antarctica/Vostok',
		/*+6:30*/
		'Asia/Rangoon' : 'Asia/Rangoon',
		'Indian/Cocos' : 'Asia/Rangoon',
		/*+7:00*/
		'Antarctica/Davis' : 'Antarctica/Davis',
		'Asia/Bangkok' : 'Antarctica/Davis',
		'Asia/Ho_Chi_Minh' : 'Antarctica/Davis',
		'Asia/Hovd' : 'Antarctica/Davis',
		'Asia/Jakarta' : 'Antarctica/Davis',
		'Asia/Novokuznetsk' : 'Antarctica/Davis',
		'Asia/Novosibirsk' : 'Antarctica/Davis',
		'Asia/Omsk' : 'Antarctica/Davis',
		'Asia/Phnom_Penh' : 'Antarctica/Davis',
		'Asia/Pontianak' : 'Antarctica/Davis',
		'Asia/Saigon' : 'Antarctica/Davis',
		'Asia/Vientiane' : 'Antarctica/Davis',
		'Etc/GMT-7' : 'Antarctica/Davis',
		'Indian/Christmas' : 'Antarctica/Davis',
		'VST' : 'Antarctica/Davis',
		/*+8:00*/
		'Antarctica/Casey' : 'Antarctica/Casey',
		'Asia/Brunei' : 'Antarctica/Casey',
		'Asia/Choibalsan' : 'Antarctica/Casey',
		'Asia/Chongqing' : 'Antarctica/Casey',
		'Asia/Chungking' : 'Antarctica/Casey',
		'Asia/Harbin' : 'Antarctica/Casey',
		'Asia/Hong_Kong' : 'Antarctica/Casey',
		'Asia/Kashgar' : 'Antarctica/Casey',
		'Asia/Krasnoyarsk' : 'Antarctica/Casey',
		'Asia/Kuala_Lumpur' : 'Antarctica/Casey',
		'Asia/Kuching' : 'Antarctica/Casey',
		'Asia/Macao' : 'Antarctica/Casey',
		'Asia/Macau' : 'Antarctica/Casey',
		'Asia/Makassar' : 'Antarctica/Casey',
		'Asia/Manila' : 'Antarctica/Casey',
		'Asia/Shanghai' : 'Antarctica/Casey',
		'Asia/Singapore' : 'Antarctica/Casey',
		'Asia/Taipei' : 'Antarctica/Casey',
		'Asia/Ujung_Pandang' : 'Antarctica/Casey',
		'Asia/Ulaanbaatar' : 'Antarctica/Casey',
		'Asia/Ulan_Bator' : 'Antarctica/Casey',
		'Asia/Urumqi' : 'Antarctica/Casey',
		'Australia/Perth' : 'Antarctica/Casey',
		'Australia/West' : 'Antarctica/Casey',
		'CTT' : 'Antarctica/Casey',
		'Etc/GMT-8' : 'Antarctica/Casey',
		'Hongkong' : 'Antarctica/Casey',
		'PRC' : 'Antarctica/Casey',
		'Singapore' : 'Antarctica/Casey',
		/*+9:00*/
		'Asia/Dili' : 'Asia/Dili',
		'Asia/Irkutsk' : 'Asia/Dili',
		'Asia/Jayapura' : 'Asia/Dili',
		'Asia/Pyongyang' : 'Asia/Dili',
		'Asia/Seoul' : 'Asia/Dili',
		'Asia/Tokyo' : 'Asia/Dili',
		'Etc/GMT-9' : 'Asia/Dili',
		'JST' : 'Asia/Dili',
		'Japan' : 'Asia/Dili',
		'Pacific/Palau' : 'Asia/Dili',
		'ROK' : 'Asia/Dili',
		/*+9:30*/
		'ACT' : 'Australia/Darwin',
		'Australia/Adelaide' : 'Australia/Darwin',
		'Australia/Broken_Hill' : 'Australia/Darwin',
		'Australia/Darwin' : 'Australia/Darwin',
		'Australia/North' : 'Australia/Darwin',
		'Australia/South' : 'Australia/Darwin',
		'Australia/Yancowinna' : 'Australia/Darwin',
		/*+10:00*/
		'AET' : 'Australia/Currie',
		'Antarctica/DumontDUrville' : 'Australia/Currie',
		'Asia/Yakutsk' : 'Australia/Currie',
		'Australia/ACT' : 'Australia/Currie',
		'Australia/Brisbane' : 'Australia/Currie',
		'Australia/Canberra' : 'Australia/Currie',
		'Australia/Currie' : 'Australia/Currie',
		'Australia/Hobart' : 'Australia/Currie',
		'Australia/Lindeman' : 'Australia/Currie',
		'Australia/Melbourne' : 'Australia/Currie',
		'Australia/NSW' : 'Australia/Currie',
		'Australia/Queensland' : 'Australia/Currie',
		'Australia/Sydney' : 'Australia/Currie',
		'Australia/Tasmania' : 'Australia/Currie',
		'Australia/Victoria' : 'Australia/Currie',
		'Etc/GMT-10' : 'Australia/Currie',
		'Pacific/Chuuk' : 'Australia/Currie',
		'Pacific/Guam' : 'Australia/Currie',
		'Pacific/Port_Moresby' : 'Australia/Currie',
		'Pacific/Saipan' : 'Australia/Currie',
		'Pacific/Truk' : 'Australia/Currie',
		'Pacific/Yap' : 'Australia/Currie',
		/*+10:30*/
		'Australia/LHI' : 'Australia/Lord_Howe',
		'Australia/Lord_Howe' : 'Australia/Lord_Howe',
		/*+11:00*/
		'Antarctica/Macquarie' : 'Antarctica/Macquarie',
		'Asia/Sakhalin' : 'Antarctica/Macquarie',
		'Asia/Vladivostok' : 'Antarctica/Macquarie',
		'Etc/GMT-11' : 'Antarctica/Macquarie',
		'Pacific/Efate' : 'Antarctica/Macquarie',
		'Pacific/Guadalcanal' : 'Antarctica/Macquarie',
		'Pacific/Kosrae' : 'Antarctica/Macquarie',
		'Pacific/Noumea' : 'Antarctica/Macquarie',
		'Pacific/Pohnpei' : 'Antarctica/Macquarie',
		'Pacific/Ponape' : 'Antarctica/Macquarie',
		'SST' : 'Antarctica/Macquarie',
		/*+11:30*/
		'Pacific/Norfolk' : 'Pacific/Norfolk',
		/*+12:00*/
		'Antarctica/McMurdo' : 'Antarctica/McMurdo',
		'Antarctica/South_Pole' : 'Antarctica/McMurdo',
		'Asia/Anadyr' : 'Antarctica/McMurdo',
		'Asia/Kamchatka' : 'Antarctica/McMurdo',
		'Asia/Magadan' : 'Antarctica/McMurdo',
		'Etc/GMT-12' : 'Antarctica/McMurdo',
		'Kwajalein' : 'Antarctica/McMurdo',
		'NST' : 'Antarctica/McMurdo',
		'NZ' : 'Antarctica/McMurdo',
		'Pacific/Auckland' : 'Antarctica/McMurdo',
		'Pacific/Fiji' : 'Antarctica/McMurdo',
		'Pacific/Funafuti' : 'Antarctica/McMurdo',
		'Pacific/Kwajalein' : 'Antarctica/McMurdo',
		'Pacific/Majuro' : 'Antarctica/McMurdo',
		'Pacific/Nauru' : 'Antarctica/McMurdo',
		'Pacific/Tarawa' : 'Antarctica/McMurdo',
		'Pacific/Wake' : 'Antarctica/McMurdo',
		'Pacific/Wallis' : 'Antarctica/McMurdo',
		/*+13:00*/
		'Etc/GMT-13' : 'Pacific/Enderbury',
		'MIT' : 'Pacific/Enderbury',
		'Pacific/Apia' : 'Pacific/Enderbury',
		'Pacific/Enderbury' : 'Pacific/Enderbury',
		'Pacific/Tongatapu' : 'Pacific/Enderbury',
		/*+14:00*/
		'Etc/GMT-14' : 'Pacific/Kiritimati',
		'Pacific/Fakaofo' : 'Pacific/Kiritimati',
		'Pacific/Kiritimati' : 'Pacific/Kiritimati'
	},
	
	/* return unmapped timezone... */
	unMap: function(timezone) {
		return this.map[timezone] !== undefined ? this.map[timezone] : timezone;
	},
	
	getOffset: function(timezone) {
		/* find timezone, this needs to be optimized ;) */
		timezone = this.unMap(timezone);
		var i = 0;
		for(i = 0; i < this.store.length; i++) {
			if(this.store[i][0] == timezone) {
				return (this.store[i][2] * 60000);
			}
		}
	
		return 0;	// no offset found...
	}
});

Zarafa.plugins.calendarimporter.data.Timezones = new Zarafa.plugins.calendarimporter.data.Timezones();/**
 * plugin.calendarimporter.js zarafa calender to ics im/exporter
 *
 * Author: Christoph Haas <christoph.h@sprinternet.at>
 * Copyright (C) 2012-2013 Christoph Haas
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
Ext.namespace("Zarafa.plugins.calendarimporter");									// Assign the right namespace

Zarafa.plugins.calendarimporter.ImportPlugin = Ext.extend(Zarafa.core.Plugin, {		// create new import plugin

    /**
     * @constructor
     * @param {Object} config Configuration object
     *
     */
	constructor: function (config) {
		config = config || {};
		
		 Ext.applyIf(config, {
			name : 'calendarimporter',
			displayName : _('Calendarimporter Plugin'),
			about : Zarafa.plugins.calendarimporter.ABOUT
		});
				
		Zarafa.plugins.calendarimporter.ImportPlugin.superclass.constructor.call(this, config);
	},
	
	/**
	 * initialises insertion point for plugin
	 * @protected
	 */
	initPlugin : function()	{
		Zarafa.plugins.calendarimporter.ImportPlugin.superclass.initPlugin.apply(this, arguments);
		
		/* our panel */
		Zarafa.core.data.SharedComponentType.addProperty('plugins.calendarimporter.dialogs.importevents');
		
		/* directly import received icals */
		this.registerInsertionPoint('common.contextmenu.attachment.actions', this.createAttachmentImportButton);
		/* add import button to south navigation */
		this.registerInsertionPoint("navigation.south", this.createImportButton, this);
	},
	
    /**
     * Creates the button
     *
     * @return {Object} Configuration object for a {@link Ext.Button button}
     * 
     */
	createImportButton: function () {
		var button = {
			xtype				: 'button',
			ref		  			: "importbutton",
			id		  			: "importbutton",
			text				: _('Import Calendar'),
			iconCls				: 'icon_calendarimporter_button',
			navigationContext	: container.getContextByName('calendar'),
			handler				: this.onImportButtonClick,
			scope				: this
		};
		
		if(container.getSettingsModel().get("zarafa/v1/plugins/calendarimporter/enable_export")) {
			button.text = _('Import/Export Calendar');
		}
		
		return  button;
	},
	
	/**
	 * Insert import button in all attachment suggestions
	 
	 * @return {Object} Configuration object for a {@link Ext.Button button}
	 */
	createAttachmentImportButton : function(include, btn) {
		return {
			text 		: _('Import Calendar'),
			handler 	: this.getAttachmentFileName.createDelegate(this, [btn, this.gotAttachmentFileName]),
			scope		: this,
			iconCls		: 'icon_calendarimporter_button',
			beforeShow 	: function(item, record) {
				var extension = record.data.name.split('.').pop().toLowerCase();
				
				if(record.data.filetype  == "text/calendar" || extension == "ics" || extension == "ifb" || extension == "ical" || extension == "ifbf") {
					item.setDisabled(false);
				} else {
					item.setDisabled(true);
				}
			}
		};
	},
	
	/**
	 * Callback for getAttachmentFileName
	 */
	gotAttachmentFileName: function(response) {
		if(response.status == true) {
			Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType['plugins.calendarimporter.dialogs.importevents'], undefined, {
				manager : Ext.WindowMgr,
				filename : response.tmpname
			});
		} else {
			Zarafa.common.dialogs.MessageBox.show({
				title   : _('Error'),
				msg     : _(response["message"]),
				icon    : Zarafa.common.dialogs.MessageBox.ERROR,
				buttons : Zarafa.common.dialogs.MessageBox.OK
			});
		}
	},

	/**
	 * Clickhandler for the button
	 */
	getAttachmentFileName: function (btn, callback) {
		Zarafa.common.dialogs.MessageBox.show({
			title: 'Please wait',
			msg: 'Loading attachment...',
			progressText: 'Initializing...',
			width:300,
			progress:true,
			closable:false
		});

		// progress bar... ;)
		var f = function(v){
			return function(){
				if(v == 100){
					Zarafa.common.dialogs.MessageBox.hide();
				}else{
					Zarafa.common.dialogs.MessageBox.updateProgress(v/100, Math.round(v)+'% loaded');
				}
		   };
		};
		
		for(var i = 1; i < 101; i++){
			setTimeout(f(i), 20*i);
		}
		
		/* store the attachment to a temporary folder and prepare it for uploading */
		var attachmentRecord = btn.records;
		var attachmentStore = attachmentRecord.store;
		
		var store = attachmentStore.getParentRecord().get('store_entryid');
		var entryid = attachmentStore.getAttachmentParentRecordEntryId();
		var attachNum = new Array(1);
		if (attachmentRecord.get('attach_num') != -1)
			attachNum[0] = attachmentRecord.get('attach_num');
		else
			attachNum[0] = attachmentRecord.get('tmpname');
		var dialog_attachments = attachmentStore.getId();
		var filename = attachmentRecord.data.name;
		
		var responseHandler = new Zarafa.plugins.calendarimporter.data.ResponseHandler({
			successCallback: callback
		});
		
		// request attachment preperation
		container.getRequest().singleRequest(
			'calendarmodule',
			'attachmentpath',
			{
				entryid : entryid,
				store: store,
				attachNum: attachNum,
				dialog_attachments: dialog_attachments,
				filename: filename
			},
			responseHandler
		);
	},
	
	/**
	 * Clickhandler for the button
	 */
	onImportButtonClick: function () {
		Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType['plugins.calendarimporter.dialogs.importevents'], undefined, {
			manager : Ext.WindowMgr
		});
	},
		
	/**
	 * Bid for the type of shared component
	 * and the given record.
	 * This will bid on calendar.dialogs.importevents
	 * @param {Zarafa.core.data.SharedComponentType} type Type of component a context can bid for.
	 * @param {Ext.data.Record} record Optionally passed record.
	 * @return {Number} The bid for the shared component
	 */
	bidSharedComponent : function(type, record) {
		var bid = -1;
		switch(type) {
			case Zarafa.core.data.SharedComponentType['plugins.calendarimporter.dialogs.importevents']:
				bid = 2;
				break;
		}
		return bid;
	},

	/**
	 * Will return the reference to the shared component.
	 * Based on the type of component requested a component is returned.
	 * @param {Zarafa.core.data.SharedComponentType} type Type of component a context can bid for.
	 * @param {Ext.data.Record} record Optionally passed record.
	 * @return {Ext.Component} Component
	 */
	getSharedComponent : function(type, record) {
		var component;
		switch(type) {
			case Zarafa.core.data.SharedComponentType['plugins.calendarimporter.dialogs.importevents']:
				component = Zarafa.plugins.calendarimporter.dialogs.ImportContentPanel;
				break;
		}

		return component;
	}
});


/*############################################################################################################################
 * STARTUP 
 *############################################################################################################################*/
Zarafa.onReady(function() {
	if(container.getSettingsModel().get("zarafa/v1/plugins/calendarimporter/enable") === true) {
		container.registerPlugin(new Zarafa.plugins.calendarimporter.ImportPlugin);
	}
});
/**
 * ResponseHandler.js zarafa calender to ics im/exporter
 *
 * Author: Christoph Haas <christoph.h@sprinternet.at>
 * Copyright (C) 2012-2013 Christoph Haas
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
/**
 * ResponseHandler
 *
 * This class handles all responses from the php backend
 */
Ext.namespace('Zarafa.plugins.calendarimporter.data');

/**
 * @class Zarafa.plugins.calendarimporter.data.ResponseHandler
 * @extends Zarafa.plugins.calendarimporter.data.AbstractResponseHandler
 *
 * Calendar specific response handler.
 */
Zarafa.plugins.calendarimporter.data.ResponseHandler = Ext.extend(Zarafa.core.data.AbstractResponseHandler, {
	/**
	 * @cfg {Function} successCallback The function which
	 * will be called after success request.
	 */
	successCallback : null,
	
	/**
	 * Call the successCallback callback function.
	 * @param {Object} response Object contained the response data.
	 */
	doExport : function(response) {
		this.successCallback(response);
	},
	
	/**
	 * Call the successCallback callback function.
	 * @param {Object} response Object contained the response data.
	 */
	doList : function(response) {
		this.successCallback(response);
	},
	
	/**
	 * Call the successCallback callback function.
	 * @param {Object} response Object contained the response data.
	 */
	doImport : function(response) {
		this.successCallback(response);
	},
	
	/**
	 * Call the successCallback callback function.
	 * @param {Object} response Object contained the response data.
	 */
	doAttachmentpath : function(response) {
		this.successCallback(response);
	},
	
	/**
	 * In case exception happened on server, server will return
	 * exception response with the code of exception.
	 * @param {Object} response Object contained the response data.
	 */
	doError: function(response)	{
		alert("error response code: " + response.error.info.code);
	}
});

Ext.reg('calendarimporter.calendarresponsehandler', Zarafa.plugins.calendarimporter.data.ResponseHandler);/**
 * ImportContentPanel.js zarafa calender to ics im/exporter
 *
 * Author: Christoph Haas <christoph.h@sprinternet.at>
 * Copyright (C) 2012-2013 Christoph Haas
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
/**
 * ImportContentPanel
 *
 * Container for the importpanel.
 */
Ext.namespace("Zarafa.plugins.calendarimporter.dialogs"); 

/**
 * @class Zarafa.plugins.calendarimporter.dialogs.ImportContentPanel
 * @extends Zarafa.core.ui.ContentPanel
 *
 * The content panel which shows the hierarchy tree of Owncloud account files.
 * @xtype calendarimportercontentpanel
 */
Zarafa.plugins.calendarimporter.dialogs.ImportContentPanel = Ext.extend(Zarafa.core.ui.ContentPanel, {

	/**
	 * @constructor
	 * @param config Configuration structure
	 */
	constructor : function(config) {
		config = config || {};
		var title = _('Import Calendar File');
		if(container.getSettingsModel().get("zarafa/v1/plugins/calendarimporter/enable_export")){
			title = _('Import/Export Calendar File');
		}
		Ext.applyIf(config, {
			layout		: 'fit',
			title		: title,
			closeOnSave	: true,
			width		: 620,
			height		: 465,
			//Add panel
			items : [
				{
					xtype	 : 'calendarimporter.importpanel',
					filename : config.filename 
				}
			]
		});

		Zarafa.plugins.calendarimporter.dialogs.ImportContentPanel.superclass.constructor.call(this, config);
	}

});

Ext.reg('calendarimporter.contentpanel' ,Zarafa.plugins.calendarimporter.dialogs.ImportContentPanel);/**
 * ImportPanel.js zarafa calender to ics im/exporter
 *
 * Author: Christoph Haas <christoph.h@sprinternet.at>
 * Copyright (C) 2012-2013 Christoph Haas
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *	
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/**
 * ImportPanel
 *
 * The main Panel of the calendarimporter plugin.
 */
Ext.namespace("Zarafa.plugins.calendarimporter.dialogs"); 

/**
 * @class Zarafa.plugins.calendarimporter.dialogs.ImportPanel
 * @extends Ext.form.FormPanel
 */
Zarafa.plugins.calendarimporter.dialogs.ImportPanel = Ext.extend(Ext.Panel, {

	/* store the imported timezone here... */
	timezone: null,
	
	/* ignore daylight saving time... */
	ignoredst: null,
	
	/* path to ics file on server... */
	icsfile: null,
	
	/* loadmask for timezone/dst changes... */
	loadMask: null,
	
	/* export event buffer */
	exportResponse: new Array(),
	
	/* how many requests are still running? */
	runningRequests: null,
	
	/* The store for the selection grid */
	store: null,
	
	/**
	 * The internal 'iframe' which is hidden from the user, which is used for downloading
	 * attachments. See {@link #doOpen}.
	 * @property
	 * @type Ext.Element
	 */
	downloadFrame : undefined,

	/**
	 * @constructor
	 * @param {object} config
	 */
	constructor : function (config) {
		config = config || {};
		var self = this;
		this.timezone = container.getSettingsModel().get("zarafa/v1/plugins/calendarimporter/default_timezone");
		
		if(typeof config.filename !== "undefined") {
			this.icsfile = config.filename;
		}
		
		// create the data store
		this.store = new Ext.data.ArrayStore({
			fields: [
				{name: 'title'},
				{name: 'start'},
				{name: 'end'},
				{name: 'location'},
				{name: 'description'},
				{name: 'priority'},
				{name: 'label'},
				{name: 'busy'},
				{name: 'privatestate'},
				{name: 'organizer'},
				{name: 'trigger'}
			]
		});
		
		Ext.apply(config, {
			xtype     : 'calendarimporter.importpanel',
			ref		  : "importpanel",
			id		  : "importpanel",
			layout    : {
				type  : 'form',
				align : 'stretch'
			},
			anchor	  : '100%',
			bodyStyle : 'background-color: inherit;',
			defaults  : {
				border      : true,
				bodyStyle   : 'background-color: inherit; padding: 3px 0px 3px 0px; border-style: none none solid none;'
			},
			items : [
				this.createSelectBox(),
				this.createTimezoneBox(),
				this.createDaylightSavingCheckBox(),
				this.initForm(),
				this.createGrid()
			],
			buttons: [
				this.createExportAllButton(),
				this.createSubmitAllButton(),
				this.createSubmitButton(),
				this.createCancelButton()
			], 
			listeners: {
				afterrender: function (cmp) {
					Ext.getCmp('importbutton').disable();
					this.loadMask = new Ext.LoadMask(Ext.getCmp("importpanel").getEl(), {msg:'Loading...'});
					
					if(this.icsfile != null) { // if we have got the filename from an attachment
						this.parseCalendar(this.icsfile, this.timezone, this.ignoredst);
					}
				},
				close: function (cmp) {
					Ext.getCmp('importbutton').enable();
				},
				hide: function (cmp) {
					Ext.getCmp('importbutton').enable();
				},
				destroy: function (cmp) {
					Ext.getCmp('importbutton').enable();
				}
			}
		});
		
		Zarafa.plugins.calendarimporter.dialogs.ImportPanel.superclass.constructor.call(this, config);
	},

	/**
	 * Init embedded form, this is the form that is
	 * posted and contains the attachments
	 * @private
	 */
	initForm : function () {
		return {
			xtype: 'form',
			ref: 'addFormPanel',
			layout : 'column',
			fileUpload: true,
			autoWidth: true,
			autoHeight: true,
			border: false,
			bodyStyle: 'padding: 5px;',
			defaults: {
				anchor: '95%',
				border: false,
				bodyStyle: 'padding: 5px;'
			},
			items: [this.createUploadField()]
		};
	},

	/**
	 * Reloads the data of the grid
	 * @private
	 */
	reloadGridStore: function(eventdata) {
		var parsedData = [];
		
		// this is done to get rid of the local browser timezone....
		// because all timezone specific stuff is done via php
		var local_tz_offset = new Date().getTimezoneOffset() * 60000;  // getTimezoneOffset returns minutes... we need milliseconds
		
		
		if(eventdata !== null) {
			parsedData = new Array(eventdata.events.length);
			var i = 0;
			for(i = 0; i < eventdata.events.length; i++) {
				var trigger = null;
				
				if(eventdata.events[i]["VALARM"]) {
					trigger = eventdata.events[i]["VALARM"]["TRIGGER"];
					trigger = new Date(parseInt(trigger) + local_tz_offset);
				}
				parsedData[i] = new Array(eventdata.events[i]["SUMMARY"], new Date(parseInt(eventdata.events[i]["DTSTART"]) + local_tz_offset), new Date(parseInt(eventdata.events[i]["DTEND"]) + local_tz_offset), eventdata.events[i]["LOCATION"], eventdata.events[i]["DESCRIPTION"],eventdata.events[i]["PRIORITY"],eventdata.events[i]["X-ZARAFA-LABEL"],eventdata.events[i]["X-MICROSOFT-CDO-BUSYSTATUS"],eventdata.events[i]["CLASS"],eventdata.events[i]["ORGANIZER"],trigger);
			}
		} else {
			return null;
		}

		this.store.loadData(parsedData, false);
	},
	
	/**
	 * Init embedded form, this is the form that is
	 * posted and contains the attachments
	 * @private
	 */
	createGrid : function() {
		return {
			xtype: 'grid',
			ref: 'eventgrid',
			id: 'eventgrid',
			columnWidth: 1.0,
			store: this.store,
			width: '100%',
			height: 300,
			title: 'Select events to import',
			frame: false,
			viewConfig:{
				forceFit:true
			},
			colModel: new Ext.grid.ColumnModel({
				defaults: {
					width: 300,
					sortable: true
				},
				columns: [
					{id: 'Summary', header: 'Title', width: 200, sortable: true, dataIndex: 'title'},
					{header: 'Start', width: 200, sortable: true, dataIndex: 'start', renderer : Zarafa.common.ui.grid.Renderers.datetime},
					{header: 'End', width: 200, sortable: true, dataIndex: 'end', renderer : Zarafa.common.ui.grid.Renderers.datetime},
					{header: 'Location', width: 150, sortable: true, dataIndex: 'location'},
					{header: 'Description', sortable: true, dataIndex: 'description'},
					{header: "Priority", dataIndex: 'priority', hidden: true},
					{header: "Label", dataIndex: 'label', hidden: true},
					{header: "Busystatus", dataIndex: 'busy', hidden: true},
					{header: "Privacystatus", dataIndex: 'privatestate', hidden: true},
					{header: "Organizer", dataIndex: 'organizer', hidden: true},
					{header: "Alarm", dataIndex: 'trigger', hidden: true, renderer : Zarafa.common.ui.grid.Renderers.datetime}
				]
			}),
			sm: new Ext.grid.RowSelectionModel({multiSelect:true})
		}
	},
	
	createSelectBox: function() {
		var defaultFolder = container.getHierarchyStore().getDefaultFolder('calendar'); // @type: Zarafa.hierarchy.data.MAPIFolderRecord		
		var subFolders = defaultFolder.getChildren();
		var myStore = [];
		
		/* add all local calendar folders */
		var i = 0;
		myStore.push(new Array(defaultFolder.getDefaultFolderKey(), defaultFolder.getDisplayName()));
		for(i = 0; i < subFolders.length; i++) {
			/* Store all subfolders */
			myStore.push(new Array(subFolders[i].getDisplayName(), subFolders[i].getDisplayName(), false)); // 3rd field = isPublicfolder
		}
		
		/* add all shared calendar folders */
		var pubStore = container.getHierarchyStore().getPublicStore();
		
		if(typeof pubStore !== "undefined") {
			try {
				var pubFolder = pubStore.getDefaultFolder("publicfolders");
				var pubSubFolders = pubFolder.getChildren();
				
				for(i = 0; i < pubSubFolders.length; i++) {
					if(pubSubFolders[i].isContainerClass("IPF.Appointment")){
						myStore.push(new Array(pubSubFolders[i].getDisplayName(), pubSubFolders[i].getDisplayName() + " [Shared]", true)); // 3rd field = isPublicfolder
					}
				}
			} catch (e) {
				console.log("Error opening the shared folder...");
				console.log(e);
			}
		}
		
		return {
			xtype: "selectbox",
			ref: 'calendarselector',
			id: 'calendarselector',  
			editable: false,
			name: "choosen_calendar",
			value: container.getSettingsModel().get("zarafa/v1/plugins/calendarimporter/default_calendar"),
			width: 100,
			fieldLabel: "Select a calender",
			store: myStore,
			mode: 'local',
			labelSeperator: ":",
			border: false,
			anchor: "100%",
			scope: this,
			allowBlank: false
		}
	},
	
	createTimezoneBox: function() {
		return {
			xtype: "selectbox",
			ref: 'timezoneselector',
			id: 'timezoneselector',  
			editable: false,
			name: "choosen_timezone",
			value: Zarafa.plugins.calendarimporter.data.Timezones.unMap(container.getSettingsModel().get("zarafa/v1/plugins/calendarimporter/default_timezone")),
			width: 100,
			fieldLabel: "Select a timezone (optional)",
			store: Zarafa.plugins.calendarimporter.data.Timezones.store,
			labelSeperator: ":",
			mode: 'local',
			border: false,
			anchor: "100%",
			scope: this,
			allowBlank: true,
			listeners: {
				'select': this.onTimezoneSelected,
				scope: this
			}
		}
	},
	
	createDaylightSavingCheckBox: function() {
		return {
			xtype: "checkbox",
			ref: 'dstcheck',
			id: 'dstcheck',
			name: "dst_check",
			width: 100,
			fieldLabel: "Ignore DST (optional)",
			boxLabel: 'This will ignore "Daylight saving time" offsets.',
			labelSeperator: ":",
			border: false,
			anchor: "100%",
			scope: this,
			allowBlank: true,
			listeners: {
				'check': this.onDstChecked,
				scope: this
			}
		}
	},
	
	createUploadField: function() {
		return {
			xtype: "fileuploadfield",
			ref: 'fileuploadfield',
			columnWidth: 1.0,
			id: 'form-file',    
			name: 'icsdata',
			emptyText: 'Select an .ics calendar',
			border: false,
			anchor: "100%",
			scope: this,
			allowBlank: false,
			listeners: {
				'fileselected': this.onFileSelected,
				scope: this
			}
		}
	},
	
	createSubmitButton: function() {
		return {
			xtype: "button",
			ref: "submitButton",
			id: "submitButton",
			disabled: true,
			width: 100,
			border: false,
			text: _("Import"),
			anchor: "100%",
			handler: this.importCheckedEvents,
			scope: this,
			allowBlank: false
		}
	},
	
	createSubmitAllButton: function() {
		return {
			xtype: "button",
			ref: "submitAllButton",
			id: "submitAllButton",
			disabled: true,
			width: 100,
			border: false,
			text: _("Import All"),
			anchor: "100%",
			handler: this.importAllEvents,
			scope: this,
			allowBlank: false
		}
	},
	
	createExportAllButton: function() {
		return {
			xtype: "button",
			ref: "exportAllButton",
			id: "exportAllButton",
			hidden: !container.getSettingsModel().get("zarafa/v1/plugins/calendarimporter/enable_export"),
			width: 100,
			border: false,
			text: _("Export All"),
			anchor: "100%",
			handler: this.exportAllEvents,
			scope: this,
			allowBlank: false
		}
	},
	
	createCancelButton: function() {
		return {
			xtype: "button",
			width: 100,
			border: false,
			text: _("Cancel"),
			anchor: "100%",
			handler: this.close,
			scope: this,
			allowBlank: false
		}
	},
	
	/**
	 * This is called when a timezone has been seleceted in the timezone dialog
	 * @param {Ext.form.ComboBox} combo
	 * @param {Ext.data.Record} record
	 * @param {Number} index
	 */
	onTimezoneSelected : function(combo, record, index) {
		this.timezone = record.data.field1;
		
		if(this.icsfile != null) {
			this.parseCalendar(this.icsfile, this.timezone, this.ignoredst);
		}
	},
	
	/**
	 * This is called when the dst checkbox has been selected
	 * @param {Ext.form.CheckBox} combo
	 * @param {boolean} checked
	 */
	onDstChecked : function(checkbox, checked) {
		this.ignoredst = checked;
		
		if(this.icsfile != null) {
			this.parseCalendar(this.icsfile, this.timezone, this.ignoredst);
		}
	},
	
	/**
	 * This is called when a file has been seleceted in the file dialog
	 * in the {@link Ext.ux.form.FileUploadField} and the dialog is closed
	 * @param {Ext.ux.form.FileUploadField} uploadField being added a file to
	 */
	onFileSelected : function(uploadField) {
		var form = this.addFormPanel.getForm();

		if (form.isValid()) {
			form.submit({
				waitMsg: 'Uploading and parsing calendar...',
				url: 'plugins/calendarimporter/php/upload.php',
				failure: function(file, action) {
					Ext.getCmp('submitButton').disable();
					Ext.getCmp('submitAllButton').disable();
					Zarafa.common.dialogs.MessageBox.show({
						title   : _('Error'),
						msg     : _(action.result.error),
						icon    : Zarafa.common.dialogs.MessageBox.ERROR,
						buttons : Zarafa.common.dialogs.MessageBox.OK
					});
				},
				success: function(file, action){
					uploadField.reset();
					this.icsfile = action.result.ics_file;
					
					this.parseCalendar(this.icsfile, this.timezone, this.ignoredst);
				},
				scope : this
			});
		}
	},
	
	parseCalendar: function (icsPath, timezone, ignoredst) {
		this.loadMask.show();
		// call export function here!
		var responseHandler = new Zarafa.plugins.calendarimporter.data.ResponseHandler({
			successCallback: this.handleParsingResult.createDelegate(this)
		});
		
		container.getRequest().singleRequest(
			'calendarmodule',
			'import',
			{
				ics_filepath: icsPath,
				timezone: timezone,
				ignore_dst: ignoredst
			},
			responseHandler
		);
	},
	
	handleParsingResult: function(response) {
		this.loadMask.hide();
		
		if(response["status"] == true) {
			Ext.getCmp('submitButton').enable();
			Ext.getCmp('submitAllButton').enable();
		
			if(typeof response.parsed.calendar["X-WR-TIMEZONE"] !== "undefined") {;
				this.timezone = response.parsed.calendar["X-WR-TIMEZONE"];
				this.timezoneselector.setValue(Zarafa.plugins.calendarimporter.data.Timezones.unMap(this.timezone));
			}
			this.reloadGridStore(response.parsed);
		} else {
			Ext.getCmp('submitButton').disable();
			Ext.getCmp('submitAllButton').disable();
			Zarafa.common.dialogs.MessageBox.show({
				title   : _('Parser Error'),
				msg     : _(response["message"]),
				icon    : Zarafa.common.dialogs.MessageBox.ERROR,
				buttons : Zarafa.common.dialogs.MessageBox.OK
			});
		}
	},

	close: function () {
		this.addFormPanel.getForm().reset();
		this.dialog.close()
	},

	convertToAppointmentRecord: function (calendarFolder,entry) {
		var newRecord = Zarafa.core.data.RecordFactory.createRecordObjectByMessageClass('IPM.Appointment', {
			startdate: new Date(entry.start),
			duedate: (entry.end != null) ?
				new Date(entry.end) :
				new Date(entry.start).add(Date.HOUR, 1),
			location: entry.location,
			subject: entry.title,
			body: entry.description,
			commonstart: new Date(entry.start),
			commonend: (entry.end != null) ?
				new Date(entry.end) :
				new Date(entry.start).add(Date.HOUR, 1),
			timezone: this.timezone,
			parent_entryid: calendarFolder.get('entryid'),
			store_entryid: calendarFolder.get('store_entryid')
		});
		
		var busystate = new Array("FREE", "TENTATIVE", "BUSY", "OOF");
		var zlabel = new Array("NONE", "IMPORTANT", "WORK", "PERSONAL", "HOLIDAY", "REQUIRED", "TRAVEL REQUIRED", "PREPARATION REQUIERED", "BIRTHDAY", "SPECIAL DATE", "PHONE INTERVIEW");
		
		/* optional fields */
		if(entry.priority !== "") {
			newRecord.data.importance = entry.priority;
		}
		if(entry.label !== "") {
			newRecord.data.label = zlabel.indexOf(entry.label);
		}
		if(entry.busy !== "") {
			newRecord.data.busystatus = busystate.indexOf(entry.busy);
		}
		if(entry.privatestate !== "") {
			newRecord.data["private"] = entry.privatestate == "PUBLIC" ? false : true;
		}
		if(entry.organizer !== "") {
			newRecord.data.sent_representing_email_address = entry.organizer;
		}
		if(entry.trigger != null) {
			newRecord.data.reminder = true;
			newRecord.data.reminder_minutes = new Date((entry.start - entry.trigger)/60);
			newRecord.data.reminder_time = new Date(entry.trigger);
		} else {
			newRecord.data.reminder = false;
		}
		
		return newRecord;
	},
	
	importCheckedEvents: function () {
		var newRecords = this.eventgrid.selModel.getSelections();
		this.importEvents(newRecords);
    },

	importAllEvents: function () {
		//receive Records from grid rows
		this.eventgrid.selModel.selectAll();  // select all entries
		var newRecords = this.eventgrid.selModel.getSelections();
		this.importEvents(newRecords);
    },
	
	exportAllEvents: function () {
		//receive existing calendar store
		var calValue = this.calendarselector.value;
		
		if(calValue == undefined) { // no calendar choosen
			Zarafa.common.dialogs.MessageBox.show({
				title   : _('Error'),
				msg     : _('You have to choose a calendar!'),
				icon    : Zarafa.common.dialogs.MessageBox.ERROR,
				buttons : Zarafa.common.dialogs.MessageBox.OK
			});
		} else {
			var calexist = true;
			var calendarFolder =  container.getHierarchyStore().getDefaultFolder('calendar');
			var pubStore = container.getHierarchyStore().getPublicStore();
			var pubSubFolders = [];
			if(typeof pubStore !== "undefined") {
				try {
					var pubFolder = pubStore.getDefaultFolder("publicfolders");
					var pubSubFolders = pubFolder.getChildren();
				} catch (e) {
					console.log("Error opening the shared folder...");
					console.log(e);
				}
			}
			
			if(calValue != "calendar") {
				var subFolders = calendarFolder.getChildren();
				var i = 0;
				
				/* add public folders if any exist */
				for(i = 0; i < pubSubFolders.length; i++) {		
					if(pubSubFolders[i].isContainerClass("IPF.Appointment")){
						subFolders.push(pubSubFolders[i]);
					}
				}
				
				for(i=0;i<subFolders.length;i++) {
					// loo up right folder 
					// TODO: improve!!
					if(subFolders[i].getDisplayName() == calValue) {
						calendarFolder = subFolders[i];
						break;
					}
				}
				
				if(calendarFolder.isDefaultFolder()) {
					Zarafa.common.dialogs.MessageBox.show({
						title   : _('Error'),
						msg     : _('Selected calendar does not exist!'),
						icon    : Zarafa.common.dialogs.MessageBox.ERROR,
						buttons : Zarafa.common.dialogs.MessageBox.OK
					});
					calexist = false;
				}
			}
			
			if(calexist) {
				Zarafa.common.dialogs.MessageBox.show({
					title: 'Please wait',
					msg: 'Generating ical file...',
					progressText: 'Exporting...',
					width:300,
					progress:true,
					closable:false
				});
				
				// progress bar... ;)
				var updateProgressBar = function(v){
					return function(){
						if(v == 100){
							if(Zarafa.common.dialogs.MessageBox.isVisible()) {
								updateTimer();
							}
						}else{
							Zarafa.common.dialogs.MessageBox.updateProgress(v/100, 'Exporting...');
						}
				   };
				};
				
				var updateTimer = function() {
					for(var i = 1; i < 101; i++){
						setTimeout(updateProgressBar(i), 20*i);
					}
				};
				
				updateTimer();
			
				// call export function here!
				var responseHandler = new Zarafa.plugins.calendarimporter.data.ResponseHandler({
					successCallback: this.exportPagedEvents.createDelegate(this)
				});
				
				container.getRequest().singleRequest(
					'appointmentlistmodule',
					'list',
					{
						groupDir: "ASC",
						restriction: {
							//start: 0,
							//limit: 500,	// limit to 500 events.... not working because of hardcoded limit in listmodule
							//startdate: 0,
							//duedate: 2145826800	// 2037... nearly highest unix timestamp
						},
						sort: [{
								"field": "startdate",
								"direction": "DESC"
						}],
						store_entryid : calendarFolder.data.store_entryid,
						entryid : calendarFolder.data.entryid
					},
					responseHandler
				);
			}
		}
    },
	
	/**
	 * Calculate needed Requests for all events
	 * Needed because the listmodule has hardcoded pageing setting -.-
	 * @param {Object} response
	 */
	exportPagedEvents:function(response) {
	
		if(response.page.start = 0 && response.item.length <= 0) {
			container.getNotifier().notify('info', 'Export Failed', 'There were no items to export!');
			Zarafa.common.dialogs.MessageBox.hide();
		} else {
			this.exportResponse = response.item;
		}
		
		if(this.totalExportCount == null) {
			this.totalExportCount = response.page.totalrowcount;
		}
		
		var requests = Math.ceil(response.page.totalrowcount / response.page.rowcount);
		this.runningRequests = requests;
		
		var i = 0;
		
		//receive existing calendar store
		var calValue = this.calendarselector.value;		
		var calendarFolder =  container.getHierarchyStore().getDefaultFolder('calendar');
		var pubStore = container.getHierarchyStore().getPublicStore();
		var pubSubFolders = [];
		if(typeof pubStore !== "undefined") {
			try {
				var pubFolder = pubStore.getDefaultFolder("publicfolders");
				var pubSubFolders = pubFolder.getChildren();
			} catch (e) {
				console.log("Error opening the shared folder...");
				console.log(e);
			}
		}
		
		if(calValue != "calendar") {
			var subFolders = calendarFolder.getChildren();
			var i = 0;
			
			/* add public folders if any exist */
			for(i = 0; i < pubSubFolders.length; i++) {		
				if(pubSubFolders[i].isContainerClass("IPF.Appointment")){
					subFolders.push(pubSubFolders[i]);
				}
			}
			
			for(i=0;i<subFolders.length;i++) {
				// loo up right folder 
				// TODO: improve!!
				if(subFolders[i].getDisplayName() == calValue) {
					calendarFolder = subFolders[i];
					break;
				}
			}
			
			if(calendarFolder.isDefaultFolder()) {
				Zarafa.common.dialogs.MessageBox.show({
					title   : _('Error'),
					msg     : _('Selected calendar does not exist!'),
					icon    : Zarafa.common.dialogs.MessageBox.ERROR,
					buttons : Zarafa.common.dialogs.MessageBox.OK
				});
			}
		}
		
		for(i = 0; i < requests; i++) {
			var responseHandler = new Zarafa.plugins.calendarimporter.data.ResponseHandler({
				successCallback: this.storeResult.createDelegate(this)
			});
			this.requestNext(calendarFolder, responseHandler, response.page.rowcount *(i+1), response.page.rowcount);
		}
	},

	/**
	 * Responsehandler for the single requests... will merge all events into one array
	 * @param {Object} response
	 */
	storeResult: function(response) {
			var tmp = this.exportResponse;
			
			this.exportResponse = tmp.concat(response.item);
			
			if(this.runningRequests <= 1) {
				// final request =)
				var responseHandler = new Zarafa.plugins.calendarimporter.data.ResponseHandler({
					successCallback: this.downLoadICS.createDelegate(this)
				});
				
				container.getRequest().singleRequest(
					'calendarmodule',
					'export',
					{
						data: this.exportResponse,
						calendar: this.calendarselector.value
					},
					responseHandler
				);
				container.getNotifier().notify('info', 'Exported', 'Found ' + this.exportResponse.length + ' entries to export. Preparing download...');
				this.dialog.close();
			}
			
			this.runningRequests--;
	},
	
	/**
	 * build a new event request for the listmodule
	 * @param {Object} calendarFolder the calendarFolder to export
	 * @param {Object} responseHandler (should be storeResult)
	 * @param {int} start
	 * @param {int} limit
	 */
	requestNext: function(calendarFolder, responseHandler, start, limit) {
		
		container.getRequest().singleRequest(
			'appointmentlistmodule',
			'list',
			{
				groupDir: "ASC",
				restriction: {
					start: start,
					limit: limit
					//startdate: 0,
					//duedate: 2145826800	// 2037... nearly highest unix timestamp
				},
				sort: [{
						"field": "startdate",
						"direction": "DESC"
				}],
				store_entryid : calendarFolder.data.store_entryid,
				entryid : calendarFolder.data.entryid
			},
			responseHandler
		);
	},
	
	/**
	 * download ics file =)
	 * @param {Object} response
	 * @private
	 */
	downLoadICS : function(response) {
		Zarafa.common.dialogs.MessageBox.hide();
		if(response.status === true) {
			if(!this.downloadFrame){
				this.downloadFrame = Ext.getBody().createChild({
					tag: 'iframe',
					cls: 'x-hidden'
				});
			}
			var url = 'plugins/calendarimporter/php/download.php?fileid='+response.fileid+'&basedir='+response.basedir+'&secid='+response.secid+'&realname='+response.realname;
			this.downloadFrame.dom.contentWindow.location = url;
		} else {
			container.getNotifier().notify('error', 'Export Failed', 'ICal File creation failed!');
		}
	},
	
	/** 
	 * This function stores all given events to the appointmentstore 
	 * @param events
	 */
	importEvents: function (events) {
		//receive existing calendar store
		var calValue = this.calendarselector.value;

		if(calValue == undefined) { // no calendar choosen
			Zarafa.common.dialogs.MessageBox.show({
				title   : _('Error'),
				msg     : _('You have to choose a calendar!'),
				icon    : Zarafa.common.dialogs.MessageBox.ERROR,
				buttons : Zarafa.common.dialogs.MessageBox.OK
			});
		} else {
			var calexist = true;
			if(this.eventgrid.selModel.getCount() < 1) {
				Zarafa.common.dialogs.MessageBox.show({
					title   : _('Error'),
					msg     : _('You have to choose at least one event to import!'),
					icon    : Zarafa.common.dialogs.MessageBox.ERROR,
					buttons : Zarafa.common.dialogs.MessageBox.OK
				});
			} else {
				var calendarStore = new Zarafa.calendar.AppointmentStore();
				var calendarFolder =  container.getHierarchyStore().getDefaultFolder('calendar');
				var pubStore = container.getHierarchyStore().getPublicStore();
				var pubFolder = pubStore.getDefaultFolder("publicfolders");
				var pubSubFolders = pubFolder.getChildren();
			
				if(calValue != "calendar") {
					var subFolders = calendarFolder.getChildren();
					var i = 0;
					for(i = 0; i < pubSubFolders.length; i++) {
						if(pubSubFolders[i].isContainerClass("IPF.Appointment")){
							subFolders.push(pubSubFolders[i]);
						}
					}
					for(i=0;i<subFolders.length;i++) {
						// look up right folder 
						// TODO: improve!!
						if(subFolders[i].getDisplayName() == calValue) {
							calendarFolder = subFolders[i];
							break;
						}
					}
					
					if(calendarFolder.isDefaultFolder()) {
						Zarafa.common.dialogs.MessageBox.show({
							title   : _('Error'),
							msg     : _('Selected calendar does not exist!'),
							icon    : Zarafa.common.dialogs.MessageBox.ERROR,
							buttons : Zarafa.common.dialogs.MessageBox.OK
						});
						calexist = false;
					}
				}

				if(calexist) {
					this.loadMask.show();
					//receive Records from grid rows
					Ext.each(events, function(newRecord) {
						var record = this.convertToAppointmentRecord(calendarFolder,newRecord.data);
						calendarStore.add(record);
					}, this);
					calendarStore.save();
					this.loadMask.hide();
					this.dialog.close();
					container.getNotifier().notify('info', 'Imported', 'Imported ' + events.length + ' events. Please reload your calendar!');
				}
			}
		}
	}	
});

Ext.reg('calendarimporter.importpanel', Zarafa.plugins.calendarimporter.dialogs.ImportPanel);
