<?php

// Mime Type Checker
function get_mime($filename,$mode=0){
// mode 0 = full check
// mode 1 = extension check only

	$mime_types = array(
		'txt' => 'text/plain',
		'htm' => 'text/html',
		'html' => 'text/html',
		'php' => 'text/html',
		'css' => 'text/css',
		'js' => 'application/javascript',
		'json' => 'application/json',
		'xml' => 'application/xml',
		'swf' => 'application/x-shockwave-flash',
		'flv' => 'video/x-flv',

		// images
		'png' => 'image/png',
		'jpe' => 'image/jpeg',
		'jpeg' => 'image/jpeg',
		'jpg' => 'image/jpeg',
		'gif' => 'image/gif',
		'bmp' => 'image/bmp',
		'ico' => 'image/vnd.microsoft.icon',
		'tiff' => 'image/tiff',
		'tif' => 'image/tiff',
		'svg' => 'image/svg+xml',
		'svgz' => 'image/svg+xml',

		// archives
		'zip' => 'application/zip',
		'rar' => 'application/x-rar-compressed',
		'exe' => 'application/x-msdownload',
		'msi' => 'application/x-msdownload',
		'cab' => 'application/vnd.ms-cab-compressed',

		// audio/video
		'mp3' => 'audio/mpeg',
		'qt' => 'video/quicktime',
		'mov' => 'video/quicktime',

		// adobe
		'pdf' => 'application/pdf',
		'psd' => 'image/vnd.adobe.photoshop',
		'ai' => 'application/postscript',
		'eps' => 'application/postscript',
		'ps' => 'application/postscript',

		// ms office
		'doc' => 'application/msword',
		'rtf' => 'application/rtf',
		'xls' => 'application/vnd.ms-excel',
		'ppt' => 'application/vnd.ms-powerpoint',
		'docx' => 'application/msword',
		'xlsx' => 'application/vnd.ms-excel',
		'pptx' => 'application/vnd.ms-powerpoint',

		// open office
		'odt' => 'application/vnd.oasis.opendocument.text',
		'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
	);

    $ext = strtolower(array_pop(explode('.',$filename)));

	if(function_exists('mime_content_type')&&$mode==0){ 
		$mimetype = mime_content_type($filename); 
		return $mimetype;
	}elseif(function_exists('finfo_open')&&$mode==0){ 
		$finfo = finfo_open(FILEINFO_MIME); 
		$mimetype = finfo_file($finfo, $filename); 
		finfo_close($finfo); 
		return $mimetype; 
	}elseif(array_key_exists($ext, $mime_types)){ 
		return $mime_types[$ext]; 
	}else { 
		return 'application/octet-stream'; 
	} 
}

/**
 * Download Files
 * This file is used to download a file from a temporary directory.
 */
function downloadAttachment() {
	$tempname  = $_GET["tmpname"];
	$filename  = $_GET["filename"];
	$tmpdir  = $_GET["basedir"];
	$secid    = $_GET["secid"];
	$attachmentdir = "attachments";
	
	$secfile = $tmpdir . DIRECTORY_SEPARATOR . "secid." . $secid;
	
	// if the secid file exists -> download!
	if(file_exists($secfile)) {
		$tmpname = $tmpdir . DIRECTORY_SEPARATOR . basename($tempname);
		
		// Check if the file still exists
		if (is_file($tmpname)) {
			// Set the headers
			header("Pragma: public");
			header("Expires: 0"); // set expiration time
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");			
			header("Content-Disposition: attachment; filename=\"" . $filename . "\"");			
			header("Content-Transfer-Encoding: binary");
			header("Content-Type: " . get_mime($tmpname));
			header("Content-Length: " . filesize($tmpname));

			// Open the uploaded file and print it
			$file = fopen($tmpname, "r");
			fpassthru($file);
			fclose($file);
		}
	}
}

// directly execute the function because this function is only created to not clutter global namespace
downloadAttachment();

?>