<html>
<body>
<?php

if (!class_exists('webdav_client')) {
 require('Owncloud/webdav.php');
} 

$wdc = new webdav_client();
$wdc->set_server('www.sprinternet.at');
$wdc->set_port(443);
$wdc->set_ssl(1);
$wdc->set_user('testu');
$wdc->set_pass('testp');
$wdc->set_pathprefix('/owncloud/files/webdav.php');
// use HTTP/1.1
$wdc->set_protocol(1);
// enable debugging
$wdc->set_debug(true);


if (!$wdc->open()) {
  print 'Error: could not open server connection';
  exit;
}

$dir = $wdc->ls($_GET["d"]);
?>
<h1>class_webdav_client Test-Suite:</h1><p>
Using method webdav_client::ls to get a listing of dir $_GET["d"]:<br>
<table summary="ls" border="1">
<th>Filename</th><th>Size</th><th>Modified</th><th>Resource Type</th>
<?php 
foreach($dir as $e) {
  $ts = $wdc->iso8601totime($e['creationdate']);
  $line = sprintf('<tr><td>%s&nbsp;</td><td>%s&nbsp;</td><td>%s&nbsp;</td><td>%s&nbsp;</td></tr>',
          $e['href'], 
          $e['getcontentlength'], 
          $e['lastmodified'],
          $e['resourcetype']
          );
  print urldecode($line);
}
?>
</table>
<?php
$test_folder = '/wdc test 33$ folder';
print '<br>creating collection ' . $test_folder .' ...<br>';
$http_status  = $wdc->mkcol($test_folder);
print 'webdav server returns ' . $http_status . '<br>';

print 'removing collection just created using method webdav_client::delete ...<br>';
//$http_status_array = $wdc->delete($test_folder);
print 'webdav server returns ' . $http_status_array['status'] . '<br>';

// put a file to webdav collection
$filename = './index.php';
print 'Let\'s put the file ' . $filename . ' using webdav::put into collection...<br>';
$handle = fopen ($filename, 'r');
$contents = fread ($handle, filesize ($filename));
fclose ($handle);
$target_path = $test_folder . '/test 123 456.php';
$http_status = $wdc->put($target_path,$contents);
print 'webdav server returns ' . $http_status .'<br>';
// ---
$filename = './class.owncloudmodule.php';
print 'Let\'s Test second put method...<br>';
$target_path = $test_folder . '/class.owncloudmodule.php';
$http_status = $wdc->put_file($target_path, $filename);
print 'webdav server returns ' . $http_status . '<br>';
?>
</body>
<html>