<?php
/**
 * Handle the upload request from the gui
 *
 * PHP Version 5
 *
 * @author   Christoph Haas <christoph.h@sprinternet.at>
 * @license  http://www.opensource.org/licenses/mit-license.php  MIT License
 */

function respondJSON($arr) {
	echo json_encode($arr);
}

ob_start();
include('version.php');
require_once('Owncloud/webdav.php');
require_once('Owncloud/authexception.php');

$wdc = new webdav_client();
$wdc->set_server($_POST["ocserv"]);

if($_POST["ocssl"] == "false" || $_POST["ocssl"] == false) {
	$wdc->set_port($_POST["port"]);
	$wdc->set_ssl(0);
} else {
	$wdc->set_port($_POST["portssl"]);
	$wdc->set_ssl(1);
}

$wdc->set_user($_POST["ocuser"]);
$wdc->set_pass(base64_decode($_POST["ocpass"]));
$wdc->set_pathprefix($_POST["ocbase"]);
// use HTTP/1.1
$wdc->set_protocol(1);
// enable debugging
$wdc->set_debug($_ENV["OC_PLUGIN_DEBUG"]);

if (!$wdc->open()) {
  print 'Error: could not open server connection';
  exit;
}

$targetpath = $_POST["parentID"] . $_FILES['attachments']['name'];
// upload the file
$http_status = $wdc->put_file($targetpath,$_FILES['attachments']['tmp_name']);

ob_end_clean(); // in case you want to suppress function_name output

if(intval($http_status) > 210) {	// something went wrong...
	respondJSON(array ('success'=>false, 'response'=>$http_status, 'message' => "Upload failed: $http_status"));
} else {
	respondJSON(array ('success'=>true, 'response'=>$http_status, 'parent'=>$_POST["parentID"], 'tmp_name'=>$_FILES['attachments']['tmp_name'], 'name'=>$_FILES['attachments']['name']));
}

?>