<?php
/**
 * download_file.php, owncloud zarafa integration module
 *
 * Author: Christoph Haas <christoph.h@sprinternet.at>
 * Copyright (C) 2012-2013 Christoph Haas
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

include('Owncloud/class.helper.php');

/**
 * Download Files
 * This file is used to download a file from a temporary directory.
 */
function downloadAttachment() {
	$tempname  = $_GET["tmpname"];
	$filename  = $_GET["filename"];
	$tmpdir  = $_GET["basedir"];
	$secid    = $_GET["secid"];
	$attachmentdir = "attachments";
	
	$secfile = $tmpdir . DIRECTORY_SEPARATOR . "secid." . $secid;
	
	// if the secid file exists -> download!
	if(file_exists($secfile)) {
		$tmpname = $tmpdir . DIRECTORY_SEPARATOR . basename($tempname);
		
		// Check if the file still exists
		if (is_file($tmpname)) {
			// Set the headers
			header("Pragma: public");
			header("Expires: 0"); // set expiration time
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");			
			header("Content-Disposition: attachment; filename=\"" . $filename . "\"");			
			header("Content-Transfer-Encoding: binary");
			header("Content-Type: " . Helper::get_mime($tmpname));
			header("Content-Length: " . filesize($tmpname));

			// Open the uploaded file and print it
			$file = fopen($tmpname, "r");
			fpassthru($file);
			fclose($file);
		}
	}
}

// directly execute the function because this function is only created to not clutter global namespace
downloadAttachment();

?>