<?php
/**
 * proxy.php, owncloud zarafa integration module
 *
 * Author: Christoph Haas <christoph.h@sprinternet.at>
 * Copyright (C) 2012-2013 Christoph Haas
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

include('version.php');
include('Owncloud/class.helper.php');
require_once('Owncloud/webdav.php');

// disable error reporting
error_reporting(0);

// set headers here
if(isset($_GET["inline"]) && $_GET["inline"] == "false") {
	header('Content-Disposition: attachment; filename="' . Helper::getFilenameFromPath($_GET["id"]) . '"');
}

$wdc = new webdav_client();
$wdc->set_server($_GET["server"]);
$wdc->set_port($_GET["port"]);
$wdc->set_ssl($_GET["ssl"] == "true" ? 1 : 0);
$wdc->set_user($_GET["user"]);
$wdc->set_pass(base64_decode($_GET["pass"]));
$wdc->set_pathprefix($_GET["path"]);
// use HTTP/1.1
$wdc->set_protocol(1);

// enable debugging
$wdc->set_debug(false);

if (!$wdc->open()) {
	print 'Error: could not open server connection';
	exit;
}

$buffer = null;
$http_status = $wdc->get($_GET["id"], $buffer);

if(intval($http_status) > 210) {
	print 'Error: failed to fetch file: ' . $http_status;
	exit;
}

header("Expires: 0"); // set expiration time
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header('Content-Length: ' . strlen($buffer));
header('Content-Type: ' . Helper::get_mime($_GET["id"]));

// print the downloaded file
echo $buffer;
flush();
?>