<?php
/**
 * upload_file.php, owncloud zarafa integration module
 *
 * Author: Christoph Haas <christoph.h@sprinternet.at>
 * Copyright (C) 2012-2013 Christoph Haas
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/**
 * Handle the upload request from the gui
 *
 * PHP Version 5
 *
 * @author   Christoph Haas <christoph.h@sprinternet.at>
 * @license  http://www.opensource.org/licenses/mit-license.php  MIT License
 */

function respondJSON($arr) {
	echo json_encode($arr);
}

ob_start();
include('version.php');
require_once('Owncloud/webdav.php');
require_once('Owncloud/authexception.php');

$wdc = new webdav_client();
$wdc->set_server($_POST["ocserv"]);

if($_POST["ocssl"] == "false" || $_POST["ocssl"] == false) {
	$wdc->set_port($_POST["port"]);
	$wdc->set_ssl(0);
} else {
	$wdc->set_port($_POST["portssl"]);
	$wdc->set_ssl(1);
}

$wdc->set_user($_POST["ocuser"]);
$wdc->set_pass(base64_decode($_POST["ocpass"]));
$wdc->set_pathprefix($_POST["ocbase"]);
// use HTTP/1.1
$wdc->set_protocol(1);
// enable debugging
$wdc->set_debug($_ENV["OC_PLUGIN_DEBUG"]);

if (!$wdc->open()) {
  print 'Error: could not open server connection';
  exit;
}

$targetpath = $_POST["parentID"] . $_FILES['attachments']['name'];
// upload the file
$http_status = $wdc->put_file($targetpath,$_FILES['attachments']['tmp_name']);

ob_end_clean(); // in case you want to suppress function_name output

if(intval($http_status) > 210) {	// something went wrong...
	respondJSON(array ('success'=>false, 'response'=>$http_status, 'message' => "Upload failed: $http_status"));
} else {
	respondJSON(array ('success'=>true, 'response'=>$http_status, 'parent'=>$_POST["parentID"], 'tmp_name'=>$_FILES['attachments']['tmp_name'], 'name'=>$_FILES['attachments']['name']));
}

?>