<?php
/**
 * plugin.owncloud.php, owncloud zarafa integration module
 *
 * Author: Christoph Haas <christoph.h@sprinternet.at>
 * Copyright (C) 2012-2013 Christoph Haas
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/**
 * Owncloud Plugin
 *
 * Integrates Owncloud into the Zarafa environment.
 */
class Pluginowncloud extends Plugin {

	/**
	 * Constructor
	 */
	function Pluginowncloud() {}

	/**
	 * Function initializes the Plugin and registers all hooks
	 *
	 * @return void
	 */
	function init() {
		$this->registerHook('server.core.settings.init.before');
	}

	/**
	 * Function is executed when a hook is triggered by the PluginManager
	 *
	 * @param string $eventID the id of the triggered hook
	 * @param mixed $data object(s) related to the hook
	 * @return void
	 */
	function execute($eventID, &$data) {
		switch($eventID) {
			case 'server.core.settings.init.before' :
				$this->injectPluginSettings($data);
				break;
		}
	}

	/**
	 * Called when the core Settings class is initialized and ready to accept sysadmin default
	 * settings. Registers the sysadmin defaults for the OWNCLOUD plugin.
	 *
	 * @param Array $data Reference to the data of the triggered hook
	 */
	function injectPluginSettings(&$data) {
		$data['settingsObj']->addSysAdminDefaults(Array(
			'zarafa' => Array(
				'v1' => Array(
					'main' => Array(
						'notifier' => Array(
							'info' => Array(
								'owncloud' => Array(
									'value' => "dropdown"		// static notifier
								)
							)
						)
					),
					'contexts' => Array(
						'owncloud' => Array(
							'server'				=> PLUGIN_OWNCLOUDATTCHMENT_SERVER,
							'owncloud_path'   		=> PLUGIN_OWNCLOUDATTCHMENT_PATH,
							'use_ssl'				=> PLUGIN_OWNCLOUDATTCHMENT_USE_SSL,
							'username'				=> PLUGIN_OWNCLOUDATTCHMENT_USER,
							'password'				=> PLUGIN_OWNCLOUDATTCHMENT_PASS,
							'port'					=> PLUGIN_OWNCLOUDATTCHMENT_PORT,
							'port_ssl'				=> PLUGIN_OWNCLOUDATTCHMENT_PORTSSL,
							'ask_before_delete'		=> PLUGIN_OWNCLOUDATTCHMENT_ASK_BEFORE_DELETE,
							'webapp_tmp'			=> TMP_PATH,
							'enable_caching'		=> PLUGIN_OWNCLOUDBROWSER_ENABLE_CACHE
						)
					),
					'plugins' => Array(
						'owncloud' => Array(
							'enable_attach_from_oc'	=> PLUGIN_OWNCLOUDATTACHMENT_USER_DEFAULT_ENABLE,
							'enable_store_to_oc'	=> PLUGIN_OWNCLOUDRCVATTACHMENT_USER_DEFAULT_ENABLE,
							'enable_browser'		=> PLUGIN_OWNCLOUDBROWSER_USER_DEFAULT_ENABLE,
							'button_name'			=> PLUGIN_OWNCLOUDBROWSER_BUTTONNAME
						)
					)
				)
			)
		));
	}
}

?>
