<?php
/**
 * Imapsync module.
 * Module that will be used to sync a IMAP server
 */
class ImapsyncModule extends Module
{
	/**
	 * Process the incoming events that were fire by the client.
	 */
	public function execute()
	{
		foreach($this->data as $actionType => $actionData)
		{
			if(isset($actionType)) {
				try {
					switch($actionType)
					{
						case 'save':
							$this->save($actionData);
							break;
						default:
							$this->handleUnknownActionType($actionType);
					}
				} catch (MAPIException $e) {
					$this->sendFeedback(false, $this->errorDetailsFromException($e));
				}

			}
		}
	}

	/**
	 * Sync IMAP after user presses applies when added the IMAP data.
	 * @param {Array} $data data sent by client.
	 */
	public function save($data)
	{
		$errorMessage = '';

		// some sanity checks
		if(empty($data)) {
			$errorMessage = _('No data received.');
		}

		if(empty($data['imap_server'])) {
			$errorMessage = _('No IMAP server given.');
		}

		if(empty($data['imap_username'])) {
			$errorMessage = _('IMAP username is empty.');
		}

		if(empty($data['imap_password'])) {
			$errorMessage = _('IMAP password is empty.');
		}

		if(empty($errorMessage)) {
				$this->saveInDB($data);
		} else {
			$this->sendFeedback(false, array(
				'type' => ERROR_ZARAFA,
				'info' => array(
					'display_message' => $errorMessage
				)
			));
		}
	}


	/**
	 * Function will execute zarafa-imapsync command and will try to change user's IMAP data,
	 * this method is unsecure and unreliable.
	 * @param {Array} $data data sent by client.
	 */
	public function saveInDB($data)
	{
		$errorMessage = '';

		// Do the sync!
		$source = array(
			'host' => $data['imap_server'],
			'user' => $data['imap_username'],
			'password' => $data['imap_password'],
                        'tls' => true,
		);

		//$user = container.getUser();
		//$container = $this->getContainer();

		$destination = array(
			'host' => PLUGIN_IMAPSYNC_ZARAFA_SERVER,
			'user' => $_SESSION['username'],
			'password' => $_SESSION['password'],
                        'tls' => false,
		);

		$c = new Celery('localhost', 'guest', 'guest', '/');
		$task = $c->PostTask('tasks.imapsync', array($source, $destination));

		// send feedback to client
		$this->sendFeedback(true, array(
				'info' => array(
				'display_message' => _('IMAP server sync is starting.')
			)
		));

		if(!empty($errorMessage)) {
			$this->sendFeedback(false, array(
				'type' => ERROR_ZARAFA,
				'info' => array(
					'display_message' => $errorMessage
				)
			));
		}
	}

}
?>
