Ext.namespace('Zarafa.plugins.imapsync.settings');

/**
 * @class Zarafa.plugins.imapsync.settings.SettingsImapsyncCategory
 * @extends Zarafa.settings.ui.SettingsCategory
 * @xtype zarafa.settingsimapsynccategory
 *
 * The imapsync settings category that will allow users to sync a IMAP server
 */
Zarafa.plugins.imapsync.settings.SettingsImapsyncCategory = Ext.extend(Zarafa.settings.ui.SettingsCategory, {
	/**
	 * @constructor
	 * @param {Object} config Configuration object
	 */
	constructor : function(config)
	{
		config = config || {};

		Ext.applyIf(config, {
			title : _('Import IMAP'),
			iconCls : 'icon_imapsync',
			categoryIndex : 9997,
			xtype : 'zarafa.settingsimapsynccategory',
			items : [{
				xtype : 'zarafa.settingsimapsyncwidget',
				settingsContext : config.settingsContext
			}]
		});

		Zarafa.plugins.imapsync.settings.SettingsImapsyncCategory.superclass.constructor.call(this, config);
	}
});

Ext.reg('zarafa.settingsimapsynccategory', Zarafa.plugins.imapsync.settings.SettingsImapsyncCategory);
