#ifndef ECCONFIG_H
#define ECCONFIG_H

#include <map>
#include <list>
#include <string>
using namespace std;

typedef struct { char s[256]; } SETTINGNAME;

struct settingcompare
{
  bool operator()(SETTINGNAME a, SETTINGNAME b) const
  {
    return strcmp(a.s,b.s) < 0;
  }
};

#define MAXLINELEN 4096

typedef map<SETTINGNAME, char *, settingcompare> SETTINGMAP;

class ECConfig {
public:
	ECConfig(char **lppDefaults);
	~ECConfig();

	bool	LoadSettings(const char *szFilename);
	char*	GetSetting(const char *szName);
	char*	GetSetting(const char *szName, char *equal, char *other);

	bool	HasErrors();
	list<string>* GetErrors();

	void	AddSetting(const char *szName, const char *szValue, bool override = false);

private:
	SETTINGMAP	mapSettings;
	list<string> errors;
};

#endif // ECCONFIG_H
