#ifndef ECTAGS_H
#define ECTAGS_H

// Public Zarafa properties
#define PR_EC_BASE			0x6700

#define PR_EC_PATH			PROP_TAG(PT_STRING8,	PR_EC_BASE+0x00)
#define PR_EC_USERNAME		PROP_TAG(PT_STRING8,	PR_EC_BASE+0x01)
#define PR_EC_USERPASSWORD	PROP_TAG(PT_STRING8,	PR_EC_BASE+0x02)
#define PR_EC_PORT			PROP_TAG(PT_STRING8,	PR_EC_BASE+0x03)
#define PR_EC_FLAGS			PROP_TAG(PT_LONG,		PR_EC_BASE+0x04)
#define PR_EC_SSLKEY_FILE	PROP_TAG(PT_STRING8,	PR_EC_BASE+0x05)
#define PR_EC_SSLKEY_PASS	PROP_TAG(PT_STRING8,	PR_EC_BASE+0x06)
//#define PR_EC_SSLKEY_CERT	PROP_TAG(PT_STRING8,	PR_EC_BASE+0x07)

// The property under which we actually save the PR_ENTRYID in recipient tables
#define PR_EC_CONTACT_ENTRYID	PROP_TAG(PT_BINARY,		PR_EC_BASE+0x10)

// Flags for PR_EC_FLAGS
#define EC_PROFILE_FLAGS_NO_NOTIFICATIONS		0x0000001
#define EC_PROFILE_FLAGS_NO_COMPRESSION			0x0000002
#define EC_PROFILE_FLAGS_OFFLINE				0x0000080
#define EC_PROFILE_FLAGS_CACHE_PRIVATE			0x0000100
#define EC_PROFILE_FLAGS_CACHE_PUBLIC			0x0000400
// Zarafa internal flags
#define EC_PROVIDER_OFFLINE						0x0F00000

// The hidden object property which can be used to access the underlying IECUnknown object though a pointer in lpszA
#define PR_EC_OBJECT		PROP_TAG(PT_OBJECT,		PR_EC_BASE+0x7f)

#define PR_EC_QUOTA_MAIL_TIME	PROP_TAG(PT_SYSTIME,	PR_EC_BASE+0x20)
//NOTE:	The properties PR_QUOTA_WARNING_THRESHOLD, PR_QUOTA_SEND_THRESHOLD, PR_QUOTA_RECEIVE_THRESHOLD
//		are in the range of PR_EC_BASE+0x21 to PR_EC_BASE+0x23

#define PR_EC_OUTOFOFFICE		PROP_TAG(PT_BOOLEAN,	PR_EC_BASE+0x60)
#define PR_EC_OUTOFOFFICE_MSG	PROP_TAG(PT_STRING8,	PR_EC_BASE+0x61)
#define PR_EC_OUTOFOFFICE_SUBJECT PROP_TAG(PT_STRING8, 	PR_EC_BASE+0x62)

#define PR_EC_WEBACCESS_SETTINGS	PROP_TAG(PT_STRING8, PR_EC_BASE+0x70)
#define PR_EC_RECIPIENT_HISTORY		PROP_TAG(PT_STRING8, PR_EC_BASE+0x71)


// Contains the 'flags' column in the outgoing queue (EC_SUBMIT_{MASTER,LOCAL,DOSENTMAIL})
#define PR_EC_OUTGOING_FLAGS	PROP_TAG(PT_LONG,		PR_EC_BASE+0x80)

#define PR_EC_SEARCHFOLDER_STATUS	PROP_TAG(PT_LONG,	PR_EC_BASE+0x90)
#define EC_SEARCHFOLDER_STATUS_RUNNING 0
#define EC_SEARCHFOLDER_STATUS_REBUILD 1
#define EC_SEARCHFOLDER_STATUS_STOPPED 2

// Type of store
#define ECSTORE_TYPE_PRIVATE	0
#define ECSTORE_TYPE_PUBLIC		1


#endif
