#ifndef UTIL_H
#define UTIL_H

#include "edkmdb.h"
#include <string>

class Util {
public:
	static std::string GetServerNameFromPath(const char *szPath);
	static std::string GetServerPortFromPath(const char *szPath);
	static std::string GetServerTypeFromPath(const char *szPath);
	static std::string ServerNamePortToURL(const char *lpszType, const char *lpszServerName, const char *lpszServerPort);

	static HRESULT	HrAddToPropertyArray(LPSPropValue lpSrc, ULONG cValues, LPSPropValue lpAdd, LPSPropValue *lppDest, ULONG *cDestValues);

	static HRESULT	HrCopyPropertyArray(LPSPropValue lpSrc, ULONG cValues, LPSPropValue *lppDest, ULONG *cDestValues, bool bExcludeErrors = false);
	static HRESULT	HrCopyPropertyArrayByRef(LPSPropValue lpSrc, ULONG cValues, LPSPropValue *lppDest, ULONG *cDestValues, bool bExcludeErrors = false);
	static HRESULT	HrCopyPropertyArray(LPSPropValue lpSrc, ULONG cValues, LPSPropValue lpDest, void *lpBase);
	static HRESULT	HrCopyProperty(LPSPropValue lpDest, LPSPropValue lpSrc, void *lpBase);
	static HRESULT	HrCopyPropertyByRef(LPSPropValue lpDest, LPSPropValue lpSrc);
	static HRESULT	HrCopySRestriction(LPSRestriction lpDest, LPSRestriction lpSrc, void *lpBase);
	static HRESULT  HrCopySRestriction(LPSRestriction *lppDest, LPSRestriction lpSrc);
	static HRESULT	HrCopyActions(ACTIONS *lpDest, ACTIONS *lpSrc, void *lpBase);
	static HRESULT	HrCopyAction(ACTION *lpDest, ACTION *lpSrc, void *lpBase);
	static HRESULT	HrCopySRowSet(LPSRowSet lpDest, LPSRowSet lpSrc, void *lpBase);
	static HRESULT	HrCopySRow(LPSRow lpDest, LPSRow lpSrc);

	static HRESULT	CompareProp(LPSPropValue lpProp1, LPSPropValue lpProp2, int* lpCompareResult);
	static unsigned int PropSize(LPSPropValue lpProp);

	static HRESULT	HrTextToRtf(IStream *text, IStream *rtf);
	static HRESULT	HrHTMLToText(char *lpBuffer);
	static LONG		HrFindPropInArray(LPSPropTagArray lpPropTags, ULONG ulPropTag);

	static HRESULT	HrTextToHtml(IStream *text, IStream *html);
	static HRESULT	HrHtmlToText(IStream *html, IStream *text);
	static HRESULT	HrHtmlToRtf(IStream *html, IStream *rtf, unsigned int ulCodepage);

	static char*	HrMAPIErrorToText(HRESULT hr);

	static bool ValidatePropTagArray(LPSPropTagArray lpPropTagArray);

	static HRESULT HrConvertUnicodeToString8(ULONG cValues, LPSPropValue lpPropArrayIn, LPSPropValue* lppPropArrayOut);

	static std::string bin2hex(ULONG inLength, LPBYTE input);
	static HRESULT bin2hex(ULONG inLength, LPBYTE input, char **output, void *parent = NULL);
	static HRESULT hex2bin(char *input, size_t len, ULONG *outLength, LPBYTE *output, void *parent = NULL);
	static HRESULT hex2bin(std::string input, std::string *output);

	static void BufferLFtoCRLF(size_t size, const char *input, char *output, size_t *outsize);

private:
	static unsigned char x2b(char c);	// hex2bin helper
	
};

#endif // UTIL_H
