#ifndef PLATFORM_H
#define PLATFORM_H

/*
 * File for the different platforms. When WIN32 is defined the windows specific file will be include.
 */

#ifdef WINCE
#ifndef WIN32
#define WIN32
#endif
#ifndef _WIN32_WCE
#define _WIN32_WCE 0x420
#endif
//#define __stdcall
//#define __cdecl
//#define FAR
#endif

#ifdef WIN32

#ifndef WINVER				// Allow use of features specific to Windows 95 and Windows NT 4 or later.
#define WINVER 0x0400		// Change this to the appropriate value to target Windows 98 and Windows 2000 or later.
#endif

// Insert your headers here
#define WIN32_LEAN_AND_MEAN

#ifndef EC_NO_MFC
#include <afxwin.h>         // MFC core and standard components
#include <afxext.h>         // MFC extensions

#ifndef _AFX_NO_OLE_SUPPORT
#include <afxole.h>         // MFC OLE classes
#include <afxodlgs.h>       // MFC OLE dialog classes
#include <afxdisp.h>        // MFC Automation classes
#endif // _AFX_NO_OLE_SUPPORT

#else
#ifdef _DEBUG
    #define DEBUG_NEW new(_CLIENT_BLOCK, THIS_FILE, __LINE__)
#define ASSERT(s) if(!(s)) __asm int 3;
#else
	#define ASSERT

#endif // _DEBUG

#endif // EC_NO_MFC

#define FD_SETSIZE 8192 // allow win32 to use more than 64 sockets
#include <winsock2.h>
#include <windows.h>

#ifndef WINCE
#include <sys/timeb.h>

#include <crtdbg.h> // used for _ASSERT
#endif
#include <time.h>

#ifdef WINCE
#include "wce_time.h"
#endif

#include <stdio.h>
#include <stdlib.h>

// Remove 'truncated to 255 characters' warning
#pragma warning(disable: 4786)
// Remove 'C++ exception specification ignored' warning
#pragma warning(disable: 4290)

#define NANOSECS_BETWEEN_EPOCHS 116444736000000000

#define snprintf _snprintf

#ifdef WINCE
#define GUID_EXT extern "C"
#define stricmp _stricmp
#define strupr _strupr
#define strnicmp _strnicmp
#define strdup _strdup
#define lstrlenA strlen
#define lstrcpyA strcpy
#define FLAGS ULONG
typedef ULONG FAR *         LPULONG;
#ifndef __LHANDLE
#define __LHANDLE
typedef unsigned long   LHANDLE, FAR * LPLHANDLE;
#endif
//#define snprintf StringCbPrintfA
//#define _gets StringCbGets
//#define sprintf StringCbPrintf
//#define vsprintf StringCbVPrintf
//#define _vsnprintf StringCbVPrintfA
//#define _snprintf StringCbPrintfA
inline void GetSystemTimeAsFileTime(FILETIME *ft) {
	//TODO make this for WINCE
	ft->dwLowDateTime = 0;
	ft->dwHighDateTime = 0;
}

inline char *strerror(int errnum)
{
	return "Unknown Error";
}

inline void gettimeofday(struct timeval* tp, void *n)
{
  tp->tv_sec  = 0;
  tp->tv_usec = 0;
}

inline bool getenv(char*)
{
	//??????????????
	return true;
}
#define dlopen(path, flags)	LoadLibraryZ(path)
inline HINSTANCE LoadLibraryZ(LPCSTR lpLibFileName){
	WCHAR lpWideCharStr[1024];
	MultiByteToWideChar(CP_ACP,0,lpLibFileName,strlen(lpLibFileName),lpWideCharStr,1024);
	return LoadLibraryW(lpWideCharStr);
}
#define dlsym(lib, func)	GetProcAddressA(lib, func)
#else
inline void gettimeofday(struct timeval* tp, void *n)
{
  struct timeb tm;
  ftime(&tm);
  tp->tv_sec  = tm.time;
  tp->tv_usec = tm.millitm * 1000;
}
#define dlopen(path, flags)	LoadLibrary(path)
#define dlsym(lib, func)	GetProcAddress(lib, func)
#endif

#define unicodetombs wcstombs
#define mbstounicode mbstowcs
#define unicodelen wcslen
#define unicodecmp wcscmp
#define unicodecpy wcscpy

typedef HMODULE DLIB;
#define dlerror()			strerror(GetLastError())
#define dlclose(lib)		FreeLibrary(lib)
#define ZARAFA_REAL_DLL_NAME		"zarafaclient32.dll"

// Strange, I can't find this #define in any windows header ...

#ifndef PATH_MAX
#define PATH_MAX 512
#endif

#define SHARED_OBJECT_EXTENSION "dll"
#define PATH_SEPARATOR '\\'

#else  // ifdef WIN32

// We have to include this now in case select.h is included
// too soon.
// Increase our maximum amount of file descriptors to 8192
#include <bits/types.h>
#undef __FD_SETSIZE
#define __FD_SETSIZE 8192

#include "config.h"
#include "platform.linux.h"

#define NANOSECS_BETWEEN_EPOCHS 116444736000000000LL

#endif // if WIN32

#define ZARAFA_SYSTEM_USER	"SYSTEM"

static const LONGLONG UnitsPerMinute = 600000000;
static const LONGLONG UnitsPerHalfMinute = 300000000;

/*
 * Platform independent functions
 */
HRESULT	UnixTimeToFileTime(time_t t, FILETIME *ft);
HRESULT	FileTimeToUnixTime(FILETIME &ft, time_t *t);
void	UnixTimeToFileTime(time_t t, int *hi, unsigned int *lo);
time_t	FileTimeToUnixTime(unsigned int hi, unsigned int lo);
void	RTimeToFileTime(LONG rtime, FILETIME *pft);
void	FileTimeToRTime(FILETIME *pft, LONG* prtime);
HRESULT	UnixTimeToRTime(time_t unixtime, LONG *rtime);
HRESULT	RTimeToUnixTime(LONG rtime, time_t *unixtime);

struct tm* gmtime_safe(const time_t* timer, struct tm *result);

int operator ==(FILETIME a, FILETIME b);
int operator >(FILETIME a, FILETIME b);
int operator <(FILETIME a, FILETIME b);
time_t operator -(FILETIME a, FILETIME b);

/* convert struct tm to time_t in timezone UTC0 (GM time) */
time_t			convertGMTime(struct tm *t);


// Random-number generators
void	rand_init();
int		rand_mt();

// A hybrid select() that can select() on both FD_SET's and HANDLEs
int		select_hybrid(int maxfd, fd_set *readfds, fd_set *writefds, fd_set *exfds, struct timeval *timeout, HANDLE *lpHandles, ULONG cHandles, ULONG *lpulHandleState);

char *	get_password(const char *prompt);

#ifdef WIN32
 #ifdef ZARAFA_EXPORTS
  #define ZARAFA_API __declspec(dllexport)
 #else
  #define ZARAFA_API __declspec(dllimport)
 #endif
#else
 #define ZARAFA_API
#endif

#endif // PLATFORM_H
