#ifndef RECORD_H
#define RECORD_H

#include <string>
#include <list>
#include <vector>

#include "dict.h"

/* Field types */
#define	DATA_VARCHAR		1
#define DATA_CHAR			2
#define DATA_FIXBINARY		3
#define DATA_BINARY			4
#define DATA_BLOB			5
#define	DATA_INT			6
#define	DATA_SYS_CHILD		7
#define	DATA_SYS			8
#define DATA_FLOAT			9
#define DATA_DOUBLE			10
#define DATA_DECIMAL		11
#define	DATA_VARMYSQL		12
#define	DATA_MYSQL			13
#define DATA_MTYPE_MAX		63

/* Precise types */
#define DATA_ENGLISH		4
#define DATA_ERROR			111
#define DATA_MYSQL_TYPE_MASK 255
#define DATA_MYSQL_TRUE_VARCHAR 15

/* Internal types */
#define	DATA_ROW_ID			0
#define DATA_ROW_ID_LEN		6
#define DATA_TRX_ID			1
#define DATA_TRX_ID_LEN		6
#define	DATA_ROLL_PTR		2
#define DATA_ROLL_PTR_LEN	7
#define DATA_MIX_ID			3
#define DATA_MIX_ID_LEN		9
#define	DATA_N_SYS_COLS 	4

/* Precise type flags */
#define DATA_NOT_NULL		256
#define DATA_UNSIGNED		512
#define	DATA_BINARY_TYPE	1024
#define	DATA_LONG_TRUE_VARCHAR 4096

#define DATA_ORDER_NULL_TYPE_BUF_SIZE		4
#define DATA_NEW_ORDER_NULL_TYPE_BUF_SIZE	6

/* Record offsets */
#define REC_N_OLD_EXTRA_BYTES 6
#define REC_N_NEW_EXTRA_BYTES 5


#define PAGE_OLD_INFIMUM		(PAGE_DATA+1+REC_N_OLD_EXTRA_BYTES)
#define PAGE_OLD_SUPREMUM		(PAGE_DATA+2+2*REC_N_OLD_EXTRA_BYTES+8)
#define PAGE_OLD_SUPREMUM_END	(PAGE_OLD_SUPREMUM+9)
#define PAGE_NEW_INFIMUM		(PAGE_DATA+REC_N_NEW_EXTRA_BYTES)
#define PAGE_NEW_SUPREMUM		(PAGE_DATA+2*REC_N_NEW_EXTRA_BYTES+8)
#define PAGE_NEW_SUPREMUM_END	(PAGE_NEW_SUPREMUM+8)

#define PAGE_DIR_SLOT_SIZE		2
#define PAGE_DIR				FIL_PAGE_DATA_END

/* Blob defs */
#define BTR_EXTERN_SPACE_ID			0 
#define BTR_EXTERN_PAGE_NO			4 
#define BTR_EXTERN_OFFSET			8 
#define BTR_EXTERN_LEN				12 
#define BTR_EXTERN_FIELD_REF_SIZE	20

#define BTR_BLOB_HDR_NEXT_PAGE_NO	4

typedef struct {
  unsigned int len;
  unsigned int isnull;
  unsigned int isblob;
  char *data;
  unsigned int blobspace;
  unsigned int blobpage;
  unsigned int bloboffset;
  unsigned int bloblen;
} INNOFIELD;

typedef struct {
  unsigned short next;
  unsigned char offsetsize;
  unsigned short fields;
  unsigned short ordernr;
  unsigned short owned;
  unsigned short delmarked;
  unsigned short type;
  std::vector<INNOFIELD> field;
} INNORECORD;

// Record finding
char *rec_get_infimum(char *page);
char *rec_get_supremum(char *page);
char *rec_get_next(int comp, char *page, char *rec);

// Dumping
char *dump_record(INNORECORD *record);
char *dump_record_short(int fd, INNORECORD *record, INNOTABLE *table);

// Reading records
INNORECORD *rec_read_old(char *rec, char *page);
INNORECORD *rec_read_new(std::vector<INNOCOLUMN> columns, char *rec, char *page);

// Reading fields
int rec_is_nth_field_null(std::vector<INNOCOLUMN> columns, int comp, char *rec, int field, char *page);
int rec_is_nth_field_blob(std::vector<INNOCOLUMN> columns, int comp, char *rec, int field, char *page);
int rec_get_nth_field_len(std::vector<INNOCOLUMN> columns, int comp, char *rec, int field, char *page);
char * rec_get_nth_field(std::vector<INNOCOLUMN> columns, int comp, char *rec, int field, char *page);
int rec_get_field_count(std::vector<INNOCOLUMN> columns, int comp, char *rec, char *page);
unsigned long long rec_get_nth_field_int(std::vector<INNOCOLUMN> columns, int comp, char *rec, int field, int uns, char *page);
std::string rec_get_nth_field_string(std::vector<INNOCOLUMN> columns, int comp, char *rec, int field, char *page);

// Blob handling
int blob_get_data_len(char *pagedata, int offset);
int blob_get_next_page(char *pagedata, int offset);

// Internals
int field_type_is_fixed(unsigned int type, unsigned int prtype);
unsigned long long int_from_field(char *data, int len, int uns);
std::string EscapeBinary(char *data, unsigned int len);

#endif
