#include "util.h"

#include <ctype.h>

char *bin2hex(char *data, unsigned int len) {
  static char s[16384];
  const char hexdigit[] = "0123456789ABCDEF";
  char *out = s;
  unsigned int slen;
  char *sdata;
  
  sdata = data;
  slen = len;
  while(slen>0) {
    *out++ = hexdigit[(*sdata >> 4) & 0xf];
    *out++ = hexdigit[*sdata & 0xf];
    sdata++;
    slen--;
  }
  
  *out++ = ' ';
  
  slen = len;
  sdata = data;
  
  while(slen>0) {
    if(!iscntrl(*sdata)) {
      *out++ = *sdata;
    } else {
      *out++ = '.';
    }
    sdata++;
    slen--;
  }
  
  *out = 0;
  
  return s;
}                                                                                
