#ifndef DICT_H
#define DICT_H

#include <string>
#include <vector>
#include <list>

typedef struct {
  std::string name;
  int mtype;
  int prtype;
  int len;
  int prec;
} INNOCOLUMN;

typedef struct {
  unsigned long long int id;
  std::string name;
  int nfields;
  int type;
  int space;
  int pageno;
  std::vector<std::string> fieldnames;
  std::vector<INNOCOLUMN> columns; // This is the generated column order for this index in leaf pages: (primary1, primary2, ..., primary N), TRX, UNDO, (other1, other2, ..., otherN)
  std::vector<INNOCOLUMN> nodecolumns; // This is the generated column order for this index in node pages: (primary1, primary2, ..., primaryN, pageno)
} INNOINDEX;

typedef struct {
  std::string name;
  std::string id;
  int cols;
  int type;
  std::string mixid;
  int mixlen;
  std::string clustername;
  int space;
  std::vector<INNOCOLUMN> columns;
  std::vector<INNOINDEX *> indexes;
} INNOTABLE;

extern std::list<INNOTABLE*> tables;

/* Dictionary header page */
#define DICT_PAGE		7

/* Dictionary header data offset */
#define DICT_HDR		FSEG_PAGE_DATA

#define DICT_CLUSTERED	1
#define DICT_UNIQUE		2
#define DICT_UNIVERSAL	4
#define DICT_IBUF		8
                                

/* Dictionary header data */
#define DICT_HDR_ROW_ID		0
#define DICT_HDR_TABLE_ID	8
#define DICT_HDR_INDEX_ID	16
#define DICT_HDR_MIX_ID		24
#define DICT_HDR_TABLES		32
#define DICT_HDR_TABLE_IDS	36
#define DICT_HDR_COLUMNS	40
#define DICT_HDR_INDEXES	44
#define DICT_HDR_FIELDS 	48
#define DICT_HDR_FSEG_HEADER 56

// Loading dictionary
void load_table_defs(int fd, int indexpage);
void load_column_defs(int fd, int indexpage);
void load_index_defs(int fd, int indexpage);
void load_index_field_defs(int fd, int indexpage);
void load_index_columns();

// Dictionary info
int dict_get_nullable(std::vector<INNOCOLUMN> columns);

// Dump dictionary
void dump_table_defs();
void dump_table_defs_short();

// Dictionary lookups
INNOTABLE *dict_find_table_by_id(std::string tableid);
INNOTABLE *dict_find_table_by_name(std::string tablename);
INNOINDEX *dict_find_index_by_id(unsigned long long int indexid);
INNOCOLUMN find_field_by_name(INNOTABLE *table, std::string colname);

// Internals
void dict_add_column(std::string tableid, unsigned int pos, INNOCOLUMN column);
void dict_add_index(std::string tableid, INNOINDEX index);
void dict_add_index_field(unsigned long long int indexid, unsigned int pos, std::string colname);

#endif
