#ifndef PAGE_H
#define PAGE_H

#include "dict.h"

/* Page size */
#define PAGE_SIZE_SHIFT 14
#define PAGE_SIZE 		(1<<PAGE_SIZE_SHIFT)
#define PAGE_ROUND_DOWN(x) ((unsigned long long)x & ~0x3fff)

/* Generic page info */
#define FIL_PAGE_DATA			38
#define FIL_PAGE_DATA_END		8

#define FSEG_PAGE_DATA			FIL_PAGE_DATA
#define FIL_PAGE_PREV			8
#define FIL_PAGE_NEXT			12
#define FIL_PAGE_TYPE			24
                                                                                
#define FIL_PAGE_LSN			16 
#define FIL_PAGE_FILE_FLUSH_LSN	26
#define FIL_PAGE_OFFSET			4
#define FIL_PAGE_DATA 			38
#define FIL_PAGE_END_LSN_OLD_CHKSUM 8
#define FIL_PAGE_SPACE_OR_CHKSUM 0
#define FIL_PAGE_ARCH_LOG_NO_OR_SPACE_ID 34

/* Index page header fields */
#define PAGE_N_DIR_SLOTS 	0
#define	PAGE_HEAP_TOP		2
#define	PAGE_N_HEAP	 		4
#define	PAGE_FREE	 		6
#define	PAGE_GARBAGE		8
#define	PAGE_LAST_INSERT	10
#define	PAGE_DIRECTION	 	12
#define	PAGE_N_DIRECTION	14
#define	PAGE_N_RECS			16
#define PAGE_MAX_TRX_ID		18
#define PAGE_HEADER_PRIV_END 26

#define	PAGE_LEVEL			26
#define	PAGE_INDEX_ID		28
#define PAGE_BTR_SEG_LEAF 	36
#define PAGE_BTR_IBUF_FREE_LIST	PAGE_BTR_SEG_LEAF
#define PAGE_BTR_IBUF_FREE_LIST_NODE PAGE_BTR_SEG_LEAF
#define PAGE_BTR_SEG_TOP (36 + FSEG_HEADER_SIZE)

#define PAGE_FREE_EMPTY (PAGE_SIZE - PAGE_NEW_SUPREMUM_END - PAGE_DIR - 2 * PAGE_DIR_SLOT_SIZE)
#define PAGE_FREE_EMPTY_OLD (PAGE_SIZE - PAGE_OLD_SUPREMUM_END - PAGE_DIR - 2 * PAGE_DIR_SLOT_SIZE)

#define FSEG_HEADER_SIZE	10
#define PAGE_HEADER			FSEG_PAGE_DATA  /* index page header starts here */

#define PAGE_DATA			(PAGE_HEADER + 36 + 2 * FSEG_HEADER_SIZE)

/* Reading data from pages */
unsigned int read_ulint(char *offset);
unsigned long read_dulint(char *offset);
unsigned int read_ulshort(char *offset);
int read_lshort(char *offset);
unsigned int read_ulchar(char *offset);

/* Dump page info */
void dump_index_page_info(char *page);
void dump_page_info(char *page, unsigned int pagenr);

/* Reading pages */
char *page_read(int fd, unsigned long ulPage);
void page_free(char *page);

/* Page information */
int page_index_is_comp(char *pagedata);
int page_get_next(char *pagedata);
int page_is_leaf(char *pagedata);
int page_get_leftmost(std::vector<INNOCOLUMN> columns, char *pagedata);

#endif
