## groupProperties - event handling code for userconf's group properties
## Copyright (C) 2001-2003 Red Hat, Inc.
## Copyright (C) 2001-2003 Brent Fox <bfox@redhat.com>
## Copyright (C) 2006-2007 Zarafa Extensions by Zarafa, The Netherlands

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

## Author: Brent Fox

import signal
import gtk
import gobject
import string
import os
import mainWindow
import messageDialog
import libuser_zarafa_ldap
libuser = libuser_zarafa_ldap
import userGroupCheck

##
## I18N
##
from rhpl.translate import _, N_
import rhpl.translate as translate
domain = "zarafa-config-users"
translate.textdomain (domain)

busy_cursor = gtk.gdk.Cursor(gtk.gdk.WATCH)
ready_cursor = gtk.gdk.Cursor(gtk.gdk.LEFT_PTR)

class groupProperties:
    def __init__(self, parent, user_clist, group_clist, xml):
        self.parent = parent
        self.user_clist = user_clist
        self.group_clist = group_clist

        self.groupWin = xml.get_widget('groupProperties')
        self.groupWin.connect("delete-event", self.on_groupProperties_cancel_button_clicked)
        self.groupWin.set_position(gtk.WIN_POS_CENTER)
        self.groupWin.set_icon(mainWindow.iconPixbuf)
        self.groupWin.set_icon(mainWindow.iconPixbuf)
        self.groupWinGroupName = xml.get_widget('groupNameEntry')
        self.groupNotebook = xml.get_widget('groupNotebook')
        self.userVBox = xml.get_widget('groupPropUserVBox')

        self.userStore = gtk.ListStore(gobject.TYPE_BOOLEAN, gobject.TYPE_STRING)

        self.userTreeView = gtk.TreeView(self.userStore)
        self.userTreeView.set_property("headers-visible", gtk.FALSE)

        self.checkboxrenderer = gtk.CellRendererToggle()
        self.checkboxrenderer.connect("toggled", self.toggled_item)
        col = gtk.TreeViewColumn(None, self.checkboxrenderer, active=0)
        self.userTreeView.append_column(col)
        col = gtk.TreeViewColumn(None, gtk.CellRendererText(), text=1)
        self.userTreeView.append_column(col)

        self.userChecklistSW = gtk.ScrolledWindow()
        self.userChecklistSW = gtk.ScrolledWindow()
        self.userChecklistSW.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
        self.userChecklistSW.set_shadow_type(gtk.SHADOW_IN)
        self.userChecklistSW.add(self.userTreeView)           
        self.userVBox.pack_start(self.userChecklistSW, gtk.TRUE)

        xml.signal_connect("on_groupProperties_cancel_button_clicked", self.on_groupProperties_cancel_button_clicked)
        xml.signal_connect("on_groupProperties_ok_button_clicked", self.on_groupProperties_ok_button_clicked)

    def busy(self):
        self.groupWin.set_sensitive(gtk.FALSE)
        self.groupWin.window.set_cursor(busy_cursor)

    def ready(self):
        self.groupWin.window.set_cursor(ready_cursor)
        self.groupWin.set_sensitive(gtk.TRUE)

    def groupWinReset(self):
        self.groupNotebook.set_current_page(0)
        self.userStore.clear()

    def newGroupWin(self):
        self.groupEnt = None
        self.groupWinReset()
        self.groupWinGroupName.set_text("")
        self.groupWinGroupName.set_sensitive(gtk.TRUE)
        self.groupWinGroupName.grab_focus()
        self.fill_users_list(None)
        self.groupWin.show_all()

    def showGroupProperties(self, groupEnt):
        self.groupEnt = groupEnt
        self.groupWinReset()

        cn = self.groupEnt.get(libuser.GROUPNAME)[0]
        self.groupWinGroupName.set_text(cn)
        self.groupWinGroupName.set_sensitive(gtk.FALSE)

        self.fill_users_list(self.groupEnt)
        self.groupWin.show_all()

    def on_groupProperties_cancel_button_clicked(self, *args):
        self.groupWinReset()
        self.groupWin.hide()
        return gtk.TRUE

    def on_groupProperties_ok_button_clicked(self, *args):
        self.busy()
        groupEnt = self.groupEnt
        try:
            self._on_groupProperties_ok_button_clicked(*args)
            self.ready()
        except:
            self.ready()
            self.groupEnt = groupEnt
            messageDialog.show_ldap_error_dialog()

    def _on_groupProperties_ok_button_clicked(self, *args):
        newGroupName = self.groupWinGroupName.get_text()

        #Check for ascii-only strings
        if not userGroupCheck.isGroupnameOk(newGroupName, self.groupWinGroupName):
            self.ready()
            self.groupWinGroupName.grab_focus()
            return

        if newGroupName == "":
            dlg = gtk.MessageDialog(None, 0, gtk.MESSAGE_WARNING, gtk.BUTTONS_OK,
                                    (_("Please enter a group name.")))
            dlg.set_position(gtk.WIN_POS_CENTER)
            dlg.set_icon(mainWindow.iconPixbuf)
            dlg.set_modal(gtk.TRUE)
            dlg.show_all()
            dlg.run()
            dlg.destroy()
            self.ready()
            self.groupWinGroupName.set_text("")
            self.groupWinGroupName.grab_focus()
            return

        #Check for ascii-only strings
        if not userGroupCheck.isGroupnameOk(newGroupName, self.groupWinGroupName):
            self.ready()
            self.groupWinGroupName.grab_focus()
            return

        if self.groupEnt == None:
            group = self.parent.ADMIN.lookupGroupByName(newGroupName)
            if group != None:
                messageDialog.show_message_dialog(_("A group with name '%s' already exists." % newGroupName))
                self.ready()
                self.groupWinGroupName.set_text("")
                self.groupWinGroupName.grab_focus()
                return

#        currentGroupName = self.groupEnt.get(libuser.GROUPNAME)[0]
#
#        if newGroupName != currentGroupName:
#            self.groupEnt.set(libuser.GROUPNAME, newGroupName)
        
        user_list = []
        
        if self.groupEnt == None:
            groupName = newGroupName
        else:
#        group_gidNumber = self.groupEnt.get(libuser.GIDNUMBER)[0]
            groupName = self.groupEnt.get(libuser.GROUPNAME)[0]
        members = self.parent.ADMIN.enumerateUsersByGroup(groupName)
        if not members:
            members = []

        #Let's iterate through the groupStore and see what groups are selected
        iter = self.userStore.get_iter_root()

        while iter:
            val = self.userStore.get_value(iter, 0)
            user = self.userStore.get_value(iter, 1)

            if val:
                if user in members:
                    user_list.insert(0, user)
                else:
#                    try:
#                        userEnt = self.parent.user_dict[user]
#                    except:
#                        userEnt = self.parent.ADMIN.lookupUserByName(user)
#                    user_gidNumber = userEnt.get(libuser.GIDNUMBER)[0]
#                    if user_gidNumber != group_gidNumber:
#                        user_list.append(user)
                    user_list.append(user)
            else:
                if user in members:
#                    userEnt = self.parent.ADMIN.lookupUserByName(user)
                    members.remove(user)
                    
            iter = self.userStore.iter_next(iter)

        if not len(user_list):
            messageDialog.show_message_dialog(_("A group needs at least one member."))
            self.ready()
            self.groupNotebook.set_current_page(1)
            self.userChecklistSW.grab_focus()
            return

        if self.groupEnt == None:
            self.groupEnt = self.parent.ADMIN.initGroup(newGroupName)
            add = 1
        else:
            add = 0
                        
        self.groupEnt.set(libuser.MEMBERNAME, user_list)
        if add:
            self.parent.ADMIN.addGroup(self.groupEnt)
        else:
            self.parent.ADMIN.modifyGroup(self.groupEnt)

        self.parent.refresh_users_and_groups(user_list + [newGroupName])
        self.groupWinReset()
        self.groupWin.hide()

    def toggled_item(self, data, row):
        iter = self.userStore.get_iter(int(row))
        val = self.userStore.get_value(iter, 0)
        self.userStore.set_value(iter, 0, not val)

    def fill_users_list (self, groupEnt):
        self.users = self.parent.ADMIN.enumerateUsers()
        self.users.sort()
        row = 0
        if not groupEnt:
            members = []
        else:
            group = groupEnt.get(libuser.GROUPNAME)[0]
            members = self.parent.ADMIN.enumerateUsersByGroup(group)
            if not members:
                members = []

        for user in self.users:
            iter = self.userStore.append()
            
            if user in members:            
                self.userStore.set_value(iter, 0, gtk.TRUE)
                self.userStore.set_value(iter, 1, user)
            else:
                self.userStore.set_value(iter, 0, gtk.FALSE)
                self.userStore.set_value(iter, 1, user)                
