## groupWindow.py - event handling code for userconf's group window
## Copyright (C) 2001-2003 Red Hat, Inc.
## Copyright (C) 2001-2003 Brent Fox <bfox@redhat.com>
## Copyright (C) 2006-2007 Zarafa LDAP extensions by Zarafa, The Netherlands

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

## Author: Brent Fox

import signal
import gtk
import string
import libuser_zarafa_ldap
libuser = libuser_zarafa_ldap
import mainWindow
import messageDialog
import userGroupCheck

##
## I18N
##
from rhpl.translate import _, N_
import rhpl.translate as translate
domain = "zarafa-config-users"
translate.textdomain (domain)
gtk.glade.bindtextdomain(domain)

busy_cursor = gtk.gdk.Cursor(gtk.gdk.WATCH)
ready_cursor = gtk.gdk.Cursor(gtk.gdk.LEFT_PTR)

class groupWindow:

    def __init__(self, parent, user_clist, group_clist, xml):
        self.parent = parent
        self.group_clist = group_clist
        
        self.groupWin = xml.get_widget('newGroupWindow')
        self.groupWin.connect("delete-event", self.on_groupWin_cancel_button_clicked)
        self.groupWin.set_icon(mainWindow.iconPixbuf)
        self.groupWin.set_position(gtk.WIN_POS_CENTER)
        self.groupWinGroupName = xml.get_widget('newGroupNameEntry')
        self.gidBox = xml.get_widget('gidBox')
#        self.gidCheckButton = xml.get_widget('gidCheckButton')
#        self.gidSpinButton = xml.get_widget('gidSpinButton')
#        self.gidSpinButton.set_range(0, pow(2, 32))
#        self.gidSpinButton.set_value(500)

        xml.signal_connect("on_groupWin_cancel_button_clicked", self.on_groupWin_cancel_button_clicked)
        xml.signal_connect("on_groupWin_ok_button_clicked", self.on_groupWin_ok_button_clicked)
#        xml.signal_connect("on_gidCheckButton_toggled", self.on_gidCheckButton_toggled)

    def busy(self):
        self.groupWin.set_sensitive(gtk.FALSE)
        self.groupWin.window.set_cursor(busy_cursor)

    def ready(self):
        self.groupWin.window.set_cursor(ready_cursor)
        self.groupWin.set_sensitive(gtk.TRUE)

    def groupWinReset(self):
        self.groupWinGroupName.grab_focus()
        self.groupWinGroupName.set_text("")
#        self.gidCheckButton.set_active(gtk.FALSE)
#        self.gidSpinButton.set_value(500)

    def newGroupWin(self):
        self.groupWinReset()
        self.groupWin.show_all()

    #--------Event handlers for group window-----#
    def on_groupWin_cancel_button_clicked(self, *args):
        self.groupWinReset()
        self.groupWin.hide()
        return gtk.TRUE

#    def on_gidCheckButton_toggled(self, *args):
#        self.gidBox.set_sensitive(self.gidCheckButton.get_active())

    def on_groupWin_ok_button_clicked(self, *args):
        self.busy()
        try:
            self._on_groupWin_ok_button_clicked(*args)
            self.ready()
        except:
            self.ready()
            messageDialog.show_ldap_error_dialog()

    def _on_groupWin_ok_button_clicked(self, *args):
        groupName = self.groupWinGroupName.get_text()

        #Check for ascii-only strings
        if not userGroupCheck.isGroupnameOk(groupName, self.groupWinGroupName):
            self.ready()
            self.groupWinGroupName.grab_focus()
            return

        if groupName == "":
            messageDialog.show_message_dialog(_("Please enter a group name."))
            self.ready()
            self.groupWinGroupName.set_text("")
            self.groupWinGroupName.grab_focus()
            return

        group = self.parent.ADMIN.lookupGroupByName(groupName)
        if group != None:
            messageDialog.show_message_dialog(_("A group with name '%s' already exists." %groupName))
            self.ready()
            self.groupWinGroupName.set_text("")
            self.groupWinGroupName.grab_focus()
            return

        groupEnt = self.parent.ADMIN.initGroup(groupName)
        cn = groupEnt.get(libuser.GROUPNAME)[0]

        members = groupEnt.get(libuser.MEMBERNAME)
        if not members:
            members = []
        memberlist = string.join(members, ", ")

        self.parent.ADMIN.addGroup(groupEnt)
        
        self.groupWinReset()
        #self.ready()
        self.groupWin.hide()

        self.parent.refresh_users_and_groups([cn])
