#
# zarafa user management module with libusermodule compatible interface
#
# 
## Copyright (C) 2006-2007 Zarafa LDAP extensions by Zarafa, The Netherlands

# exposed constants

USERNAME = 'USERNAME'
USERPASSWORD = 'USERPASSWORD'
USEREMAIL = 'USEREMAIL'
USERALIASES = 'USERALIASES'
UIDNUMBER = 'UIDNUMBER'
GIDNUMBER = 'GIDNUMBER'
GECOS = 'GECOS'
USERSN = 'USERSN'
USERGIVENNAME = 'USERGIVENNAME'
GROUPNAME = 'GROUPNAME'
GROUPPASSWORD = 'GROUPPASSWORD'
GIDNUMBER = 'GIDNUMBER'
ADMINISTRATORUID = 'ADMINISTRATORUID'
MEMBERUID = 'MEMBERUID'
MEMBERNAME = 'MEMBERNAME'
ENTRYDN = 'DN'
QUOTAOVERRIDE = 'QUOTAOVERRIDE'
QUOTAWARN = 'QUOTAWARN'
QUOTASOFT = 'QUOTASOFT'
QUOTAHARD = 'QUOTAHARD'
ZARAFAADMIN = 'ZARAFAADMIN'
ZARAFAACCOUNT = 'ZARAFAACCOUNT'
ZARAFASHARED = 'ZARAFASHARED'
OBJECTCLASS = 'OBJECTCLASS'

 
class Entity:
    def __init__(self, attrs):
        self.attrs = attrs

    def getattrlist(self):
        return self.attrs.keys()

    def get(self, key):
        if self.attrs.has_key(key): return self.attrs[key]
        else: return None

    def set(self, key, value):
        self.attrs[key] = value

    def add(self, key, value):
        self.attrs[key].append(value)

    def clear(self, key, value):
        self.attrs[key] = []



class ADMIN_interface:
    def __init__(self):
       self.users = [
           Entity({UIDNUMBER: [1001], USERNAME: ['zarafauser'], GIDNUMBER: [100], GECOS: ['Zarafa User']}),
           ]
       self.groups = [
           Entity({GIDNUMBER: [100], GROUPNAME:['users']}),
           ]
       pass

    # User Management

    def enumerateUsersFull(self, filter = None):
        list = self.users
        return list

    def enumerateUsersByGroup(self, groupName):
        list = []
        return list

    def lookupUserById(self, uidNumber):
        return(self.users[0])

    def lookupUserByName(self, userName):
        return(self.users[0])

    def deleteUser(self, userEnt):
        pass

    def setpassUser(self, userEnt, passwd):
        pass

    def initUser(self, userName):
        pass

    def addUser(self, userEnt):
        pass

    def modifyUser(self, userEnt):
        pass


    # Group Management

    def enumerateGroups(self):
        list = self.groups
        return list
  
    def enumerateGroupsFull(self, filter = None):
        list = self.groups
        return list

    def enumerateGroupsByUser(self, userEnt):
        list = self.groups
        return list

    def lookupGroupById(self, gidNumber):
        return(self.groups[0])

    def lookupGroupByName(self, groupName):
        return(self.groups[0])

    def initGroup(self, groupName):
        pass

    def addGroup(self, groupEnt): 
        pass

    def modifyGroup(self, groupEnt):
        pass    


def ADMIN():
    return ADMIN_interface()


def test(MyADMIN):
    uid = MyADMIN.enumerateUsersFull()[0].get(UIDNUMBER)[0]
    username = MyADMIN.enumerateUsersFull()[0].get(USERNAME)[0]
    print "UID:", uid
    print "User name:", username

    # lookup user by id
    myuser = MyADMIN.lookupUserById(uid)
    print myuser.get(USERNAME)[0]
    print myuser.get(GECOS)[0]

    # lookup user by name
    myuser = MyADMIN.lookupUserByName(uid)
    print myuser.get(USERNAME)[0]
    print myuser.get(GECOS)[0]

    # test groups
    gid = MyADMIN.enumerateGroupsFull()[0].get(GIDNUMBER)[0]
    groupname = MyADMIN.enumerateGroupsFull()[0].get(GROUPNAME)[0]
    print "GID:", gid
    print "Group name:", groupname

    # lookup group by gid
    mygroup = MyADMIN.lookupGroupById(gid)
    print mygroup.get(GROUPNAME)[0]

    # lookup group by name
    mygroup = MyADMIN.lookupGroupByName(uid)
    print mygroup.get(GROUPNAME)[0]

if __name__=="__main__":
    MyADMIN = ADMIN()
    test(MyADMIN)
