#
# zarafa ldap user management module with libusermodule compatible interface
#
# 
## Copyright (C) 2006-2007 Zarafa LDAP extensions by Zarafa, The Netherlands


from libuser_interface_zarafa import *
import ldap
import string
from string import lower
import sha 
import md5
from base64 import encodestring 

class ADMIN_ldap(ADMIN_interface):
    def __init__(self, logon_prompt, error_title, error_info):
        self.ldapcon = None
        self.user_map = None
        self.user_dn_map = None
        self.user_groups_map = None
        self.group_map = None
        self.group_dn_map = None
        self.logon_prompt = logon_prompt
        self.error_title = error_title
        self.error_info = error_info
        ADMIN_interface.__init__(self)
        

    def _connect(self):
        global g__LDAPhost
        global g__LDAPport
        global g__LDAPprotocol
        global g__LDAPuser
        global g__LDAPpassword
  
        if self.ldapcon == None:
            if not g__LDAPpassword:
                g__LDAPpassword = self.logon_prompt(g__LDAPuser)
                if g__LDAPpassword == None: raise self.error_title, self.error_info
            if not  g__LDAPprotocol: g__LDAPprotocol = 'ldap'
            url = g__LDAPprotocol + '://' + g__LDAPhost
            if g__LDAPport:
                url += ':' + g__LDAPport
            self.ldapcon = ldap.initialize(url)
            self.ldapcon.simple_bind_s(g__LDAPuser,g__LDAPpassword)

        return self.ldapcon

    def cnIsUserUniqueAttribute(self):
        global g__LDAPattrUserUnique
        if g__LDAPattrUserUnique == 'cn':
            return 1
        else:
            return 0
        
    def enumerateUsersFull(self, filter = None, filterAttribute = None):
        global g__LDAPbase
        global g__LDAPuser_scope
        global g__LDAPuser_search_filter
        global g__LDAPattrUID
        global g__LDAPattrUserUnique
        global g__LDAPattrSN
        global g__LDAPattrGivenName
        global g__LDAPattrDisplayName
        global g__LDAPattrEmailAddress
        global g__LDAPattrEmailAlternateAddress

        if filter == None: searchfilter = '*'
        else: searchfilter = filter
        if filterAttribute == None:
            searchfilterAttribute = g__LDAPattrUID
        else:
            searchfilterAttribute = filterAttribute
        if g__LDAPuser_search_filter:
            searchfilterexp = "(&" + g__LDAPuser_search_filter + "(" + searchfilterAttribute+'='+searchfilter + "))"
        else:
            searchfilterexp = "(" + searchfilterAttribute+'='+searchfilter + ")"
        
        if self._connect():
            results = self.ldapcon.search_s(g__LDAPbase,g__LDAPuser_scope,searchfilterexp,[g__LDAPattrUID,g__LDAPattrDisplayName,g__LDAPattrEmailAddress,'*']) 
            list = []
            if self.user_dn_map == None: self.user_dn_map = {}
            if self.user_map == None: self.user_map = {}
            for result in results:
                if result[1].has_key(g__LDAPattrUID):
                    UID = result[1][g__LDAPattrUID][0]
                else:
                    continue
#                if groupMembers and UID not in groupMembers:
#                    continue
                if result[1].has_key(g__LDAPattrDisplayName):
                    DisplayName = result[1][g__LDAPattrDisplayName][0]
                else:
                    DisplayName = UID
                    
                if result[1].has_key(g__LDAPattrEmailAddress):
                    EmailAddress = result[1][g__LDAPattrEmailAddress][0]
                else:
                    EmailAddress = ''
                    
                if result[1].has_key('objectClass'):
                    objectClass = result[1]['objectClass']
                else:
                    objectClass = ''
                    
                dn = result[0]
                entity = Entity({ENTRYDN: [dn], UIDNUMBER: [1001], USERNAME: [UID], GIDNUMBER: [100], GECOS: [DisplayName], USEREMAIL: [EmailAddress], OBJECTCLASS: objectClass})

                if result[1].has_key(g__LDAPattrEmailAlternateAddress):
                    entity.set(USERALIASES, result[1][g__LDAPattrEmailAlternateAddress])
                else:
                    entity.set(USERALIASES, [])
                     
                if result[1].has_key('zarafaQuotaOverride'):
                    entity.set(QUOTAOVERRIDE, [int(result[1]['zarafaQuotaOverride'][0])])
                else:
                    entity.set(QUOTAOVERRIDE, [0])
                    
                if result[1].has_key(g__LDAPattrSN):
                    entity.set(USERSN, result[1][g__LDAPattrSN])
                else:
                    entity.set(USERSN, [''])
                    
                if result[1].has_key(g__LDAPattrGivenName):
                    entity.set(USERGIVENNAME, result[1][g__LDAPattrGivenName])
                else:
                    entity.set(USERGIVENNAME, [''])
                    
                if result[1].has_key('zarafaQuotaWarn'):
                    entity.set(QUOTAWARN, [int(result[1]['zarafaQuotaWarn'][0])])
                if result[1].has_key('zarafaQuotaSoft'):
                    entity.set(QUOTASOFT, [int(result[1]['zarafaQuotaSoft'][0])])
                if result[1].has_key('zarafaQuotaHard'):
                    entity.set(QUOTAHARD, [int(result[1]['zarafaQuotaHard'][0])])
                if result[1].has_key('zarafaAdmin'):
                    entity.set(ZARAFAADMIN, [int(result[1]['zarafaAdmin'][0])])
                else:
                    entity.set(ZARAFAADMIN, [0])

#                if result[1].has_key('zarafaAccount'):
#                    entity.set(ZARAFAACCOUNT, [int(result[1]['zarafaAccount'][0])])
#                else:
#                    entity.set(ZARAFAACCOUNT, [1])

                if result[1].has_key('zarafaSharedStoreOnly'):
                    entity.set(ZARAFASHARED, [int(result[1]['zarafaSharedStoreOnly'][0])])
                else:
                    entity.set(ZARAFASHARED, [0])

                if result[1].has_key('zarafaSharedStoreOnly'):
                    entity.set(ZARAFASHARED, [int(result[1]['zarafaSharedStoreOnly'][0])])
                else:
                    entity.set(ZARAFASHARED, [0])
                    
                list.append(entity) 
                self.user_map[UID] = entity
                self.user_dn_map[dn] = entity
            return list
        else:
            return None

    def enumerateUsers(self, filter = None):
        listfull = self.enumerateUsersFull()
        list = []
        for userfull in listfull:
            list.append(userfull.get(USERNAME)[0])
        return list

    def lookupUserByName(self, userName):
        list = self.enumerateUsersFull(userName)
        if len(list): return list[0]
        else: return None
        
    def lookupUserByUserUniqueAttribute(self, userUniqueName):
        global g__LDAPattrUserUnique
        list = self.enumerateUsersFull(userUniqueName, g__LDAPattrUserUnique)
        if len(list): return list[0]
        else: return None
    
    def _get_user_map(self):
        return self.user_map

    def _get_user_dn_map(self):
        if self.user_dn_map == None:
            self.enumerateUsersFull()
        return self.user_dn_map
    
    def _get_user_groups_map(self):
        if self.user_groups_map == None:
            self.enumerateGroupsFull()
        return self.user_groups_map
    
    def _get_group_map(self):
        return self.group_map

    def _get_group_dn_map(self):
        return self.group_dn_map

    def initUser(self, userName):
        entity = Entity({USERNAME: [userName]})
        return entity
 
    def addUser(self, userEnt):
        global g__LDAPbase
        global g__LDAPattrUserUnique
        global g__LDAPattrUID
        global g__LDAPattrDisplayName
        global g__LDAPattrEmailAddress
        global g__LDAPrequiredObjectClasses
        if self._connect():
            username = userEnt.get(USERNAME)[0]
            displayname = userEnt.get(GECOS)[0]
            if g__LDAPattrUserUnique == g__LDAPattrDisplayName:
                user_dn = g__LDAPattrUserUnique + '=' + displayname + ',' + g__LDAPbase
            else:
                user_dn = g__LDAPattrUserUnique + '=' + username + ',' + g__LDAPbase
            addObjectsClasses = []            
            if g__LDAPrequiredObjectClasses:
                for requiredObjectClass in string.split(g__LDAPrequiredObjectClasses):
                    addObjectsClasses.append(requiredObjectClass)
            addAttributes = [
                ('objectClass', addObjectsClasses),
                (g__LDAPattrUID, username),
                (g__LDAPattrDisplayName, userEnt.get(GECOS)), 
                ]
            if userEnt.get(USERSN):
                addAttributes.append(
                    (g__LDAPattrSN, userEnt.get(USERSN)),
                    )
                
            if userEnt.get(USERGIVENNAME):
                addAttributes.append(
                    (g__LDAPattrGivenName, userEnt.get(USERGIVENNAME)),
                    )
                
#            if userEnt.get(ZARAFAACCOUNT):
#                addAttributes.append(
#                    ('zarafaAccount', str(1)),
#                    )
#            else:
#                addAttributes.append(
#                    ('zarafaAccount', str(0)),
#                    )

            if userEnt.get(ZARAFASHARED):
                addAttributes.append(
                    ('zarafaSharedStoreOnly', str(1)),
                    )
            else:
                addAttributes.append(
                    ('zarafaSharedStoreOnly', str(0)),
                    )
            if userEnt.get(USEREMAIL) and userEnt.get(USEREMAIL)[0]:
                addAttributes.append(
                    (g__LDAPattrEmailAddress, userEnt.get(USEREMAIL)),
                    )

            self.ldapcon.add_s(user_dn, addAttributes)
            self.lookupUserByName(username)
   
    def modifyUser(self, userEnt):
        global g__LDAPattrUID
        global g__LDAPattrSN
        global g__LDAPattrGivenName
        global g__LDAPattrDisplayName
        global g__LDAPattrEmailAddress
        global g__LDAPattrEmailAlternateAddress
        global g__LDAPrequiredObjectClasses
        global g__LDAPrequiredMailObjectClasses
        
        if self._connect():
            has_mail_address = 0
            user_map = self._get_user_map()
            username = userEnt.get(USERNAME)
            user = user_map[username]
            user_dn = user.get(ENTRYDN)[0]
            modifyAttributes = [
                (ldap.MOD_REPLACE, g__LDAPattrDisplayName, userEnt.get(GECOS)), 
                ]
            if userEnt.get(USERSN):
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, g__LDAPattrSN, userEnt.get(USERSN)),
                    )
            if userEnt.get(USERGIVENNAME):
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, g__LDAPattrGivenName, userEnt.get(USERGIVENNAME)),
                    )
            if userEnt.get(USEREMAIL) and userEnt.get(USEREMAIL)[0]:
                has_mail_address = 1
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, g__LDAPattrEmailAddress, userEnt.get(USEREMAIL)),
                    )
            elif user.get(USEREMAIL) and user.get(USEREMAIL)[0]:
                modifyAttributes.append(
                    (ldap.MOD_DELETE, g__LDAPattrEmailAddress, None),
                    )
            if userEnt.get(USERALIASES) != None and g__LDAPattrEmailAlternateAddress:
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, g__LDAPattrEmailAlternateAddress, userEnt.get(USERALIASES)),
                    )
                
            addObjectsClasses = []            
#            if 'zarafa-user' not in user.get(OBJECTCLASS):
#                addObjectsClasses.append('zarafa-user')
            if g__LDAPrequiredObjectClasses:
                for requiredObjectClass in string.split(g__LDAPrequiredObjectClasses):
                    found = 0
                    for objectClass in user.get(OBJECTCLASS):
                        if lower(requiredObjectClass) == lower(objectClass):
                            found = 1
                    if not found:
                        addObjectsClasses.append(requiredObjectClass)
                        
            if g__LDAPrequiredMailObjectClasses and has_mail_address:
                for requiredObjectClass in string.split(g__LDAPrequiredMailObjectClasses):
                    found = 0
                    for objectClass in user.get(OBJECTCLASS):
                        if lower(requiredObjectClass) == lower(objectClass):
                            found = 1
                    if not found:
                        addObjectsClasses.append(requiredObjectClass)
                    
            if addObjectsClasses:
                modifyAttributes.append( 
                    (ldap.MOD_REPLACE, 'objectClass', user.get(OBJECTCLASS) + addObjectsClasses)
                    )
                
            if userEnt.get(QUOTAOVERRIDE):
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, 'zarafaQuotaOverride', str(1)),
                    )
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, 'zarafaQuotaWarn', str(userEnt.get(QUOTAWARN))),
                    )
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, 'zarafaQuotaSoft', str(userEnt.get(QUOTASOFT))),
                    )
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, 'zarafaQuotaHard', str(userEnt.get(QUOTAHARD))),
                    )
            else:
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, 'zarafaQuotaOverride', str(0)),
                    )
                if user.get(QUOTAWARN):
                    modifyAttributes.append(
                        (ldap.MOD_DELETE, 'zarafaQuotaWarn', None),
                        )
                if user.get(QUOTASOFT):
                    modifyAttributes.append(
                        (ldap.MOD_DELETE, 'zarafaQuotaSoft', None),
                        )
                if user.get(QUOTAHARD):
                    modifyAttributes.append(
                        (ldap.MOD_DELETE, 'zarafaQuotaHard', None),
                        )
                    
            if userEnt.get(ZARAFAADMIN):
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, 'zarafaAdmin', str(1)),
                    )
            else:
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, 'zarafaAdmin', str(0)),
                    )
                
#            if userEnt.get(ZARAFAACCOUNT):
#                modifyAttributes.append(
#                    (ldap.MOD_REPLACE, 'zarafaAccount', str(1)),
#                    )
#            else:
#                modifyAttributes.append(
#                    (ldap.MOD_REPLACE, 'zarafaAccount', str(0)),
#                    )
            
            if userEnt.get(ZARAFASHARED):
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, 'zarafaSharedStoreOnly', str(1)),
                    )
            else:
                modifyAttributes.append(
                    (ldap.MOD_REPLACE, 'zarafaSharedStoreOnly', str(0)),
                    )
            
            self.ldapcon.modify_s(user_dn, modifyAttributes)
        
    def setpassUser(self, userEnt, passwd, crypted):
        global g__LDAPattrUID
        global g__LDAPattrUserPassword
        if self._connect():
            user_map = self._get_user_map()
            username = userEnt.get(USERNAME)[0]
            user = user_map[username]
            user_dn = user.get(ENTRYDN)[0]
            salt = 'salt'
            #ctx = sha.new( passwd ) 
            #ctx.update( salt ) 
            #hash = "{SSHA}" + encodestring( ctx.digest() + salt )[:-1]
            ctx = md5.new( passwd )
            hash = "{MD5}" + encodestring( ctx.digest() )[:-1]
            modifyAttributes = [
                (ldap.MOD_REPLACE, g__LDAPattrUserPassword, hash),
                ]
            self.ldapcon.modify_s(user_dn, modifyAttributes)

    def deleteUser(self, userEnt):
        if self._connect():
            user_map = self._get_user_map()
            username = userEnt.get(USERNAME)[0]
            user = user_map[username]
            user_dn = user.get(ENTRYDN)[0]
            self.ldapcon.delete_s(user_dn)
        
    def enumerateGroupsFull(self, filter = None):
        global g__LDAPgroupbase
        global g__LDAPgroup_scope
        global g__LDAPgroup_search_filter
        global g__LDAPattrCN
        global g__LDAPattrDisplayName
        global g__LDAPattrMemberUID
        global g__LDAPattrMemberUIDRefAttr
        
        if filter == None: searchfilter = '*'
        else: searchfilter = filter
        
        if g__LDAPgroup_search_filter:
            searchfilterexp = "(&" + g__LDAPgroup_search_filter + "(" + g__LDAPattrCN+'='+searchfilter + "))"
        else:
            searchfilterexp = "(" + g__LDAPattrCN+'='+searchfilter + ")"

        if self._connect():
            if self.group_dn_map == None: self.group_dn_map = {}
            if self.group_map == None: self.group_map = {}
            if self.user_groups_map == None: self.user_groups_map = {}
            user_dn_map = self._get_user_dn_map()
            results = self.ldapcon.search_s(g__LDAPgroupbase,g__LDAPgroup_scope,searchfilterexp,[g__LDAPattrCN,g__LDAPattrDisplayName,g__LDAPattrMemberUID,'objectClass']) 
            list = []
            for result in results:
                if result[1].has_key(g__LDAPattrCN):
                    GID = result[1][g__LDAPattrCN][0]
                else:
                    continue
#                if groupMembers and UID not in groupMembers:
#                    continue
                if result[1].has_key(g__LDAPattrDisplayName):
                    DisplayName = result[1][g__LDAPattrDisplayName][0]
                else:
                    DisplayName = GID
                    
                if len(result) > 1 and result[1].has_key(g__LDAPattrMemberUID):
                    groupMembers = result[1][g__LDAPattrMemberUID]
                else:
                    groupMembers = []
                    
                if result[1].has_key('objectClass'):
                    objectClass = result[1]['objectClass']
                else:
                    objectClass = ''

                if g__LDAPattrMemberUIDRefAttr == 'dn':
                    groupMembersCNs = []
                    for groupMember in groupMembers:
                        if user_dn_map.has_key(groupMember):
                            username = self.user_dn_map[groupMember].get(USERNAME)[0]
                            groupMembersCNs.append(username)
                            if not self.user_groups_map.has_key(username): self.user_groups_map[username] = []
                            if GID not in self.user_groups_map[username]: self.user_groups_map[username].append(GID)
                else: 
                    groupMembersCNs = groupMembers
                dn = result[0]
                entity = Entity({ENTRYDN: [dn], GIDNUMBER: [1001], GROUPNAME: [DisplayName], MEMBERNAME: groupMembersCNs, OBJECTCLASS: objectClass})
                self.group_dn_map[dn] = entity
                self.group_map[GID] = entity
                list.append(entity)
            return list
        else:
            return None

    def enumerateGroups(self, filter = None):
        listfull = self.enumerateGroupsFull()
        list = []
        for groupfull in listfull:
            list.append(groupfull.get(GROUPNAME)[0])
        return list

    def enumerateUsersByGroup(self, groupName):
        global g__LDAPgroupbase
        global g__LDAPgroup_scope
        global g__LDAPattrCN
        global g__LDAPattrDisplayName
        global g__LDAPattrMemberUID
        global g__LDAPattrMemberUIDRefAttr

        if self._connect():
            user_dn_map = self._get_user_dn_map()
            groupresults = self.ldapcon.search_s(g__LDAPgroupbase,g__LDAPgroup_scope,g__LDAPattrCN+'='+groupName
,[g__LDAPattrMemberUID,'*']) 
            list = []
            if len(groupresults) > 0 and len(groupresults[0]) > 1 and groupresults[0][1].has_key(g__LDAPattrMemberUID):
                groupMembers = groupresults[0][1][g__LDAPattrMemberUID]
            else:
                groupMembers = []
            if g__LDAPattrMemberUIDRefAttr == 'dn':
                groupMembersCNs = []
                for groupMember in groupMembers:
                    if user_dn_map.has_key(groupMember):
                        groupMembersCNs.append(self.user_dn_map[groupMember].get(USERNAME)[0])
            else: 
                groupMembersCNs = groupMembers
            return groupMembersCNs
        else:
            return None

    def enumerateGroupsByUser(self, userName):
        user_groups_map = self._get_user_groups_map()
        if user_groups_map.has_key(userName): 
            return user_groups_map[userName]
        else: return []
 
    def lookupGroupByName(self, groupName):
        list = self.enumerateGroupsFull(groupName)
        if len(list): return list[0]
        else: return None
    
    def initGroup(self, groupName):
        entity = Entity({GROUPNAME: [groupName]})
        return entity

    def modifyGroupMembers(self, groupEnt):
        global g__LDAPgroupbase
        global g__LDAPattrCN
        global g__LDAPattrDisplayName
        global g__LDAPattrMemberUID
        global g__LDAPattrMemberUIDRefAttr
        global g__LDAPrequiredGroupMemberObjectClasses
        modifyAttributes = []
        if self._connect():
            group_map = self._get_group_map()
            groupname = groupEnt.get(GROUPNAME)[0]
            if group_map.has_key(groupname):
                group = group_map[groupname]
                group_dn = group.get(ENTRYDN)[0]
            member_usernames = groupEnt.get(MEMBERNAME)
            if g__LDAPattrMemberUIDRefAttr == 'dn':
                members = []
                user_map = self._get_user_map()
                for member_username in member_usernames:
                    member_dn = user_map[member_username].get(ENTRYDN)[0]
                    members.append(member_dn)
            else:
                members = member_usernames
            for username in self.user_groups_map.keys():
                if (username not in member_usernames 
                    and self.user_groups_map.has_key(username) 
                    and groupname in self.user_groups_map[username]):
                    del self.user_groups_map[username]
            return members
        
    def addGroup(self, groupEnt):
        global g__LDAPgroupbase
        global g__LDAPattrCN
        global g__LDAPattrDisplayName
        global g__LDAPattrMemberUID
        global g__LDAPattrMemberUIDRefAttr
        global g__LDAPrequiredGroupMemberObjectClasses
        if self._connect():
            groupname = groupEnt.get(GROUPNAME)[0]
            group_dn = g__LDAPattrCN + '=' + groupname + ',' + g__LDAPgroupbase
            members = self.modifyGroupMembers(groupEnt)
            self.ldapcon.add_s(group_dn, [
                ('objectClass', string.split(g__LDAPrequiredGroupMemberObjectClasses)),
                (g__LDAPattrCN, groupname),
                (g__LDAPattrMemberUID, members)
                ])

    def modifyGroup(self, groupEnt):
        global g__LDAPgroupbase
        global g__LDAPattrCN
        global g__LDAPattrDisplayName
        global g__LDAPattrMemberUID
        global g__LDAPattrMemberUIDRefAttr
        global g__LDAPrequiredGroupMemberObjectClasses
        modifyAttributes = []
        if self._connect():
            group_map = self._get_group_map()
            groupname = groupEnt.get(GROUPNAME)[0]
            group = group_map[groupname]
            group_dn = group.get(ENTRYDN)[0]
            member_usernames = groupEnt.get(MEMBERNAME)
            if g__LDAPattrMemberUIDRefAttr == 'dn':
                members = []
                user_map = self._get_user_map()
                for member_username in member_usernames:
                    member_dn = user_map[member_username].get(ENTRYDN)[0]
                    members.append(member_dn)
            else:
                members = member_usernames
            for username in self.user_groups_map.keys():
                if (username not in member_usernames 
                    and self.user_groups_map.has_key(username) 
                    and groupname in self.user_groups_map[username]):
                    del self.user_groups_map[username]
            if members:
                addObjectsClasses = []            
                if g__LDAPrequiredGroupMemberObjectClasses:
                    for requiredObjectClass in string.split(g__LDAPrequiredGroupMemberObjectClasses):
                        found = 0
                        for objectClass in group.get(OBJECTCLASS):
                            if lower(requiredObjectClass) == lower(objectClass):
                                found = 1
                        if not found:
                            addObjectsClasses.append(requiredObjectClass)
                        
                if addObjectsClasses:
                    modifyAttributes.append( 
                        (ldap.MOD_REPLACE, 'objectClass', group.get(OBJECTCLASS) + addObjectsClasses)
                        )

            self.ldapcon.modify_s(group_dn, [
                (ldap.MOD_REPLACE, g__LDAPattrMemberUID, members), 
                ] + modifyAttributes)

    def deleteGroup(self, groupEnt):
        if self._connect():
            group_map = self._get_group_map()
            groupname = groupEnt.get(GROUPNAME)[0]
            group = group_map[groupname]
            group_dn = group.get(ENTRYDN)[0]
            self.ldapcon.delete_s(group_dn)

DEFAULT_CONFIG='/etc/zarafa/ldap.cfg'
DEFAULT_ADMIN_CONFIG='/etc/zarafa/ldapadmin.cfg'

class ConfigFile:
    def __init__(self):
       self.config = {}
       lines = open(DEFAULT_CONFIG).readlines()
       lines = lines + open(DEFAULT_ADMIN_CONFIG).readlines()
       for line in lines:
           if len(line): line = line[:-1]
           if not len(line): continue
           if line[0] == '#': continue
           splits = string.split(line,'=',1)
           attribute=string.strip(splits[0])
           value=string.strip(splits[1])
           self.config[attribute] = value

    def __getitem__(self, attribute):
        if self.config.has_key(attribute): return self.config[attribute]
        else: return None


def admin(logon_prompt, error_title, error_info):
    default_init()
    return ADMIN_ldap(logon_prompt, error_title, error_info)

def _get_scope(scopestr):
    if scopestr == 'base':
        return ldap.SCOPE_BASE
    elif scopestr == 'one':
        return ldap.SCOPE_ONELEVEL
    elif scopestr == 'sub':
        return ldap.SCOPE_SUBTREE
    else:
        return ldap.SCOPE_SUBTREE

def init(cfg=None):
    global g__LDAPhost
    global g__LDAPport
    global g__LDAPprotocol
    global g__LDAPuser
    global g__LDAPpassword
    global g__LDAPbase
    global g__LDAPuser_scope
    global g__LDAPuser_search_filter
    global g__LDAPrequiredObjectClasses
    global g__LDAPrequiredMailObjectClasses
    global g__LDAPattrUserUnique
    global g__LDAPattrUID
    global g__LDAPattrUserPassword
    global g__LDAPattrSN
    global g__LDAPattrGivenName
    global g__LDAPattrDisplayName
    global g__LDAPattrEmailAddress
    global g__LDAPgroupbase
    global g__LDAPgroup_scope
    global g__LDAPgroup_search_filter
    global g__LDAPattrCN
    #global g__LDAPgroupfilter = cfg{}
    global g__LDAPattrMemberUID
    global g__LDAPattrMemberUIDRefAttr
    global g__LDAPrequiredGroupMemberObjectClasses
    global g__LDAPattrEmailAlternateAddress

    cfg = ConfigFile()
    g__LDAPhost = cfg['ldap_host']
    g__LDAPport = cfg['ldap_port']
    g__LDAPprotocol = cfg['ldap_protocol']
    g__LDAPuser = cfg['ldap_bind_user']
    g__LDAPpassword = cfg['ldap_bind_passwd']
    g__LDAPbase = cfg['ldap_user_search_base']
    g__LDAPuser_scope = _get_scope(cfg['ldap_user_scope'])
    g__LDAPuser_search_filter = cfg['ldap_user_search_filter']
    g__LDAPrequiredObjectClasses = cfg['ldap_required_object_classes']
    g__LDAPrequiredMailObjectClasses = cfg['ldap_required_mail_object_classes']
    g__LDAPattrUserUnique = cfg['ldap_user_unique_attribute']
    g__LDAPattrUID = cfg['ldap_loginname_attribute']
    g__LDAPattrUserPassword = cfg['ldap_password_attribute']
    g__LDAPattrSN = cfg['ldap_surname_attribute']
    g__LDAPattrGivenName = cfg['ldap_givenname_attribute']
    g__LDAPattrDisplayName = cfg['ldap_fullname_attribute']
    g__LDAPattrEmailAddress = cfg['ldap_emailaddress_attribute']
    g__LDAPgroupbase = cfg['ldap_group_search_base']
    g__LDAPgroup_scope = _get_scope(cfg['ldap_group_scope'])
    g__LDAPgroup_search_filter = cfg['ldap_group_search_filter']
    g__LDAPattrCN = cfg['ldap_group_unique_attribute'] # / ldap_groupname_attribute
    g__LDAPattrMemberUID = cfg['ldap_groupmembers_attribute']
    g__LDAPattrMemberUIDRefAttr = cfg['ldap_groupmembers_attribute_type']
    g__LDAPrequiredGroupMemberObjectClasses = cfg['ldap_required_group_member_object_classes']
    g__LDAPattrEmailAlternateAddress = cfg['ldap_email_alternate_address_attribute']


def default_init():
    init()


if __name__ == '__main__':
    default_init()
    MyAdmin = admin() 
    MyAdmin.enumerateUsersFull()
    MyAdmin.enumerateGroupsFull()
    MyAdmin.enumerateUsersByGroup('zarafa')
