## messageDialog.py - a message dialog for redhat-config-users
## Copyright (C) 2001-2003 Red Hat, Inc.
## Copyright (C) 2001-2003 Brent Fox <bfox@redhat.com>
## Copyright (C) 2006-2007 Zarafa LDAP extensions by Zarafa, The Netherlands

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

## Author: Brent Fox


import gtk
import sys
import mainWindow

##
## I18N
##
from rhpl.translate import _, N_
import rhpl.translate as translate
import rhpl.executil
domain = "zarafa-config-users"
translate.textdomain (domain)
gtk.glade.bindtextdomain(domain)

def show_message_dialog(text):
    dlg = gtk.MessageDialog(None, 0, gtk.MESSAGE_WARNING, gtk.BUTTONS_OK, text)
    dlg.set_position(gtk.WIN_POS_CENTER)
    dlg.set_modal(gtk.TRUE)
    dlg.set_icon(mainWindow.iconPixbuf)
    dlg.run()
    dlg.destroy()

def show_confirm_dialog(text):
    dlg = gtk.MessageDialog(None, 0, gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO, text)
    dlg.set_position(gtk.WIN_POS_CENTER)
    dlg.set_modal(gtk.TRUE)
    dlg.set_icon(mainWindow.iconPixbuf)
    rc = dlg.run()
    dlg.destroy()
    return rc

def show_ldap_error_dialog():
    show_message_dialog(_("An error occured:") + str(sys.exc_info()[0]) + "\n" + _("Info:") + str(sys.exc_info()[1]))
    
def input_prompt(prompt, default_value, title, validate=None):
    dialog = gtk.Dialog()
    dialog.set_title(title)
    dialog.set_position(gtk.WIN_POS_CENTER)
    dialog.set_icon(mainWindow.iconPixbuf)
    dialog.add_button(gtk.STOCK_OK, 1)
    dialog.add_button(gtk.STOCK_CANCEL, 0)

    table = gtk.Table(rows = 1, columns = 2)
    dialog.vbox.pack_start(table)

    table.set_row_spacings(4)
    table.set_col_spacings(4)

    ret_list = []

    label = gtk.Label(prompt)
    label.set_alignment(1.0, 0.5)
    table.attach(label, 0, 1, 0, 1)

    entry = gtk.Entry()
    entry.set_visibility(gtk.TRUE)
    if default_value:
        entry.set_text(default_value)
    table.attach(entry, 1, 2, 0, 1)

    table.show_all()

    while 1:
        i = dialog.run()
        if i == 1:
            value = entry.get_text()
            if (validate != None and not validate(value)): continue
            dialog.destroy()
            return value
        else:
            break
    dialog.destroy()
    return None

