## userGroupCheck.py - code to make sure that the user/group input is valid
## Copyright (C) 2001-2003 Red Hat, Inc.
## Copyright (C) 2001-2003 Brent Fox <bfox@redhat.com>
## Copyright (C) 2004 Nils Philippsen <nphilipp@redhat.com>
## Copyright (C) 2006-2007 Zarafa LDAP extensions by Zarafa, The Netherlands

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import string
import re
import messageDialog

##
## I18N
##
from rhpl.translate import _, N_
import rhpl.translate as translate
domain = "zarafa-config-users"
translate.textdomain (domain)

def isUsernameOk(str, widget):
    if len(string.strip(str)) == 0:
        messageDialog.show_message_dialog(_("Please enter a user name."))
        widget.set_text("")
        widget.grab_focus()
        return 0        
        
    if len(str) > 32:
        messageDialog.show_message_dialog(_("The user name must be less than 33 characters long."))
        widget.set_text("")
        widget.grab_focus()
        return 0        

#    if str[0] in string.digits:
#        messageDialog.show_message_dialog(_("The user name may not begin with a number."))
#        widget.set_text("")
#        widget.grab_focus()
#        return 0

    for i in str:
        if i == "_" or i == "-":
            #specifically allow "_" and "-"
            continue
        
#        if i in string.whitespace:
#            #Check for whitespace
#            messageDialog.show_message_dialog(_("The user name '%s' contains whitespace.  "
#                                                "Please do not include whitespace in the user name.") % str)
#            widget.set_text("")
#            widget.grab_focus()
#            return 0

#        if i in string.punctuation:
#            messageDialog.show_message_dialog(_("The user name '%s' contains punctuation characters.  "
#                                                "Please do not use punctuation in the user name.") % str)
#            widget.set_text("")
#            widget.grab_focus()
#            return 0

#        if i in string.uppercase:
#            messageDialog.show_message_dialog(_("The user name '%s' contains uppercase characters.  "
#                                                "Please do not use uppercase characters in the user name.") % str)
#            widget.set_text("")
#            widget.grab_focus()
#            return 0

        if i not in string.ascii_letters and i not in string.digits and i != ' ': 
            messageDialog.show_message_dialog(_("The user name '%s' contains invalid "
                                                "characters.  Please use only ASCII characters.") % str)
            widget.set_text("")
            widget.grab_focus()
            return 0
    return 1

def isGroupnameOk(str, widget):
    if len(string.strip(str)) == 0:
        messageDialog.show_message_dialog(_("Please enter a group name."))
        widget.set_text("")
        widget.grab_focus()
        return 0        

    if len(str) > 32:
        messageDialog.show_message_dialog(_("The group name must be less than 17 characters long."))
        widget.set_text("")
        widget.grab_focus()
        return 0        

#    if str[0] in string.digits:
#        messageDialog.show_message_dialog(_("The group name may not begin with a number."))
#        widget.set_text("")
#        widget.grab_focus()
#        return 0

    for i in str:
        if i == "_" or i == "-":
            #specifically allow "_" and "-"
            continue

#        if i in string.whitespace:
#            #Check for whitespace
#            messageDialog.show_message_dialog(_("The group name '%s' contains whitespace.  "
#                                                "Please do not include whitespace in the group name.") % str)
#            widget.set_text("")
#            widget.grab_focus()
#            return 0

#        if i in string.punctuation:
#            messageDialog.show_message_dialog(_("The group name '%s' contains punctuation characters.  "
#                                                "Please do not use punctuation in the group name.") % str)
#            widget.set_text("")
#            widget.grab_focus()
#            return 0

#        if i in string.uppercase:
#            messageDialog.show_message_dialog(_("The group name '%s' contains uppercase characters.  "
#                                                "Please do not use uppercase characters in the group name.") % str)
#            widget.set_text("")
#            widget.grab_focus()
#            return 0

        if i not in string.ascii_letters and i not in string.digits and i != ' ':
            messageDialog.show_message_dialog(_("The group name '%s' contains invalid "
                                                "characters.  Please use only ASCII characters.") % str)
            widget.set_text("")
            widget.grab_focus()
            return 0
    return 1


def isPasswordOk(str, widget):
    for i in str:
        if i not in string.ascii_letters and i not in string.digits and i not in string.punctuation and i not in string.whitespace:
            messageDialog.show_message_dialog(_("The password contains invalid characters.  "
                                                "Please use only ASCII characters."))
            widget.set_text("")
            widget.grab_focus()
            return 0
    return 1

def isNameOk(str, widget):
    try:
        dummy = str.decode ('utf-8')
    except UnicodeDecodeError:
        #have to check for whitespace for gecos, since whitespace is ok
        messageDialog.show_message_dialog(_("The name '%s' contains invalid characters.  "
                                            "Please use only UTF-8 characters.") % str)
        widget.set_text("")
        widget.grab_focus()
        return 0

    if string.find(str, ":") > 0:
            #have to check for colons since /etc/passwd is a colon delimited file
            messageDialog.show_message_dialog(_("The name '%s' contains a colon.  "
                                                "Please do not use colons in the name.") % str)
            widget.set_text("")
            widget.grab_focus()
            return 0
    return 1

def validateEmail(email):

    if len(email) > 6:
        if re.match("^[a-zA-Z0-9][a-zA-Z0-9_\\-\\.]*\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$", email) != None:
            return 1
    messageDialog.show_message_dialog(_("The entry '%s' is not a valid email address") % email)
    return 0

def returnOK(str):
    return 1
