## userProperties.py - event handling code for userconf's user properties
## Copyright (C) 2001-2003 Red Hat, Inc.
## Copyright (C) 2001-2003 Brent Fox <bfox@redhat.com>
## Copyright (C) 2006-2007 Zarafa LDAP extensions by Zarafa, The Netherlands

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

## Author: Brent Fox

import exceptions
import gtk
import gobject
import time
import string
import math
import types
import locale
import rhpl.iconv
#import libuser
import libuser_zarafa_ldap
libuser = libuser_zarafa_ldap
import mainWindow
import messageDialog
import userGroupCheck

import warnings
warnings.filterwarnings("ignore", "", DeprecationWarning, __name__)

##
## I18N
##
from rhpl.translate import _, N_
import rhpl.translate as translate
domain = "zarafa-config-users"
translate.textdomain (domain)
gtk.glade.bindtextdomain(domain)

busy_cursor = gtk.gdk.Cursor(gtk.gdk.WATCH)
ready_cursor = gtk.gdk.Cursor(gtk.gdk.LEFT_PTR)


class userProperties:
    def __init__(self, parent, user_clist, group_clist, xml, selinuxEnabled):
        self.parent = parent
        self.user_clist = user_clist
        self.group_clist = group_clist
        self.primaryGroupList = []

        self.userWin = xml.get_widget('userProperties')
        self.userWin.connect("delete-event", self.on_cancel_button_clicked)
        self.userWin.set_icon(mainWindow.iconPixbuf)
        self.userWinUserName = xml.get_widget('userNameEntry')
        self.userWinUserName.set_sensitive(gtk.FALSE)
        self.userWinSurName = xml.get_widget('surNameEntry')
        self.userWinGivenName = xml.get_widget('givenNameEntry')
        self.userWinFullName = xml.get_widget('fullNameEntry')
        if self.parent.ADMIN.cnIsUserUniqueAttribute():
            self.userWinFullName.set_sensitive(gtk.FALSE)
        self.userWinPassword = xml.get_widget('passwordEntry')
        self.userWinConfirm = xml.get_widget('confirmEntry')
        self.selinuxPropCombo = xml.get_widget("selinuxPropCombo")
        self.selinuxPropCombo.entry.set_property('editable', gtk.FALSE)        
        self.selinuxPropLabel = xml.get_widget("selinuxPropLabel")
        self.userNotebook = xml.get_widget('userNotebook')
        self.lastChangedLabel = xml.get_widget('lastChangedLabel')

        self.groupVBox = xml.get_widget('userPropGroupVBox')
        self.emailAddressVBox = xml.get_widget('userPropEmailAddressVBox')

        self.groupStore = gtk.ListStore(gobject.TYPE_BOOLEAN, gobject.TYPE_STRING)
        self.groupTreeView = gtk.TreeView(self.groupStore)
        self.groupTreeView.set_property("headers-visible", gtk.FALSE)

        self.checkboxrenderer = gtk.CellRendererToggle()
        self.checkboxrenderer.connect("toggled", self.toggled_item)
        col = gtk.TreeViewColumn(None, self.checkboxrenderer, active=0)
        self.groupTreeView.append_column(col)
        col = gtk.TreeViewColumn(None, gtk.CellRendererText(), text=1)
        self.groupTreeView.append_column(col)

        self.groupChecklistSW = gtk.ScrolledWindow()
        self.groupChecklistSW = gtk.ScrolledWindow()
        self.groupChecklistSW.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
        self.groupChecklistSW.set_shadow_type(gtk.SHADOW_IN)
        self.groupChecklistSW.add(self.groupTreeView)           
        self.groupVBox.pack_start(self.groupChecklistSW, gtk.TRUE)

#        self.shells = self.parent.ADMIN.getUserShells()
#        self.shells.sort()

#        self.groupHBox = gtk.HBox(gtk.FALSE, 5)
#        self.primaryGroupCombo = gtk.Combo()
#        self.primaryGroupCombo.entry.set_property('editable', gtk.FALSE)
#        self.groupHBox.pack_start(gtk.Label(_("Primary Group:")), gtk.FALSE)
#        self.groupHBox.pack_start(self.primaryGroupCombo, gtk.TRUE)                                  
#        self.groupVBox.pack_start(self.groupHBox, gtk.FALSE)

        self.zarafaQuotaOverrideCheck = xml.get_widget('zarafaQuotaOverrideCheck')

        #self.zarafaQuotaWarnBox = xml.get_widget('zarafaQuotaWarnBox')
        self.zarafaQuotaWarnSpinButton = xml.get_widget('zarafaQuotaWarnSpinButton')
        self.zarafaQuotaWarnSpinButton.set_range(1, pow(2, 32))
        self.zarafaQuotaWarnSpinButton.set_value(100)

        self.zarafaQuotaSoftSpinButton = xml.get_widget('zarafaQuotaSoftSpinButton')
        self.zarafaQuotaSoftSpinButton.set_range(1, pow(2, 32))
        self.zarafaQuotaSoftSpinButton.set_value(100)
        
        self.zarafaQuotaHardSpinButton = xml.get_widget('zarafaQuotaHardSpinButton')
        self.zarafaQuotaHardSpinButton.set_range(1, pow(2, 32))
        self.zarafaQuotaHardSpinButton.set_value(100)

#        self.zarafaAccountCheck = xml.get_widget('zarafaAccountCheck')
#        self.zarafaAccountCheck.set_sensitive(gtk.FALSE)
        self.zarafaSharedStoreOnlyCheck = xml.get_widget('zarafaSharedStoreOnlyCheck')
        self.zarafaSharedStoreOnlyCheck.set_sensitive(gtk.FALSE)
        self.zarafaAdminCheck = xml.get_widget('zarafaAdminCheck')

        self.emailAddressStore = gtk.ListStore(gobject.TYPE_STRING)
        self.emailAddressTreeView = gtk.TreeView(self.emailAddressStore)
        self.emailAddressTreeView.set_property("headers-visible", gtk.FALSE)
        col = gtk.TreeViewColumn(None, gtk.CellRendererText(), text=0)
        self.emailAddressTreeView.append_column(col)

        self.emailAddressChecklistSW = gtk.ScrolledWindow()
        self.groupChecklistSW = gtk.ScrolledWindow()
        self.emailAddressChecklistSW.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
        self.emailAddressChecklistSW.set_shadow_type(gtk.SHADOW_IN)
        self.emailAddressChecklistSW.add(self.emailAddressTreeView)           
        self.emailAddressVBox.pack_start(self.emailAddressChecklistSW, gtk.TRUE)

        
        xml.signal_connect("on_cancel_button_clicked", self.on_cancel_button_clicked)
        xml.signal_connect("on_set_default_email_address_clicked", self.on_set_default_email_address_clicked)
        xml.signal_connect("on_edit_email_address_clicked", self.on_edit_email_address_clicked)
        xml.signal_connect("on_delete_email_address_clicked", self.on_delete_email_address_clicked)
        xml.signal_connect("on_ok_button_clicked", self.on_ok_button_clicked)
        xml.signal_connect("on_zarafaQuotaOverrideCheck_toggled", self.on_zarafaQuotaOverrideCheck_toggled)
        xml.signal_connect("on_add_email_address_clicked", self.on_add_email_address_clicked)

    def busy(self):
        self.userWin.set_sensitive(gtk.FALSE)
        self.userWin.window.set_cursor(busy_cursor)

    def ready(self):
        self.userWin.window.set_cursor(ready_cursor)
        self.userWin.set_sensitive(gtk.TRUE)

    def userWinReset(self):
        self.userNotebook.set_current_page(0)
        self.userWinUserName.set_text('')
        self.userWinFullName.set_text('')
        self.userWinPassword.set_text('')
        self.userWinConfirm.set_text('')
        #self.userWinHomeDir.set_text('')
        self.groupStore.clear()
        self.emailAddressStore.clear()

        
    def showUserProperties(self, userEnt):
        self.userEnt = userEnt
        self.userWinReset()

        uid = self.userEnt.get(libuser.USERNAME)[0]
        uidNumber = self.userEnt.get(libuser.UIDNUMBER)[0]

        fn = self.userEnt.get(libuser.GECOS)[0]
        #Convert the user fullName into unicode so pygtk2 doesn't truncate strings
        fn = unicode (fn, 'utf-8')
        
        surName = self.userEnt.get(libuser.USERSN)[0]
        surName = unicode (surName, 'utf-8')

        givenName = self.userEnt.get(libuser.USERGIVENNAME)[0]
        givenName = unicode (givenName, 'utf-8')

#        hd = self.userEnt.get(libuser.HOMEDIRECTORY)[0]
#        shell = self.userEnt.get(libuser.LOGINSHELL)[0]

        self.userWinUserName.set_text(uid)
        if uid == "root":
            #Don't allow root uid to be changed
            self.userWinUserName.set_sensitive(gtk.FALSE)

        self.userWinFullName.set_text(fn)
        self.userWinSurName.set_text(surName)
        self.userWinGivenName.set_text(givenName)
        self.userWinPassword.set_text('     ')
        self.userWinConfirm.set_text('     ')

#        if shell not in self.shells:
#            self.shells.append(shell)
#            self.shells.sort()
#            #self.loginShellCombo.set_popdown_strings(self.shells)
#        #self.loginShellCombo.list.select_item(self.shells.index(shell))

        self.fill_groups_list(self.userEnt)
        self.fill_emailAddress_list(self.userEnt)
# FIX        self.set_default_group(self.userEnt)
        self.userWin.show_all()

        #Hide SELinux widgets for now
        self.selinuxPropCombo.hide()
        self.selinuxPropLabel.hide()
        
        if self.userEnt.get(libuser.QUOTAOVERRIDE)[0]:
            self.zarafaQuotaOverrideCheck.set_active(gtk.TRUE)
            self.zarafaQuotaWarnSpinButton.set_value(self.userEnt.get(libuser.QUOTAWARN)[0])
            self.zarafaQuotaSoftSpinButton.set_value(self.userEnt.get(libuser.QUOTASOFT)[0])
            self.zarafaQuotaHardSpinButton.set_value(self.userEnt.get(libuser.QUOTAHARD)[0])
        else:
            self.zarafaQuotaOverrideCheck.set_active(gtk.FALSE)
            self.zarafaQuotaWarnSpinButton.set_value(0)
            self.zarafaQuotaSoftSpinButton.set_value(0)
            self.zarafaQuotaHardSpinButton.set_value(0)

#        if self.userEnt.get(libuser.ZARAFAACCOUNT)[0]:
#            self.zarafaAccountCheck.set_active(gtk.TRUE)
#        else:
#            self.zarafaAccountCheck.set_active(gtk.FALSE)

        if self.userEnt.get(libuser.ZARAFASHARED)[0]:
            self.zarafaSharedStoreOnlyCheck.set_active(gtk.TRUE)
            passwdSensitive = gtk.FALSE
        else:
            self.zarafaSharedStoreOnlyCheck.set_active(gtk.FALSE)
            passwdSensitive = gtk.TRUE
        self.userWinPassword.set_sensitive( passwdSensitive )
        self.userWinConfirm.set_sensitive( passwdSensitive )

        if self.userEnt.get(libuser.ZARAFAADMIN)[0]:
            self.zarafaAdminCheck.set_active(gtk.TRUE)
        else:
            self.zarafaAdminCheck.set_active(gtk.FALSE)

        self.on_zarafaQuotaOverrideCheck_toggled()

    def on_zarafaQuotaOverrideCheck_toggled(self, *args):
        self.zarafaQuotaWarnSpinButton.set_sensitive(self.zarafaQuotaOverrideCheck.get_active())
        self.zarafaQuotaSoftSpinButton.set_sensitive(self.zarafaQuotaOverrideCheck.get_active())
        self.zarafaQuotaHardSpinButton.set_sensitive(self.zarafaQuotaOverrideCheck.get_active())

    def on_add_email_address_clicked(self, *args):        
        emailAddress = messageDialog.input_prompt(_("e-mail:"), None, _("Add e-mail:"), userGroupCheck.validateEmail)
        if emailAddress:
            iter = self.emailAddressStore.append()
            self.emailAddressStore.set_value(iter, 0, emailAddress)
            
    def on_set_default_email_address_clicked(self, *args):
        if self.emailAddressTreeView.get_selection().get_selected():
            data, iter = self.emailAddressTreeView.get_selection().get_selected()
            if iter:
                emailAddress = self.emailAddressStore.get_value(iter, 0)
                iterroot = self.emailAddressStore.get_iter_root()
                self.emailAddressStore.move_after(iter, None)
        
    def on_edit_email_address_clicked(self, *args):
        if self.emailAddressTreeView.get_selection().get_selected():
            data, iter = self.emailAddressTreeView.get_selection().get_selected()
            if iter:
                emailAddress = self.emailAddressStore.get_value(iter, 0)
                emailAddress = messageDialog.input_prompt(_("e-mail:"), emailAddress, _("Edit e-mail:"), userGroupCheck.validateEmail)
                if emailAddress:
                    self.emailAddressStore.set_value(iter, 0, emailAddress)

    def on_delete_email_address_clicked(self, *args):
        if self.emailAddressTreeView.get_selection().get_selected():
            data, iter = self.emailAddressTreeView.get_selection().get_selected()
            if iter:
                emailAddress = self.emailAddressStore.get_value(iter, 0)
                self.emailAddressStore.remove(iter)


    def on_cancel_button_clicked(self, *args):
        self.userWinReset()
        self.userWin.hide()
        return gtk.TRUE

    def on_ok_button_clicked(self, *args):
        self.busy()
        try:
            self._on_ok_button_clicked(*args)
            self.ready()
        except:
            self.ready()
            messageDialog.show_ldap_error_dialog()

    def _on_ok_button_clicked(self, *args):
        #The logic here is kind of complicated, but I'll try to explain
        uid = self.userWinUserName.get_text()
        
        userName = self.userEnt.get(libuser.USERNAME)[0]
        surName = self.userWinSurName.get_text()
        givenName = self.userWinGivenName.get_text()
        gecos = self.userWinFullName.get_text()
        pw = self.userWinPassword.get_text()
        confirm = self.userWinConfirm.get_text()

        #Check for UTF-8-only strings
        if not userGroupCheck.isUsernameOk(uid, self.userWinUserName):
            self.ready()
            self.userWinUserName.grab_focus()
            return

        if not userGroupCheck.isNameOk(gecos, self.userWinFullName):
            self.ready()
            self.userWinFullName.grab_focus()
            return

        #hd = self.userWinHomeDir.get_text()
        #shell = self.loginShellCombo.entry.get_text()
        primaryGroup = self.userEnt.get(libuser.GIDNUMBER)[0]

        if pw == confirm == '     ':
            pass
        elif pw == confirm and len (pw) >= 6:
            #Check for ascii-only strings
            if not userGroupCheck.isPasswordOk(pw, self.userWinPassword):
                self.ready()
                self.userWinPassword.grab_focus()
                return

            if not userGroupCheck.isPasswordOk(confirm, self.userWinConfirm):
                self.ready()
                self.userWinConfirm.grab_focus()
                return

            self.parent.ADMIN.setpassUser(self.userEnt, pw, 0)
        else:
            if not pw and not confirm:
                messageDialog.show_message_dialog(_("Please enter a password for the user."))
            
                self.ready()
                self.userNotebook.set_current_page(0)
                self.userWinPassword.set_text("")
                self.userWinConfirm.set_text("")
                self.userWinPassword.grab_focus()
                return
            elif len (pw) < 6:
                messageDialog.show_message_dialog(_("The password is too short.  Please "
                                                    "use at least 6 characters."))
                self.ready()
                self.userNotebook.set_current_page(0)
                self.userWinPassword.set_text("")
                self.userWinConfirm.set_text("")
                self.userWinPassword.grab_focus()
                return
            else:
                messageDialog.show_message_dialog(_("Passwords do not match."))

                self.ready()
                self.userNotebook.set_current_page(0)
                self.userWinPassword.set_text("")
                self.userWinConfirm.set_text("")
                self.userWinPassword.grab_focus()                
                return

        if self.zarafaQuotaOverrideCheck.get_active():
            self.userEnt.set(libuser.QUOTAOVERRIDE, 1)
            self.userEnt.set(libuser.QUOTAWARN, int(self.zarafaQuotaWarnSpinButton.get_value()))
            self.userEnt.set(libuser.QUOTASOFT, int(self.zarafaQuotaSoftSpinButton.get_value()))
            self.userEnt.set(libuser.QUOTAHARD, int(self.zarafaQuotaHardSpinButton.get_value()))
        else:
            self.userEnt.set(libuser.QUOTAOVERRIDE, 0)
            
#        if self.zarafaAccountCheck.get_active():
#            self.userEnt.set(libuser.ZARAFAACCOUNT, 1)
#        else:
#            self.userEnt.set(libuser.ZARAFAACCOUNT, 0)
            
        if self.zarafaSharedStoreOnlyCheck.get_active():
            self.userEnt.set(libuser.ZARAFASHARED, 1)
        else:
            self.userEnt.set(libuser.ZARAFASHARED, 0)
            
        if self.zarafaAdminCheck.get_active():
            self.userEnt.set(libuser.ZARAFAADMIN, 1)
        else:
            self.userEnt.set(libuser.ZARAFAADMIN, 0)
            
        self.userEnt.set(libuser.USERNAME, uid)
        self.userEnt.set(libuser.GECOS, gecos)
        self.userEnt.set(libuser.USERSN, surName)
        self.userEnt.set(libuser.USERGIVENNAME, givenName)
#        self.userEnt.set(libuser.HOMEDIRECTORY, hd)
#        self.userEnt.set(libuser.LOGINSHELL, shell)
        iter = self.emailAddressStore.get_iter_root()
        if iter:
            emailAddress = self.emailAddressStore.get_value(iter, 0)
            if emailAddress:
                self.userEnt.set(libuser.USEREMAIL, [emailAddress])
            iter = self.emailAddressStore.iter_next(iter)    
        emailAliases = []    
        while iter:
            emailAlias = self.emailAddressStore.get_value(iter, 0)
            emailAliases.append(emailAlias)
            iter = self.emailAddressStore.iter_next(iter)
        self.userEnt.set(libuser.USERALIASES, emailAliases)
        
        self.parent.ADMIN.modifyUser(self.userEnt)

        group_list = []
        need_refresh = [uid]
        members = []

        #Let's iterate through the groupStore and see what groups are selected
        iter = self.groupStore.get_iter_root()
            
        while iter:
            val = self.groupStore.get_value(iter, 0)
            group = self.groupStore.get_value(iter, 1)

            try:
                groupEnt = self.parent.group_dict[group]
            except:
                groupEnt = self.parent.ADMIN.lookupGroupByName(group)
            gid = groupEnt.get(libuser.GIDNUMBER)[0]
            members = groupEnt.get(libuser.MEMBERNAME)
            if not members:
                members = []
            elif uid != userName and userName in members:
                # username has changed, remove references to old name
                members.remove (userName)
                groupEnt.set (libuser.MEMBERNAME, members)
                self.parent.ADMIN.modifyGroup (groupEnt)
                need_refresh.append(group)

            if val:
                try:
                   index = members.index(uid)
                except:
                   index = -1

                if index == -1:
                    # the user is not in the group, but should be
                    need_refresh.append(group)
                    if primaryGroup != gid:
                        members.append(uid)
                        groupEnt.set(libuser.MEMBERNAME, members)
                        self.parent.ADMIN.modifyGroup(groupEnt)
            else:
                try:
                   index = members.index(uid)
                except:
                   index = -1
                if index >= 0:
                    # the user is not supposed to be in the group, but is
                    need_refresh.append(group)
                    members.remove(uid)
                    groupEnt.set(libuser.MEMBERNAME, members)
                    self.parent.ADMIN.modifyGroup(groupEnt)

            iter = self.groupStore.iter_next(iter)

#        if self.primaryGroupCombo.entry.get_text() == "":
#            messageDialog.show_message_dialog(_("Please select at least one group for the user."))
#
#            self.ready()
#            self.userNotebook.set_current_page(3)            
#            return            
#        else:
#            primaryGroupEnt = self.parent.ADMIN.lookupGroupByName(self.primaryGroupCombo.entry.get_text())
#            if primaryGroupEnt == None:
#                primaryGroupId = int(self.primaryGroupCombo.entry.get_text())
#            else:
#                primaryGroupId = primaryGroupEnt.get(libuser.GIDNUMBER)[0]
#            self.userEnt.set(libuser.GIDNUMBER, [primaryGroupId])
        
        self.parent.refresh_users_and_groups(need_refresh)
        self.userWinReset()
        self.userWin.hide()

    def toggled_item(self, data, row):
        #Store the current selection temporarily.  Otherwise, calling set_popdown_strings will erase it
        #tempName = self.primaryGroupCombo.entry.get_text()
        
        iter = self.groupStore.get_iter(int(row))
        val = self.groupStore.get_value(iter, 0)
        group = self.groupStore.get_value(iter, 1)
        self.groupStore.set_value(iter, 0, not val)

        #if self.primaryGroupList == [""]:
        #    self.primaryGroupList = []
        #    
        #if val == 0:
        #    if group not in self.primaryGroupList:
        #        self.primaryGroupList.append(group)
        #elif val ==1:
        #    if group in self.primaryGroupList:
        #        self.primaryGroupList.remove(group)
        # 
        #if self.primaryGroupList == []:
        #    self.primaryGroupList.append("")

        #Sort the list before pushing it into the combo widget    
        #self.primaryGroupList.sort()
        #Push the list into the combo widget
        #self.primaryGroupCombo.set_popdown_strings(self.primaryGroupList)

        #if tempName in self.primaryGroupList:
        #    #If the tempName is still in the list, preserve the current setting
        #    self.primaryGroupCombo.entry.set_text(tempName)
        #else:
        #    #The tempName is no longer in the list, so select the first choice in the list
        #    self.primaryGroupCombo.entry.set_text(self.primaryGroupList[0])

    def fill_groups_list (self, userEnt):
        self.groups = self.parent.ADMIN.enumerateGroups()
        self.groups.sort()
        row = 0
        uid = userEnt.get(libuser.USERNAME)[0]
        usergroups = self.parent.ADMIN.enumerateGroupsByUser(uid)
        self.primaryGroupList = []

        for group in self.groups:
            if group in usergroups:
                iter = self.groupStore.append()
                self.groupStore.set_value(iter, 0, gtk.TRUE)
                self.groupStore.set_value(iter, 1, group)
                self.primaryGroupList.append(group)
            else:
                iter = self.groupStore.append()
                self.groupStore.set_value(iter, 0, gtk.FALSE)
                self.groupStore.set_value(iter, 1, group)

    def fill_emailAddress_list (self, userEnt):
        emailAddress = userEnt.get(libuser.USEREMAIL)[0]
        if emailAddress:
            iter = self.emailAddressStore.append()
            self.emailAddressStore.set_value(iter, 0, emailAddress)

        emailAliases = userEnt.get(libuser.USERALIASES)
        for emailAlias in emailAliases:
            iter = self.emailAddressStore.append()
            self.emailAddressStore.set_value(iter, 0, emailAlias)

    def set_default_group (self, userEnt):
        primaryGroupId = userEnt.get(libuser.GIDNUMBER)[0]        
        primaryGroupEnt = self.parent.ADMIN.lookupGroupById(primaryGroupId)
        if primaryGroupEnt == None:
            primaryGroupName = str(primaryGroupId)
            self.primaryGroupCombo.list.unselect_all()
            self.primaryGroupList.append(primaryGroupName)
            self.primaryGroupCombo.set_popdown_strings(self.primaryGroupList)
            self.primaryGroupCombo.entry.set_text(primaryGroupName)
        else:
            self.primaryGroupCombo.set_popdown_strings(self.primaryGroupList)
            primaryGroupName = primaryGroupEnt.get(libuser.GROUPNAME)[0]
            index = self.primaryGroupList.index(primaryGroupName)
            self.primaryGroupCombo.list.select_item(index)

