## userWindow.py - event handling code for userconf's user window
## Copyright (C) 2001-2003 Red Hat, Inc.
## Copyright (C) 2001-2003 Brent Fox <bfox@redhat.com>
## Copyright (C) 2006-2007 Zarafa LDAP extensions by Zarafa, The Netherlands

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

## Author: Brent Fox

import gtk
import string
import libuser_zarafa_ldap
libuser = libuser_zarafa_ldap
import mainWindow
import messageDialog
import userGroupCheck


##
## I18N
##
from rhpl.translate import _, N_
import rhpl.translate as translate
domain = "zarafa-config-users"
translate.textdomain (domain)
gtk.glade.bindtextdomain(domain)

busy_cursor = gtk.gdk.Cursor(gtk.gdk.WATCH)
ready_cursor = gtk.gdk.Cursor(gtk.gdk.LEFT_PTR)

class userWindow:

    def __init__(self, parent, userStore, group_clist, xml, selinuxEnabled):
        self.parent = parent
        self.userStore = userStore
        self.group_clist = group_clist
        
        self.userWin = xml.get_widget('newUserWindow')
        self.userWin.connect("delete-event", self.on_userWin_cancel_button_clicked)
        self.userWin.set_icon(mainWindow.iconPixbuf)
        self.userWinUserName = xml.get_widget('newUserNameEntry')
        self.userWinSurName = xml.get_widget('newSurNameEntry')
        self.userWinGivenName = xml.get_widget('newGivenNameEntry')
        self.userWinFullName = xml.get_widget('newFullNameEntry')
        self.userWinPrimaryEmail = xml.get_widget('newPrimaryEmailEntry')
        self.userWinPassword = xml.get_widget('newPasswordEntry')
        self.userWinConfirm = xml.get_widget('newConfirmEntry')
#        self.userWinZarafaAccountCheck = xml.get_widget('newZarafaAccountCheck')
        self.userWinZarafaSharedStoreOnlyCheck = xml.get_widget('newZarafaSharedStoreOnlyCheck')
#        self.userWinHomeDir = xml.get_widget('newHomeDirEntry')
#        self.loginShellCombo = xml.get_widget('newLoginShellCombo')
#        self.loginShellCombo.entry.set_property('editable', gtk.FALSE)
#        self.selinuxCombo = xml.get_widget("selinuxCombo")
#        self.selinuxCombo.entry.set_property('editable', gtk.FALSE)        
#        self.selinuxLabel = xml.get_widget("selinuxLabel")
#        self.newGroupCheck = xml.get_widget('newGroupCheck')
        self.passwordLabel = xml.get_widget('passwordLabel')
#        self.homeDirHbox = xml.get_widget('homeDirHbox')
#        self.homeDirCheck = xml.get_widget('homeDirCheck')
#        self.uidCheckButton = xml.get_widget('uidCheckButton')
#        self.uidBox = xml.get_widget('uidBox')
#        self.uidSpinButton = xml.get_widget('uidSpinButton')
#        self.uidSpinButton.set_range(0, pow(2, 32))
#        self.uidSpinButton.set_value(500)

#        if not selinuxEnabled:
#            self.selinuxCombo.set_sensitive(gtk.FALSE)
#            self.selinuxLabel.set_sensitive(gtk.FALSE)

#        self.selinuxRoleDict = { _("User"): "user_r", _("Staff") : "staff_r",
#                                 _("System Administrator") : "sysadm_r"}
#        roles = self.selinuxRoleDict.keys()
#        roles.sort()
#        self.selinuxCombo.set_popdown_strings(roles)
#        self.selinuxCombo.list.select_item(2)

#        self.shells = self.parent.ADMIN.getUserShells()
#        self.shells.sort()
#        self.loginShellCombo.set_popdown_strings(self.shells)
#        default = '/bin/bash'
#        if default in self.shells:
#            self.loginShellCombo.list.select_item(self.shells.index(default))

        xml.signal_connect("on_userWin_cancel_button_clicked", self.on_userWin_cancel_button_clicked)
        xml.signal_connect("on_userWin_ok_button_clicked", self.on_userWin_ok_button_clicked)
        xml.signal_connect("on_newUserNameEntry_focus_out_event", self.on_newUserNameEntry_focus_out_event)
        xml.signal_connect("on_newFullNameEntry_focus_in_event", self.on_newFullNameEntry_focus_in_event)
        xml.signal_connect("on_newPrimaryEmailEntry_focus_out_event", self.on_newPrimaryEmailEntry_focus_out_event)
        xml.signal_connect("on_newZarafaSharedStoreOnlyCheck_toggled", self.on_newZarafaSharedStoreOnlyCheck_toggled)
#        xml.signal_connect("on_uidCheckButton_toggled", self.on_uidCheckButton_toggled)

    #--function to reset the entry widgets in the user screen
    def userWinReset(self):
        self.userWinUserName.grab_focus()
        self.userWinUserName.set_text("")
        self.userWinSurName.set_text("")
        self.userWinGivenName.set_text("")
        self.userWinFullName.set_text("")
        self.userWinPrimaryEmail.set_text("")
        self.userWinPassword.set_text("")
        self.userWinConfirm.set_text("")
#        self.userWinZarafaAccountCheck.set_active(gtk.TRUE)
        self.userWinZarafaSharedStoreOnlyCheck.set_active(gtk.FALSE)
        self.on_newZarafaSharedStoreOnlyCheck_toggled()
#        self.userWinHomeDir.set_text("")
#        self.newGroupCheck.set_active(gtk.TRUE)
#        self.uidCheckButton.set_active(gtk.FALSE)
#        self.homeDirCheck.set_active(gtk.TRUE)
#        try:
#            #Hack to work around what I suspect is a gtk bug
#            self.uidSpinButton.set_value(500)
#        except:
#            pass

#        default = '/bin/bash'
#        if default in self.shells:
#            self.loginShellCombo.list.select_item(self.shells.index(default))

    def busy(self):
        self.userWin.set_sensitive(gtk.FALSE)
        self.userWin.window.set_cursor(busy_cursor)

    def ready(self):
        self.userWin.window.set_cursor(ready_cursor)
        self.userWin.set_sensitive(gtk.TRUE)

    def newUserWin(self, filter):
        self.filter = filter
        self.userWinReset()
        self.userWin.show_all()

#        #Hide SELinux widgets for now
#        self.selinuxCombo.hide()
#        self.selinuxLabel.hide()

    def hideWin(self):
        self.userWin.hide()


    def getUserName(self):
        name = self.userWinUserName.get_text()                
        return name

    def getFullName(self):
        return self.userWinFullName.get_text()

    #--------Event handlers for user window-----#
#    def on_homeDirCheck_toggled(self, *args):
#        self.homeDirHbox.set_sensitive(self.homeDirCheck.get_active())

    def on_newUserNameEntry_focus_out_event(self, *args):
        name = self.userWinUserName.get_text()
#        self.userWinHomeDir.set_text("/home/%s" % name)

    def on_newFullNameEntry_focus_in_event(self, *args):
        fullName = self.userWinFullName.get_text()
        if len(fullName) == 0:
            givenName = self.userWinGivenName.get_text()
            surName = self.userWinSurName.get_text()
            self.userWinFullName.set_text(givenName + " " + surName)
    
    def on_newPrimaryEmailEntry_focus_out_event(self, *args):
        primaryEmail = self.userWinPrimaryEmail.get_text()
        #userGroupCheck.validateEmail(primaryEmail)
        
#    def on_uidCheckButton_toggled(self, *args):
#        self.uidBox.set_sensitive(self.uidCheckButton.get_active())

    def on_newZarafaSharedStoreOnlyCheck_toggled(self, *args):
        if self.userWinZarafaSharedStoreOnlyCheck.get_active():
            passwdSensitive = gtk.FALSE
        else:
            passwdSensitive = gtk.TRUE
        self.userWinPassword.set_sensitive( passwdSensitive )
        self.userWinConfirm.set_sensitive( passwdSensitive )

    def on_userWin_cancel_button_clicked(self, *args):
        self.userWinReset()
        self.userWin.hide()
        return gtk.TRUE

    def on_userWin_ok_button_clicked(self, *args):
        self.busy()
        try:
            self._on_userWin_ok_button_clicked(*args)
            self.ready()
        except:
            self.ready()
            messageDialog.show_ldap_error_dialog()

    def _on_userWin_ok_button_clicked(self, *args):
        userName = self.userWinUserName.get_text()
        surName = self.userWinSurName.get_text()
        givenName = self.userWinGivenName.get_text()
        fullName = self.userWinFullName.get_text()
        primaryEmail = self.userWinPrimaryEmail.get_text()
        pw = self.userWinPassword.get_text ()
        confirm = self.userWinConfirm.get_text ()
#        homeDir = self.userWinHomeDir.get_text()

        #Check for ascii-only strings
        if not userGroupCheck.isUsernameOk(userName, self.userWinUserName):
            self.ready()
            self.userWinUserName.grab_focus()
            return

        if not userGroupCheck.isNameOk(surName, self.userWinSurName):
            self.ready()
            self.userWinSurName.grab_focus()
            return

        if not userGroupCheck.isNameOk(givenName, self.userWinGivenName):
            self.ready()
            self.userWinGivenName.grab_focus()
            return

        if not userGroupCheck.isNameOk(fullName, self.userWinFullName):
            self.ready()
            self.userWinFullName.grab_focus()
            return

        if not userGroupCheck.isPasswordOk(pw, self.userWinPassword):
            self.ready()
            self.userWinPassword.grab_focus()
            return

        if not userGroupCheck.isPasswordOk(confirm, self.userWinConfirm):
            self.ready()
            self.userWinConfirm.grab_focus()
            return

        if userName == "":
            #The user name is blank, so complain
            messageDialog.show_message_dialog(_("Please specify a user name"))
            self.ready()
            self.userWinUserName.grab_focus()
            return

        user = self.parent.ADMIN.lookupUserByName(userName)
        if user != None:
            #This user already exists, so complain
            messageDialog.show_message_dialog(_("An account with username '%s' already exists.") %userName)
            self.ready()
            self.userWinUserName.set_text("")
            self.userWinUserName.grab_focus()
            return
        
        if fullName == "":
            #The user full name is blank, so complain
            messageDialog.show_message_dialog(_("Please specify the user's full name"))
            self.ready()
            self.userWinFullName.grab_focus()
            return

        if self.parent.ADMIN.cnIsUserUniqueAttribute():
            if self.parent.ADMIN.lookupUserByUserUniqueAttribute(fullName) != None:
                #This user's full name already exists, so complain
                messageDialog.show_message_dialog(_("An account with a user full name '%s' already exists.") % fullName)
                self.ready()
                self.userWinFullName.set_text("")
                self.userWinFullName.grab_focus()
                return
            
        if not userGroupCheck.validateEmail(primaryEmail):
            self.ready()
            self.userWinPrimaryEmail.grab_focus()
            return
                
        if self.userWinZarafaSharedStoreOnlyCheck.get_active():
            # no password on shared store
            pass
        elif pw == confirm and len (pw) >= 6:
            #If the passwords match, go on
            pass
        else:
            #The passwords don't match, so complain
            if not pw and not confirm:
                messageDialog.show_message_dialog(_("Please enter a password for the user."))
                self.ready()
                self.userWinPassword.set_text("")
                self.userWinConfirm.set_text("")                
                self.userWinPassword.grab_focus()
                return

            elif len (pw) < 6:
                messageDialog.show_message_dialog(_("The password is too short.  Please "
                                                    "use at least 6 characters."))
                self.ready()
                self.userWinPassword.set_text("")
                self.userWinConfirm.set_text("")                
                self.userWinPassword.grab_focus()
                return

            else:
                messageDialog.show_message_dialog(_("The passwords do not match."))
                self.ready()
                self.userWinPassword.set_text("")
                self.userWinConfirm.set_text("")                
                self.userWinPassword.grab_focus()
                return


        userEnt = self.parent.ADMIN.initUser(userName)
        userEnt.set(libuser.GECOS, [fullName])
        userEnt.set(libuser.USERSN, [surName])
        userEnt.set(libuser.USERGIVENNAME, [givenName])
        userEnt.set(libuser.USEREMAIL, [primaryEmail])
        
#        if self.userWinZarafaAccountCheck.get_active():
#            userEnt.set(libuser.ZARAFAACCOUNT, 1)
#        else:
#            userEnt.set(libuser.ZARAFAACCOUNT, 0)
            
        if self.userWinZarafaSharedStoreOnlyCheck.get_active():
            userEnt.set(libuser.ZARAFASHARED, 1)
        else:
            userEnt.set(libuser.ZARAFASHARED, 0)

        self.parent.ADMIN.addUser(userEnt)
        if not self.userWinZarafaSharedStoreOnlyCheck.get_active():
            self.parent.ADMIN.setpassUser(userEnt, pw, 0)

        self.userWinReset()
        self.userWin.hide()

#        self.parent.refresh_users_and_groups([userName, 'users'])
        self.parent.refresh_users_and_groups([userName])

    def addToUsersGroup(self, userEnt, userName):
        groupEnt = self.parent.ADMIN.lookupGroupByName('users')

        if groupEnt == None:
            #The 'users' doesn't exist.  Let's create one
            groupEnt = self.parent.ADMIN.initGroup('users')
            groupEnt.set(libuser.GIDNUMBER, "100")
            self.parent.ADMIN.addGroup(groupEnt)
                                                                                
        cn = groupEnt.get(libuser.GROUPNAME)[0]
 
        # try to get a name to associate with the user's primary gid,
        # and attempt to minimize lookups by caching answers
        try:
            gidNumber = groupEnt.get(libuser.GIDNUMBER)[0]
        except:
            pass

        userEnt.set(libuser.GIDNUMBER, [gidNumber])

        members = groupEnt.get(libuser.MEMBERNAME)
        if not members:
            members = []

        members.append(userName)
        groupEnt.set(libuser.MEMBERNAME, members)
        self.parent.ADMIN.modifyGroup(groupEnt)
