#ifndef ZARAFA_FSCK
#define ZARAFA_FSCK

#include "platform.h"
#include <string>
using namespace std;

#include <mapidefs.h>

/*
 * Global configuration
 */
extern string auto_fix;
extern string auto_del;

class ZarafaFsck {
private:
	ULONG ulFolders;
	ULONG ulEntries;
	ULONG ulProblems;
	ULONG ulFixed;
	ULONG ulDeleted;

	virtual HRESULT ValidateItem(LPMESSAGE lpMessage, string strClass) = 0;

public:
	ZarafaFsck();
	virtual ~ZarafaFsck() { }

	HRESULT ValidateMessage(LPMESSAGE lpMessage,
				string strName, string strClass);
	HRESULT ValidateFolder(LPMAPIFOLDER lpFolder, string strName);

	HRESULT AddMissingProperty(LPMESSAGE lpMessage, std::string strName,
				   ULONG ulTag,__UPV Value);
	HRESULT ReplaceProperty(LPMESSAGE lpMessage, std::string strName,
				ULONG ulTag, std::string strError, __UPV Value);
	HRESULT DeleteMessage(LPMAPIFOLDER lpFolder,
			      LPSPropValue lpItemProperty);

	void PrintStatistics(string title);
};

class ZarafaFsckCalendar : public ZarafaFsck {
private:
	HRESULT ValidateItem(LPMESSAGE lpMessage, string strClass);
	HRESULT ValidateMinimalNamedFields(LPMESSAGE lpMessage);
	HRESULT ValidateTimestamps(LPMESSAGE lpMessage);
	HRESULT ValidateRecurrence(LPMESSAGE lpMessage);
};

class ZarafaFsckTask : public ZarafaFsck {
private:
	HRESULT ValidateItem(LPMESSAGE lpMessage, string strClass);
	HRESULT ValidateMinimalNamedFields(LPMESSAGE lpMessage);
	HRESULT ValidateTimestamps(LPMESSAGE lpMessage);
	HRESULT ValidateCompletion(LPMESSAGE lpMessage);
};

/*
 * Helper functions.
 */
HRESULT allocNamedIdList(ULONG ulSize, LPMAPINAMEID **lpppNameArray);
void freeNamedIdList(LPMAPINAMEID *lppNameArray);

HRESULT ReadProperties(LPMESSAGE lpMessage, ULONG ulCount,
		       ULONG *lpTag, LPSPropValue *lppPropertyArray);
HRESULT ReadNamedProperties(LPMESSAGE lpMessage, ULONG ulCount,
			    LPMAPINAMEID *lppTag,
			    LPSPropTagArray *lppPropertyTagArray,
			    LPSPropValue *lppPropertyArray);

#endif /* ZARAFA_FSCK */
